/*
 * Decompiled with CFR 0.152.
 */
package com.shynieke.ageingmobs.handler;

import com.shynieke.ageingmobs.AgeingMobs;
import com.shynieke.ageingmobs.registry.AgeingRegistry;
import com.shynieke.ageingmobs.registry.ageing.AgeingData;
import com.shynieke.ageingmobs.registry.ageing.criteria.BaseCriteria;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class AgeHandler {
    @SubscribeEvent
    public void ageHandler(TickEvent.WorldTickEvent event) {
        List<AgeingData> ageingList;
        ServerWorld world;
        if (event.phase.equals((Object)TickEvent.Phase.END) && event.side.isServer() && (world = (ServerWorld)event.world).func_82737_E() % 20L == 0L && !(ageingList = AgeingRegistry.ageingList).isEmpty()) {
            Iterator entityIterator = world.getEntities().iterator();
            while (entityIterator.hasNext()) {
                Entity entityIn = (Entity)entityIterator.next();
                for (AgeingData info : ageingList) {
                    if (entityIn instanceof PlayerEntity || !entityIn.func_200600_R().equals(info.getEntity())) continue;
                    if (info.getEntity().equals(info.getTransformedEntity())) {
                        if (!info.getTransformedEntityData().isEmpty()) {
                            this.CheckList(info, entityIn, (World)world);
                            continue;
                        }
                        AgeingMobs.LOGGER.error("An error has occured. A mob can not transform into itself. See id: " + info.getName());
                        if (!AgeingRegistry.ageingList.contains(info)) continue;
                        AgeingRegistry.INSTANCE.removeAgeing(info);
                        continue;
                    }
                    this.CheckList(info, entityIn, (World)world);
                }
            }
        }
    }

    public void CheckList(AgeingData info, Entity entity, World world) {
        if (info.getEntity().equals(info.getTransformedEntity())) {
            if (info.getEntityData().equals((Object)info.getTransformedEntityData())) {
                AgeingMobs.LOGGER.error("Aged Entity nbt identical to the original: " + info.getName());
            } else if (info.getEntityData().isEmpty()) {
                if (!info.getTransformedEntityData().isEmpty()) {
                    CompoundNBT entityTag = AgeingRegistry.entityToNBT(entity);
                    CompoundNBT entityTag2 = info.getTransformedEntityData();
                    if (!entityTag2.isEmpty() && !NBTUtil.func_181123_a((INBT)entityTag2, (INBT)entityTag, (boolean)true)) {
                        this.extraChecks(info, entity, world);
                    }
                } else {
                    AgeingMobs.LOGGER.error("Aged Entity identical to the original: " + info.getName());
                }
            } else if (!info.getTransformedEntityData().isEmpty()) {
                CompoundNBT entityTag = AgeingRegistry.entityToNBT(entity);
                CompoundNBT entityTag2 = info.getEntityData();
                CompoundNBT entityTag3 = info.getTransformedEntityData();
                if (!entityTag2.isEmpty() && !entityTag3.isEmpty() && NBTUtil.func_181123_a((INBT)entityTag2, (INBT)entityTag, (boolean)true) && !NBTUtil.func_181123_a((INBT)entityTag3, (INBT)entityTag, (boolean)true)) {
                    this.extraChecks(info, entity, world);
                }
            } else {
                CompoundNBT entityTag = AgeingRegistry.entityToNBT(entity);
                CompoundNBT entityTag2 = info.getEntityData();
                if (!entityTag2.isEmpty() && NBTUtil.func_181123_a((INBT)entityTag2, (INBT)entityTag, (boolean)true)) {
                    this.extraChecks(info, entity, world);
                }
            }
        } else if (!info.getEntityData().isEmpty()) {
            CompoundNBT entityTag = AgeingRegistry.entityToNBT(entity);
            CompoundNBT entityTag2 = info.getEntityData();
            CompoundNBT entityTag3 = info.getTransformedEntityData();
            if (!entityTag2.isEmpty() && !entityTag3.isEmpty() && NBTUtil.func_181123_a((INBT)entityTag2, (INBT)entityTag, (boolean)true) && !NBTUtil.func_181123_a((INBT)entityTag3, (INBT)entityTag, (boolean)true)) {
                this.extraChecks(info, entity, world);
            }
        } else {
            this.extraChecks(info, entity, world);
        }
    }

    public void extraChecks(AgeingData info, Entity entity, World world) {
        this.checkCriteria(info, entity, world);
    }

    public void checkCriteria(AgeingData info, Entity entity, World world) {
        if (info.getCriteria().length > 0) {
            boolean ableToAge = true;
            for (int i = 0; i < info.getCriteria().length; ++i) {
                BaseCriteria criteria = info.getCriteria()[i];
                if (criteria.isReversing()) {
                    this.BabifyTheMob(info, entity);
                }
                if (criteria.checkCriteria(world, entity)) continue;
                ableToAge = false;
                break;
            }
            if (ableToAge) {
                this.ageTheMob(info, entity, world);
            }
        } else {
            this.ageTheMob(info, entity, world);
        }
    }

    public void ageTheMob(AgeingData info, Entity entity, World world) {
        int maxTime = info.getAgeingTme();
        String uniqueTag = "ageingmobs:" + info.getName();
        CompoundNBT tag = entity.getPersistentData();
        if (!tag.func_74764_b(uniqueTag)) {
            tag.func_74768_a(uniqueTag, 0);
        }
        if (tag.func_74762_e(uniqueTag) >= maxTime) {
            if (info.getEntity().equals(info.getTransformedEntity())) {
                if (!info.getTransformedEntityData().isEmpty()) {
                    Entity agedEntity = info.getTransformedEntity().func_200721_a(world);
                    if (agedEntity != null) {
                        agedEntity.func_82149_j(entity);
                        this.copyEquipment(entity, agedEntity);
                        CompoundNBT entityTag = AgeingRegistry.entityToNBT(entity);
                        CompoundNBT entityTagCopy = entityTag.func_74737_b();
                        CompoundNBT entityTag2 = info.getTransformedEntityData();
                        if (!entityTag2.isEmpty()) {
                            entityTagCopy.func_197643_a(entityTag2);
                            UUID uuid = agedEntity.func_110124_au();
                            agedEntity.func_70020_e(entityTagCopy);
                            agedEntity.func_184221_a(uuid);
                        }
                        world.func_217376_c(agedEntity);
                    } else {
                        AgeingMobs.LOGGER.error("An error has occured. Aged Entity is null, can not create entity with resource location: " + info.getTransformedEntity().getRegistryName());
                    }
                    tag.func_82580_o(uniqueTag);
                    entity.captureDrops(null);
                    entity.func_70106_y();
                }
            } else if (!info.getTransformedEntityData().isEmpty()) {
                Entity agedEntity = info.getTransformedEntity().func_200721_a(world);
                if (agedEntity != null) {
                    agedEntity.func_82149_j(entity);
                    this.copyEquipment(entity, agedEntity);
                    CompoundNBT entityTag = AgeingRegistry.entityToNBT(entity);
                    CompoundNBT entityTagCopy = entityTag.func_74737_b();
                    CompoundNBT entityTag2 = info.getTransformedEntityData();
                    if (!entityTag2.isEmpty()) {
                        UUID uuid = agedEntity.func_110124_au();
                        entityTagCopy.func_197643_a(entityTag2);
                        agedEntity.func_70020_e(entityTag);
                        agedEntity.func_184221_a(uuid);
                    }
                    world.func_217376_c(agedEntity);
                } else {
                    AgeingMobs.LOGGER.error("An error has occured. Aged Entity is null, can not create entity with resource location: " + info.getTransformedEntity().getRegistryName());
                }
                tag.func_82580_o(uniqueTag);
                entity.captureDrops(null);
                entity.func_70106_y();
            } else {
                Entity agedEntity = info.getTransformedEntity().func_200721_a(world);
                if (agedEntity != null) {
                    agedEntity.func_82149_j(entity);
                    this.copyEquipment(entity, agedEntity);
                    world.func_217376_c(agedEntity);
                } else {
                    AgeingMobs.LOGGER.error("An error has occured. Aged Entity is null, can not create entity with resource location: " + info.getTransformedEntity().getRegistryName());
                }
                tag.func_82580_o(uniqueTag);
                entity.captureDrops(null);
                entity.func_70106_y();
            }
        } else {
            int currentAge = tag.func_74762_e(uniqueTag);
            tag.func_74768_a(uniqueTag, ++currentAge);
        }
    }

    public void BabifyTheMob(AgeingData info, Entity entity) {
        String uniqueTag = "ageingmobs:" + info.getName();
        CompoundNBT tag = entity.getPersistentData();
        if (tag.func_74764_b(uniqueTag)) {
            if (tag.func_74762_e(uniqueTag) >= 0) {
                int currentAge = tag.func_74762_e(uniqueTag);
                tag.func_74768_a(uniqueTag, --currentAge);
            } else {
                tag.func_82580_o(uniqueTag);
            }
        }
    }

    public void copyEquipment(Entity original, Entity changedEntity) {
        if (original instanceof MobEntity && changedEntity instanceof MobEntity) {
            MobEntity originalMob = (MobEntity)original;
            MobEntity changedMob = (MobEntity)changedEntity;
            changedMob.func_184201_a(EquipmentSlotType.MAINHAND, originalMob.func_184582_a(EquipmentSlotType.MAINHAND));
            changedMob.func_184201_a(EquipmentSlotType.OFFHAND, originalMob.func_184582_a(EquipmentSlotType.OFFHAND));
            changedMob.func_184201_a(EquipmentSlotType.HEAD, originalMob.func_184582_a(EquipmentSlotType.HEAD));
            changedMob.func_184201_a(EquipmentSlotType.CHEST, originalMob.func_184582_a(EquipmentSlotType.CHEST));
            changedMob.func_184201_a(EquipmentSlotType.LEGS, originalMob.func_184582_a(EquipmentSlotType.LEGS));
            changedMob.func_184201_a(EquipmentSlotType.FEET, originalMob.func_184582_a(EquipmentSlotType.FEET));
        }
    }
}

