/*
 * Decompiled with CFR 0.152.
 */
package com.shynieke.ageingmobs.registry;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.shynieke.ageingmobs.AgeingMobs;
import com.shynieke.ageingmobs.config.AgeingConfig;
import com.shynieke.ageingmobs.registry.ageing.AgeingData;
import com.shynieke.ageingmobs.registry.ageing.criteria.BaseCriteria;
import com.shynieke.ageingmobs.registry.ageing.criteria.BiomeTypeCriteria;
import com.shynieke.ageingmobs.registry.ageing.criteria.BlockBasedCriteria;
import com.shynieke.ageingmobs.registry.ageing.criteria.BossCriteria;
import com.shynieke.ageingmobs.registry.ageing.criteria.DimensionCriteria;
import com.shynieke.ageingmobs.registry.ageing.criteria.LightCriteria;
import com.shynieke.ageingmobs.registry.ageing.criteria.MagicCriteria;
import com.shynieke.ageingmobs.registry.ageing.criteria.WeatherCriteria;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.registries.ForgeRegistries;

public class AgeingRegistry {
    public static AgeingRegistry INSTANCE = new AgeingRegistry();
    public static List<String> nameList = Lists.newArrayList();
    public static List<AgeingData> ageingList = Lists.newArrayList();
    private Map<String, AgeingData> nameToAgeing = Maps.newHashMap();
    private static HashMap<Block, Double> importanceList = new HashMap();
    private static List<ResourceLocation> moonDimensions = Lists.newArrayList();

    public static void initializeAgeing() {
        AgeingData slimeToMagmaCube;
        AgeingData skeletonToWitherSkelly;
        AgeingData cowToMooshroom;
        AgeingData rabbitToKiller;
        AgeingData strayToSkeleton;
        AgeingData skeletonToStray;
        AgeingData guardianToElder;
        AgeingData vindicatorToEvoker;
        int maxLight;
        int minLight;
        LightCriteria lightCriteria;
        BaseCriteria[] criterias;
        int ageingTime;
        boolean criteriaChanged;
        boolean ageingChanged;
        AgeingData villagerToVindicator;
        AgeingData babyHuskToBabyZombie;
        AgeingData huskToZombie;
        AgeingData babyZombieToBabyHusk;
        AgeingData zombieToHusk;
        int ageingTime2;
        AgeingData creeperToCharged;
        Map<String, AgeingData> nameToAgeing = INSTANCE.getNameToAgeing();
        if (!nameList.contains("CreeperToCharged") && ((Boolean)AgeingConfig.SERVER.creeperAgeing.get()).booleanValue()) {
            creeperToCharged = new AgeingData("CreeperToCharged", (EntityType<? extends Entity>)EntityType.field_200797_k, AgeingRegistry.createNBTTag(""), (EntityType<? extends Entity>)EntityType.field_200797_k, AgeingRegistry.createNBTTag("{powered:1b}"), (Integer)AgeingConfig.SERVER.creeperAgeingTime.get());
            creeperToCharged.setCriteria(new BaseCriteria[]{new WeatherCriteria(creeperToCharged, "thunder")});
            INSTANCE.registerAgeing(creeperToCharged);
        } else if (nameList.contains("CreeperToCharged")) {
            creeperToCharged = nameToAgeing.get("CreeperToCharged");
            ageingTime2 = (Integer)AgeingConfig.SERVER.creeperAgeingTime.get();
            if (creeperToCharged.getAgeingTme() != ageingTime2) {
                creeperToCharged.setAgeingTme(ageingTime2);
                INSTANCE.replaceAgeing(creeperToCharged);
            }
        }
        if (!nameList.contains("ZombieToHusk") && ((Boolean)AgeingConfig.SERVER.zombieToHuskAgeing.get()).booleanValue()) {
            zombieToHusk = new AgeingData("ZombieToHusk", (EntityType<? extends Entity>)EntityType.field_200725_aD, AgeingRegistry.createNBTTag(""), (EntityType<? extends Entity>)EntityType.field_200763_C, AgeingRegistry.createNBTTag(""), (Integer)AgeingConfig.SERVER.zombieToHuskAgeingTime.get());
            zombieToHusk.setCriteria(new BaseCriteria[]{new BiomeTypeCriteria(zombieToHusk, BiomeDictionary.Type.HOT)});
            INSTANCE.registerAgeing(zombieToHusk);
        } else if (nameList.contains("ZombieToHusk")) {
            zombieToHusk = nameToAgeing.get("ZombieToHusk");
            ageingTime2 = (Integer)AgeingConfig.SERVER.zombieToHuskAgeingTime.get();
            if (zombieToHusk.getAgeingTme() != ageingTime2) {
                zombieToHusk.setAgeingTme(ageingTime2);
                INSTANCE.replaceAgeing(zombieToHusk);
            }
        }
        if (!nameList.contains("BabyZombieToBabyHusk") && ((Boolean)AgeingConfig.SERVER.zombieToHuskAgeing.get()).booleanValue()) {
            babyZombieToBabyHusk = new AgeingData("BabyZombieToBabyHusk", (EntityType<? extends Entity>)EntityType.field_200725_aD, AgeingRegistry.createNBTTag("{IsBaby:1b}"), (EntityType<? extends Entity>)EntityType.field_200763_C, AgeingRegistry.createNBTTag("{IsBaby:1b}"), (Integer)AgeingConfig.SERVER.zombieToHuskAgeingTime.get());
            babyZombieToBabyHusk.setCriteria(new BaseCriteria[]{new BiomeTypeCriteria(babyZombieToBabyHusk, BiomeDictionary.Type.HOT)});
            INSTANCE.registerAgeing(babyZombieToBabyHusk);
        } else if (nameList.contains("BabyZombieToBabyHusk")) {
            babyZombieToBabyHusk = nameToAgeing.get("BabyZombieToBabyHusk");
            ageingTime2 = (Integer)AgeingConfig.SERVER.zombieToHuskAgeingTime.get();
            if (babyZombieToBabyHusk.getAgeingTme() != ageingTime2) {
                babyZombieToBabyHusk.setAgeingTme(ageingTime2);
                INSTANCE.replaceAgeing(babyZombieToBabyHusk);
            }
        }
        if (!nameList.contains("HuskToZombie") && ((Boolean)AgeingConfig.SERVER.huskToZombieAgeing.get()).booleanValue()) {
            huskToZombie = new AgeingData("HuskToZombie", (EntityType<? extends Entity>)EntityType.field_200763_C, AgeingRegistry.createNBTTag(""), (EntityType<? extends Entity>)EntityType.field_200725_aD, AgeingRegistry.createNBTTag(""), (Integer)AgeingConfig.SERVER.huskToZombieAgeingTime.get());
            huskToZombie.setCriteria(new BaseCriteria[]{new BiomeTypeCriteria(huskToZombie, BiomeDictionary.Type.COLD)});
            INSTANCE.registerAgeing(huskToZombie);
        } else if (nameList.contains("HuskToZombie")) {
            huskToZombie = nameToAgeing.get("HuskToZombie");
            ageingTime2 = (Integer)AgeingConfig.SERVER.huskToZombieAgeingTime.get();
            if (huskToZombie.getAgeingTme() != ageingTime2) {
                huskToZombie.setAgeingTme(ageingTime2);
                INSTANCE.replaceAgeing(huskToZombie);
            }
        }
        if (!nameList.contains("BabyHuskToBabyZombie") && ((Boolean)AgeingConfig.SERVER.huskToZombieAgeing.get()).booleanValue()) {
            babyHuskToBabyZombie = new AgeingData("BabyHuskToBabyZombie", (EntityType<? extends Entity>)EntityType.field_200763_C, AgeingRegistry.createNBTTag("{IsBaby:1b}"), (EntityType<? extends Entity>)EntityType.field_200725_aD, AgeingRegistry.createNBTTag("{IsBaby:1b}"), (Integer)AgeingConfig.SERVER.huskToZombieAgeingTime.get());
            babyHuskToBabyZombie.setCriteria(new BaseCriteria[]{new BiomeTypeCriteria(babyHuskToBabyZombie, BiomeDictionary.Type.COLD)});
            INSTANCE.registerAgeing(babyHuskToBabyZombie);
        } else if (nameList.contains("BabyHuskToBabyZombie")) {
            babyHuskToBabyZombie = nameToAgeing.get("BabyHuskToBabyZombie");
            ageingTime2 = (Integer)AgeingConfig.SERVER.huskToZombieAgeingTime.get();
            if (babyHuskToBabyZombie.getAgeingTme() != ageingTime2) {
                babyHuskToBabyZombie.setAgeingTme(ageingTime2);
                INSTANCE.replaceAgeing(babyHuskToBabyZombie);
            }
        }
        if (!nameList.contains("VillagerToVindicator") && ((Boolean)AgeingConfig.SERVER.villagerToVindicatorAgeing.get()).booleanValue()) {
            villagerToVindicator = new AgeingData("VillagerToVindicator", (EntityType<? extends Entity>)EntityType.field_200756_av, AgeingRegistry.createNBTTag(""), (EntityType<? extends Entity>)EntityType.field_200758_ax, AgeingRegistry.createNBTTag(""), (Integer)AgeingConfig.SERVER.villagerToVindicatorAgeingTime.get());
            villagerToVindicator.setCriteria(new BaseCriteria[]{new LightCriteria(villagerToVindicator, (Integer)AgeingConfig.SERVER.villagerToVindicatorMinLight.get(), (Integer)AgeingConfig.SERVER.villagerToVindicatorMaxLight.get(), false, true)});
            INSTANCE.registerAgeing(villagerToVindicator);
        } else if (nameList.contains("VillagerToVindicator")) {
            villagerToVindicator = nameToAgeing.get("VillagerToVindicator");
            ageingChanged = false;
            criteriaChanged = false;
            ageingTime = (Integer)AgeingConfig.SERVER.villagerToVindicatorAgeingTime.get();
            if (villagerToVindicator.getAgeingTme() != ageingTime) {
                villagerToVindicator.setAgeingTme(ageingTime);
                ageingChanged = true;
            }
            if ((criterias = villagerToVindicator.getCriteria()).length > 0) {
                for (BaseCriteria criteria : criterias) {
                    if (!(criteria instanceof LightCriteria)) continue;
                    lightCriteria = (LightCriteria)criteria;
                    minLight = (Integer)AgeingConfig.SERVER.villagerToVindicatorMinLight.get();
                    maxLight = (Integer)AgeingConfig.SERVER.villagerToVindicatorMaxLight.get();
                    if (lightCriteria.getLightLevelMin() != minLight) {
                        lightCriteria.setLightLevelMin(minLight);
                        criteriaChanged = true;
                    }
                    if (lightCriteria.getLightLevelMax() == maxLight) continue;
                    lightCriteria.setLightLevelMax(maxLight);
                    criteriaChanged = true;
                }
            }
            if (criteriaChanged) {
                villagerToVindicator.setCriteria(criterias);
            }
            if (ageingChanged || criteriaChanged) {
                INSTANCE.replaceAgeing(villagerToVindicator);
            }
        }
        if (!nameList.contains("VindicatorToEvoker") && ((Boolean)AgeingConfig.SERVER.vindicatorToEvokerAgeing.get()).booleanValue()) {
            vindicatorToEvoker = new AgeingData("VindicatorToEvoker", (EntityType<? extends Entity>)EntityType.field_200758_ax, AgeingRegistry.createNBTTag(""), (EntityType<? extends Entity>)EntityType.field_200806_t, AgeingRegistry.createNBTTag(""), (Integer)AgeingConfig.SERVER.vindicatorToEvokerAgeingTime.get());
            vindicatorToEvoker.setCriteria(new BaseCriteria[]{new MagicCriteria(vindicatorToEvoker, 5)});
            INSTANCE.registerAgeing(vindicatorToEvoker);
        } else if (nameList.contains("VindicatorToEvoker")) {
            vindicatorToEvoker = nameToAgeing.get("VindicatorToEvoker");
            ageingTime2 = (Integer)AgeingConfig.SERVER.vindicatorToEvokerAgeingTime.get();
            if (vindicatorToEvoker.getAgeingTme() != ageingTime2) {
                vindicatorToEvoker.setAgeingTme(ageingTime2);
                INSTANCE.replaceAgeing(vindicatorToEvoker);
            }
        }
        if (!nameList.contains("GuardianToElder") && ((Boolean)AgeingConfig.SERVER.guardianToElderAgeing.get()).booleanValue()) {
            guardianToElder = new AgeingData("GuardianToElder", (EntityType<? extends Entity>)EntityType.field_200761_A, AgeingRegistry.createNBTTag(""), (EntityType<? extends Entity>)EntityType.field_200800_n, AgeingRegistry.createNBTTag(""), (Integer)AgeingConfig.SERVER.guardianToElderAgeingTime.get());
            guardianToElder.setCriteria(new BaseCriteria[]{new BossCriteria(guardianToElder, (Integer)AgeingConfig.SERVER.guardianToElderAgeingMax.get(), (Integer)AgeingConfig.SERVER.guardianToElderRange.get())});
            INSTANCE.registerAgeing(guardianToElder);
        } else if (nameList.contains("GuardianToElder")) {
            guardianToElder = nameToAgeing.get("GuardianToElder");
            ageingChanged = false;
            criteriaChanged = false;
            ageingTime = (Integer)AgeingConfig.SERVER.guardianToElderAgeingTime.get();
            if (guardianToElder.getAgeingTme() != ageingTime) {
                guardianToElder.setAgeingTme(ageingTime);
                ageingChanged = true;
            }
            if ((criterias = guardianToElder.getCriteria()).length > 0) {
                for (BaseCriteria criteria : criterias) {
                    if (!(criteria instanceof BossCriteria)) continue;
                    BossCriteria bossCriteria = (BossCriteria)criteria;
                    int ageingMax = (Integer)AgeingConfig.SERVER.guardianToElderAgeingMax.get();
                    int range = (Integer)AgeingConfig.SERVER.guardianToElderRange.get();
                    if (bossCriteria.getMaxInArea() != ageingMax) {
                        bossCriteria.setMaxInArea(ageingMax);
                        criteriaChanged = true;
                    }
                    if (bossCriteria.getCheckRadius() == range) continue;
                    bossCriteria.setCheckRadius(range);
                    criteriaChanged = true;
                }
            }
            if (criteriaChanged) {
                guardianToElder.setCriteria(criterias);
            }
            if (ageingChanged || criteriaChanged) {
                INSTANCE.replaceAgeing(guardianToElder);
            }
        }
        if (!nameList.contains("BabyToZombie") && ((Boolean)AgeingConfig.SERVER.babyToZombieAgeing.get()).booleanValue()) {
            INSTANCE.registerAgeing(new AgeingData("BabyToZombie", (EntityType<? extends Entity>)EntityType.field_200725_aD, AgeingRegistry.createNBTTag("{IsBaby:1b}"), (EntityType<? extends Entity>)EntityType.field_200725_aD, AgeingRegistry.createNBTTag("{IsBaby:0b}"), (Integer)AgeingConfig.SERVER.babyToZombieAgeingTime.get()));
        } else if (nameList.contains("BabyToZombie")) {
            AgeingData babyToZombie = nameToAgeing.get("BabyToZombie");
            ageingTime2 = (Integer)AgeingConfig.SERVER.babyToZombieAgeingTime.get();
            if (babyToZombie.getAgeingTme() != ageingTime2) {
                babyToZombie.setAgeingTme(ageingTime2);
                INSTANCE.replaceAgeing(babyToZombie);
            }
        }
        if (!nameList.contains("BabyToHusk") && ((Boolean)AgeingConfig.SERVER.babyToZombieAgeing.get()).booleanValue()) {
            INSTANCE.registerAgeing(new AgeingData("BabyToHusk", (EntityType<? extends Entity>)EntityType.field_200763_C, AgeingRegistry.createNBTTag("{IsBaby:1b}"), (EntityType<? extends Entity>)EntityType.field_200763_C, AgeingRegistry.createNBTTag("{IsBaby:0b}"), (Integer)AgeingConfig.SERVER.babyToZombieAgeingTime.get()));
        } else if (nameList.contains("BabyToHusk")) {
            AgeingData babyToHusk = nameToAgeing.get("BabyToHusk");
            ageingTime2 = (Integer)AgeingConfig.SERVER.babyToZombieAgeingTime.get();
            if (babyToHusk.getAgeingTme() != ageingTime2) {
                babyToHusk.setAgeingTme(ageingTime2);
                INSTANCE.replaceAgeing(babyToHusk);
            }
        }
        if (!nameList.contains("SkeletonToStray") && ((Boolean)AgeingConfig.SERVER.skeletonToStrayAgeing.get()).booleanValue()) {
            skeletonToStray = new AgeingData("SkeletonToStray", (EntityType<? extends Entity>)EntityType.field_200741_ag, AgeingRegistry.createNBTTag(""), (EntityType<? extends Entity>)EntityType.field_200750_ap, AgeingRegistry.createNBTTag(""), (Integer)AgeingConfig.SERVER.skeletonToStrayAgeingTime.get());
            skeletonToStray.setCriteria(new BaseCriteria[]{new BiomeTypeCriteria(skeletonToStray, BiomeDictionary.Type.COLD)});
            INSTANCE.registerAgeing(skeletonToStray);
        } else if (nameList.contains("SkeletonToStray")) {
            skeletonToStray = nameToAgeing.get("SkeletonToStray");
            ageingTime2 = (Integer)AgeingConfig.SERVER.skeletonToStrayAgeingTime.get();
            if (skeletonToStray.getAgeingTme() != ageingTime2) {
                skeletonToStray.setAgeingTme(ageingTime2);
                INSTANCE.replaceAgeing(skeletonToStray);
            }
        }
        if (!nameList.contains("StrayToSkeleton") && ((Boolean)AgeingConfig.SERVER.strayToSkeletonAgeing.get()).booleanValue()) {
            strayToSkeleton = new AgeingData("StrayToSkeleton", (EntityType<? extends Entity>)EntityType.field_200750_ap, AgeingRegistry.createNBTTag(""), (EntityType<? extends Entity>)EntityType.field_200741_ag, AgeingRegistry.createNBTTag(""), (Integer)AgeingConfig.SERVER.strayToSkeletonAgeingTime.get());
            strayToSkeleton.setCriteria(new BaseCriteria[]{new BiomeTypeCriteria(strayToSkeleton, BiomeDictionary.Type.HOT)});
            INSTANCE.registerAgeing(strayToSkeleton);
        } else if (nameList.contains("StrayToSkeleton")) {
            strayToSkeleton = nameToAgeing.get("StrayToSkeleton");
            ageingTime2 = (Integer)AgeingConfig.SERVER.strayToSkeletonAgeingTime.get();
            if (strayToSkeleton.getAgeingTme() != ageingTime2) {
                strayToSkeleton.setAgeingTme(ageingTime2);
                INSTANCE.replaceAgeing(strayToSkeleton);
            }
        }
        if (!nameList.contains("RabbitToKiller") && ((Boolean)AgeingConfig.SERVER.rabbitToKillerAgeing.get()).booleanValue()) {
            rabbitToKiller = new AgeingData("RabbitToKiller", (EntityType<? extends Entity>)EntityType.field_200736_ab, AgeingRegistry.createNBTTag(""), (EntityType<? extends Entity>)EntityType.field_200736_ab, AgeingRegistry.createNBTTag("{RabbitType:99}"), (Integer)AgeingConfig.SERVER.rabbitToKillerAgeingTime.get());
            rabbitToKiller.setCriteria(new BaseCriteria[]{new LightCriteria(rabbitToKiller, (Integer)AgeingConfig.SERVER.rabbitToKillerMinLight.get(), (Integer)AgeingConfig.SERVER.rabbitToKillerMaxLight.get(), true, false)});
            INSTANCE.registerAgeing(rabbitToKiller);
        } else if (nameList.contains("RabbitToKiller")) {
            rabbitToKiller = nameToAgeing.get("RabbitToKiller");
            ageingChanged = false;
            criteriaChanged = false;
            ageingTime = (Integer)AgeingConfig.SERVER.rabbitToKillerAgeingTime.get();
            if (rabbitToKiller.getAgeingTme() != ageingTime) {
                rabbitToKiller.setAgeingTme(ageingTime);
                ageingChanged = true;
            }
            if ((criterias = rabbitToKiller.getCriteria()).length > 0) {
                for (BaseCriteria criteria : criterias) {
                    if (!(criteria instanceof LightCriteria)) continue;
                    lightCriteria = (LightCriteria)criteria;
                    minLight = (Integer)AgeingConfig.SERVER.rabbitToKillerMinLight.get();
                    maxLight = (Integer)AgeingConfig.SERVER.rabbitToKillerMaxLight.get();
                    if (lightCriteria.getLightLevelMin() != minLight) {
                        lightCriteria.setLightLevelMin(minLight);
                        criteriaChanged = true;
                    }
                    if (lightCriteria.getLightLevelMax() == maxLight) continue;
                    lightCriteria.setLightLevelMax(maxLight);
                    criteriaChanged = true;
                }
            }
            if (criteriaChanged) {
                rabbitToKiller.setCriteria(criterias);
            }
            if (ageingChanged || criteriaChanged) {
                INSTANCE.replaceAgeing(rabbitToKiller);
            }
        }
        if (!nameList.contains("CowToMooshroom") && ((Boolean)AgeingConfig.SERVER.cowToMooshroomAgeing.get()).booleanValue()) {
            cowToMooshroom = new AgeingData("CowToMooshroom", (EntityType<? extends Entity>)EntityType.field_200796_j, AgeingRegistry.createNBTTag(""), (EntityType<? extends Entity>)EntityType.field_200780_T, AgeingRegistry.createNBTTag(""), (Integer)AgeingConfig.SERVER.cowToMooshroomAgeingTime.get());
            cowToMooshroom.setCriteria(new BaseCriteria[]{new BlockBasedCriteria(cowToMooshroom, new Block[]{Blocks.field_150391_bh, Blocks.field_150338_P, Blocks.field_150420_aW, Blocks.field_150337_Q, Blocks.field_150419_aX}, false, (Integer)AgeingConfig.SERVER.cowToMooshroomAgeingRadius.get())});
            INSTANCE.registerAgeing(cowToMooshroom);
        } else if (nameList.contains("CowToMooshroom")) {
            cowToMooshroom = nameToAgeing.get("CowToMooshroom");
            ageingChanged = false;
            criteriaChanged = false;
            ageingTime = (Integer)AgeingConfig.SERVER.cowToMooshroomAgeingTime.get();
            if (cowToMooshroom.getAgeingTme() != ageingTime) {
                cowToMooshroom.setAgeingTme(ageingTime);
                ageingChanged = true;
            }
            if ((criterias = cowToMooshroom.getCriteria()).length > 0) {
                for (BaseCriteria criteria : criterias) {
                    if (!(criteria instanceof BlockBasedCriteria)) continue;
                    BlockBasedCriteria blockCriteria = (BlockBasedCriteria)criteria;
                    int radius = (Integer)AgeingConfig.SERVER.cowToMooshroomAgeingRadius.get();
                    if (blockCriteria.getRadius() == radius) continue;
                    blockCriteria.setRadius(radius);
                    criteriaChanged = true;
                }
            }
            if (criteriaChanged) {
                cowToMooshroom.setCriteria(criterias);
            }
            if (ageingChanged || criteriaChanged) {
                INSTANCE.replaceAgeing(cowToMooshroom);
            }
        }
        if (!nameList.contains("SkeletonToWitherSkelly") && ((Boolean)AgeingConfig.SERVER.skeletonToWitherSkeletonAgeing.get()).booleanValue()) {
            skeletonToWitherSkelly = new AgeingData("SkeletonToWitherSkelly", (EntityType<? extends Entity>)EntityType.field_200741_ag, AgeingRegistry.createNBTTag(""), (EntityType<? extends Entity>)EntityType.field_200722_aA, AgeingRegistry.createNBTTag(""), (Integer)AgeingConfig.SERVER.skeletonToWitherSkeletonAgeingTime.get());
            skeletonToWitherSkelly.setCriteria(new BaseCriteria[]{new DimensionCriteria(skeletonToWitherSkelly, new ResourceLocation[]{new ResourceLocation("the_end")})});
            INSTANCE.registerAgeing(skeletonToWitherSkelly);
        } else if (nameList.contains("SkeletonToWitherSkelly")) {
            skeletonToWitherSkelly = nameToAgeing.get("SkeletonToWitherSkelly");
            ageingTime2 = (Integer)AgeingConfig.SERVER.skeletonToWitherSkeletonAgeingTime.get();
            if (skeletonToWitherSkelly.getAgeingTme() != ageingTime2) {
                skeletonToWitherSkelly.setAgeingTme(ageingTime2);
                INSTANCE.replaceAgeing(skeletonToWitherSkelly);
            }
        }
        if (!nameList.contains("SlimeToMagmaCube") && ((Boolean)AgeingConfig.SERVER.slimeToMagmaCubeAgeing.get()).booleanValue()) {
            slimeToMagmaCube = new AgeingData("SlimeToMagmaCube", (EntityType<? extends Entity>)EntityType.field_200743_ai, AgeingRegistry.createNBTTag(""), (EntityType<? extends Entity>)EntityType.field_200771_K, AgeingRegistry.createNBTTag(""), (Integer)AgeingConfig.SERVER.slimeToMagmaCubeAgeingTime.get());
            slimeToMagmaCube.setCriteria(new BaseCriteria[]{new DimensionCriteria(slimeToMagmaCube, new ResourceLocation[]{new ResourceLocation("the_end")})});
            INSTANCE.registerAgeing(slimeToMagmaCube);
        } else if (nameList.contains("SlimeToMagmaCube")) {
            slimeToMagmaCube = nameToAgeing.get("SlimeToMagmaCube");
            ageingTime2 = (Integer)AgeingConfig.SERVER.slimeToMagmaCubeAgeingTime.get();
            if (slimeToMagmaCube.getAgeingTme() != ageingTime2) {
                slimeToMagmaCube.setAgeingTme(ageingTime2);
                INSTANCE.replaceAgeing(slimeToMagmaCube);
            }
        }
        if (!nameList.contains("BatToVex") && ((Boolean)AgeingConfig.SERVER.batToVexAgeing.get()).booleanValue()) {
            INSTANCE.registerAgeing(new AgeingData("BatToVex", (EntityType<? extends Entity>)EntityType.field_200791_e, AgeingRegistry.createNBTTag(""), (EntityType<? extends Entity>)EntityType.field_200755_au, AgeingRegistry.createNBTTag(""), (Integer)AgeingConfig.SERVER.batToVexAgeingTime.get()));
        } else if (nameList.contains("BatToVex")) {
            AgeingData batToVex = nameToAgeing.get("BatToVex");
            ageingTime2 = (Integer)AgeingConfig.SERVER.batToVexAgeingTime.get();
            if (batToVex.getAgeingTme() != ageingTime2) {
                batToVex.setAgeingTme(ageingTime2);
                INSTANCE.replaceAgeing(batToVex);
            }
        }
    }

    public void registerAgeing(AgeingData ageing) {
        nameList.add(ageing.getName());
        this.nameToAgeing.put(ageing.getName(), ageing);
        this.sortList(ageing);
    }

    public void removeAgeing(AgeingData ageing) {
        nameList.remove(ageing.getName());
        this.nameToAgeing.remove(ageing.getName(), ageing);
        this.removeAndSort(ageing);
    }

    public void replaceAgeing(AgeingData ageing) {
        AgeingData oldAgeing = this.nameToAgeing.get(ageing.getName());
        this.nameToAgeing.remove(oldAgeing.getName(), oldAgeing);
        this.nameToAgeing.put(oldAgeing.getName(), ageing);
        ageingList.remove(oldAgeing);
        this.sortList(ageing);
    }

    public boolean isIDUnique(String ID) {
        return !nameList.contains(ID);
    }

    private void sortList(@Nullable AgeingData ageing) {
        if (ageing != null) {
            ageingList.add(ageing);
        }
        ageingList.sort(Comparator.comparingInt(AgeingData::getAgeingTme));
    }

    private void removeAndSort(@Nullable AgeingData ageing) {
        if (ageing != null) {
            ageingList.remove(ageing);
        }
        ageingList.sort(Comparator.comparingInt(AgeingData::getAgeingTme));
    }

    public static CompoundNBT createNBTTag(String nbtData) {
        CompoundNBT tag = new CompoundNBT();
        try {
            tag = nbtData.startsWith("{") && nbtData.endsWith("}") ? JsonToNBT.func_180713_a((String)nbtData) : JsonToNBT.func_180713_a((String)("{" + nbtData + "}"));
        }
        catch (CommandSyntaxException nbtexception) {
            AgeingMobs.LOGGER.error("nope... " + (Object)((Object)nbtexception));
        }
        return tag;
    }

    public void initializeMagicMap() {
        List magicalBlocks = (List)AgeingConfig.SERVER.magical_blocks.get();
        if (!magicalBlocks.isEmpty()) {
            importanceList = new HashMap();
            for (String blockData : magicalBlocks) {
                String[] blockInfo = blockData.split(";");
                if (blockInfo.length > 2) {
                    AgeingMobs.LOGGER.error("An error has occured. " + blockData + " is using the wrong syntax.");
                    continue;
                }
                if (blockInfo.length != 2) continue;
                String blockName = blockInfo[0];
                double importance = Double.parseDouble(blockInfo[1]);
                Block block = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(blockName));
                if (block == null || importanceList.containsKey(block)) continue;
                importanceList.put(block, importance);
            }
        }
    }

    public HashMap<Block, Double> getMagicMap() {
        return importanceList;
    }

    public void initializeMoonDimensions() {
        List dimensions = (List)AgeingConfig.SERVER.moon_dimensions.get();
        ArrayList<ResourceLocation> dimensionList = new ArrayList<ResourceLocation>();
        for (String string : dimensions) {
            ResourceLocation dim = new ResourceLocation(string);
            if (dimensionList.contains(dim)) continue;
            dimensionList.add(dim);
        }
        moonDimensions = dimensionList;
    }

    public List<ResourceLocation> getMoonDimensions() {
        return moonDimensions;
    }

    public Map<String, AgeingData> getNameToAgeing() {
        return this.nameToAgeing;
    }

    public static CompoundNBT entityToNBT(Entity theEntity) {
        ItemStack itemstack;
        CompoundNBT nbttagcompound = theEntity.func_189511_e(new CompoundNBT());
        if (theEntity instanceof PlayerEntity && !(itemstack = ((PlayerEntity)theEntity).field_71071_by.func_70448_g()).func_190926_b()) {
            nbttagcompound.func_218657_a("SelectedItem", (INBT)itemstack.func_77955_b(new CompoundNBT()));
        }
        return nbttagcompound;
    }
}

