/*
 * Decompiled with CFR 0.152.
 */
package com.shynieke.ageingmobs.registry.ageing.criteria;

import com.shynieke.ageingmobs.AgeingMobs;
import com.shynieke.ageingmobs.registry.AgeingRegistry;
import com.shynieke.ageingmobs.registry.ageing.criteria.BaseCriteria;
import com.shynieke.ageingmobs.registry.ageing.iAgeing;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;

public class MoonCriteria
extends BaseCriteria {
    private String moonPhase;

    public MoonCriteria(iAgeing ageing, String moonPhase) {
        super(ageing);
        this.moonPhase = moonPhase;
    }

    public String getMoonPhase() {
        return this.moonPhase;
    }

    public void setMoonPhase(String time) {
        this.moonPhase = time;
    }

    @Override
    public boolean checkCriteria(World worldIn, Entity entityIn) {
        World entityWorld = entityIn.func_130014_f_();
        if (!entityWorld.func_72935_r()) {
            int moonPhase = entityWorld.func_230315_m_().func_236035_c_(entityWorld.func_72912_H().func_76073_f());
            List<ResourceLocation> moonDimensions = AgeingRegistry.INSTANCE.getMoonDimensions();
            if (!moonDimensions.isEmpty() && moonDimensions.contains(entityWorld.func_234923_W_().func_240901_a_())) {
                int wantedPhase = this.moonPhaseFromString(this.getMoonPhase());
                return moonPhase == wantedPhase;
            }
            AgeingMobs.LOGGER.error("An error has occured. A criteria is using a moon phase but your config has no moon dimensions.");
            return false;
        }
        return false;
    }

    public int moonPhaseFromString(String moonPhase) {
        switch (moonPhase) {
            default: {
                return 0;
            }
            case "Waning Gibbous": {
                return 1;
            }
            case "Last Quarter": {
                return 2;
            }
            case "Waning Crescent": {
                return 3;
            }
            case "New Moon": {
                return 4;
            }
            case "Waxing Crescent": {
                return 5;
            }
            case "First Quarter": {
                return 6;
            }
            case "Waxing Gibbous": 
        }
        return 7;
    }
}

