/*
 * Decompiled with CFR 0.152.
 */
package com.shynieke.ageingmobs.compat.ct;

import com.blamejared.crafttweaker.api.actions.IUndoableAction;
import com.shynieke.ageingmobs.registry.AgeingRegistry;
import com.shynieke.ageingmobs.registry.ageing.AgeingData;

public class ActionRemoveAgeing
implements IUndoableAction {
    public final AgeingData ageingData;
    public final AgeingData oldAgeingData;

    public ActionRemoveAgeing(String ageingID) {
        this.oldAgeingData = this.ageingData = AgeingRegistry.INSTANCE.getByID(ageingID);
    }

    public void apply() {
        if (this.ageingData != null) {
            AgeingRegistry.INSTANCE.removeAgeing(this.ageingData);
        }
    }

    public String describe() {
        if (this.ageingData.getEntity() == null) {
            return "Unknown entity inserted at ageing ID '" + this.ageingData.getName() + "'";
        }
        if (this.ageingData.getTransformedEntity() == null) {
            return "Unknown transform entity inserted at ageing ID '" + this.ageingData.getName() + "'";
        }
        return "Ageing from <" + this.ageingData.getEntity().getRegistryName() + "> to <" + this.ageingData.getTransformedEntity().getRegistryName() + "> has been removed with unique ID: " + this.ageingData.getName();
    }

    public void undo() {
        if (this.oldAgeingData != null) {
            AgeingRegistry.INSTANCE.registerAgeing(this.oldAgeingData);
        }
    }

    public String describeUndo() {
        return "Ageing from <" + this.oldAgeingData.getEntity().getRegistryName() + "> to <" + this.oldAgeingData.getTransformedEntity().getRegistryName() + "> has been re-added, unique ID: " + this.oldAgeingData.getName();
    }
}

