/*
 * Decompiled with CFR 0.152.
 */
package com.shynieke.ageingmobs.compat.ct;

import com.blamejared.crafttweaker.api.actions.IUndoableAction;
import com.shynieke.ageingmobs.compat.ct.impl.MCAgeing;
import com.shynieke.ageingmobs.registry.AgeingRegistry;
import com.shynieke.ageingmobs.registry.ageing.AgeingData;
import net.minecraft.util.ResourceLocation;

public class ActionReplaceAgeing
implements IUndoableAction {
    public final AgeingData ageingData;
    public final AgeingData oldAgeingData;

    public ActionReplaceAgeing(MCAgeing data) {
        this.ageingData = data.getInternal();
        this.oldAgeingData = AgeingRegistry.INSTANCE.getByID(data.getInternal().getName());
    }

    public void apply() {
        ResourceLocation resourceLocation = this.ageingData.getEntity().getRegistryName();
        if (resourceLocation != null && !AgeingRegistry.INSTANCE.isIDUnique(resourceLocation, this.ageingData.getName())) {
            AgeingRegistry.INSTANCE.replaceAgeing(this.ageingData);
        }
    }

    public String describe() {
        if (this.ageingData.getEntity() == null) {
            return "Unknown entity inserted at ageing ID '" + this.ageingData.getName() + "'";
        }
        if (this.ageingData.getTransformedEntity() == null) {
            return "Unknown transform entity inserted at ageing ID '" + this.ageingData.getName() + "'";
        }
        ResourceLocation resourceLocation = this.ageingData.getEntity().getRegistryName();
        if (resourceLocation != null) {
            if (AgeingRegistry.INSTANCE.isIDUnique(resourceLocation, this.ageingData.getName())) {
                return "Ageing from <" + this.ageingData.getEntity().getRegistryName() + "> to <" + this.ageingData.getTransformedEntity().getRegistryName() + "> has been changed";
            }
            return "Ageing from <" + this.ageingData.getEntity().getRegistryName() + "> to <" + this.ageingData.getTransformedEntity().getRegistryName() + "> could not be changed";
        }
        return "Could not replace ageing of %s as the resource location of the given entity is invalid, please check if your MCEntityType is correct";
    }

    public void undo() {
        AgeingRegistry.INSTANCE.replaceAgeing(this.oldAgeingData);
    }

    public String describeUndo() {
        return "Ageing from <" + this.ageingData.getEntity().getRegistryName() + "> to <" + this.ageingData.getTransformedEntity().getRegistryName() + "> has been changed back";
    }
}

