/*
 * Decompiled with CFR 0.152.
 */
package com.shynieke.ageingmobs.registry;

import com.google.common.collect.Lists;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.shynieke.ageingmobs.AgeingMobs;
import com.shynieke.ageingmobs.config.AgeingConfig;
import com.shynieke.ageingmobs.registry.ageing.AgeingData;
import com.shynieke.ageingmobs.registry.ageing.criteria.BaseCriteria;
import com.shynieke.ageingmobs.registry.ageing.criteria.BiomeTypeCriteria;
import com.shynieke.ageingmobs.registry.ageing.criteria.BlockBasedCriteria;
import com.shynieke.ageingmobs.registry.ageing.criteria.BossCriteria;
import com.shynieke.ageingmobs.registry.ageing.criteria.DimensionCriteria;
import com.shynieke.ageingmobs.registry.ageing.criteria.LightCriteria;
import com.shynieke.ageingmobs.registry.ageing.criteria.MagicCriteria;
import com.shynieke.ageingmobs.registry.ageing.criteria.WeatherCriteria;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.registries.ForgeRegistries;

public class AgeingRegistry {
    public static AgeingRegistry INSTANCE = new AgeingRegistry();
    public static LinkedHashMap<ResourceLocation, List<AgeingData>> ageingList = new LinkedHashMap();
    private static HashMap<Block, Double> importanceList = new HashMap();
    private static List<ResourceLocation> moonDimensions = Lists.newArrayList();

    public void initializeAgeing() {
        AgeingData slimeToMagmaCube;
        AgeingData skeletonToWitherSkelly;
        AgeingData cowToMooshroom;
        AgeingData rabbitToKiller;
        AgeingData strayToSkeleton;
        AgeingData skeletonToStray;
        AgeingData guardianToElder;
        AgeingData vindicatorToEvoker;
        int maxLight;
        int minLight;
        LightCriteria lightCriteria;
        BaseCriteria[] criterias;
        int ageingTime;
        boolean criteriaChanged;
        boolean ageingChanged;
        AgeingData villagerToVindicator;
        AgeingData babyHuskToBabyZombie;
        AgeingData huskToZombie;
        AgeingData babyZombieToBabyHusk;
        AgeingData zombieToHusk;
        int ageingTime2;
        AgeingData creeperToCharged;
        if (INSTANCE.isIDUnique(EntityType.field_200797_k.getRegistryName(), "CreeperToCharged") && ((Boolean)AgeingConfig.SERVER.creeperAgeing.get()).booleanValue()) {
            creeperToCharged = new AgeingData("CreeperToCharged", (EntityType<? extends Entity>)EntityType.field_200797_k, AgeingRegistry.createNBTTag(""), (EntityType<? extends Entity>)EntityType.field_200797_k, AgeingRegistry.createNBTTag("{powered:1b}"), (Integer)AgeingConfig.SERVER.creeperAgeingTime.get());
            creeperToCharged.setCriteria(new BaseCriteria[]{new WeatherCriteria(creeperToCharged, "thunder")});
            INSTANCE.registerAgeing(creeperToCharged);
        } else if (!INSTANCE.isIDUnique(EntityType.field_200797_k.getRegistryName(), "CreeperToCharged")) {
            creeperToCharged = INSTANCE.getByID(EntityType.field_200797_k.getRegistryName(), "CreeperToCharged");
            ageingTime2 = (Integer)AgeingConfig.SERVER.creeperAgeingTime.get();
            if (creeperToCharged.getAgeingTme() != ageingTime2) {
                creeperToCharged.setAgeingTme(ageingTime2);
                INSTANCE.replaceAgeing(creeperToCharged);
            }
        }
        if (INSTANCE.isIDUnique(EntityType.field_200725_aD.getRegistryName(), "ZombieToHusk") && ((Boolean)AgeingConfig.SERVER.zombieToHuskAgeing.get()).booleanValue()) {
            zombieToHusk = new AgeingData("ZombieToHusk", (EntityType<? extends Entity>)EntityType.field_200725_aD, AgeingRegistry.createNBTTag(""), (EntityType<? extends Entity>)EntityType.field_200763_C, AgeingRegistry.createNBTTag(""), (Integer)AgeingConfig.SERVER.zombieToHuskAgeingTime.get());
            zombieToHusk.setCriteria(new BaseCriteria[]{new BiomeTypeCriteria(zombieToHusk, BiomeDictionary.Type.HOT)});
            INSTANCE.registerAgeing(zombieToHusk);
        } else if (!INSTANCE.isIDUnique(EntityType.field_200725_aD.getRegistryName(), "ZombieToHusk")) {
            zombieToHusk = INSTANCE.getByID(EntityType.field_200725_aD.getRegistryName(), "ZombieToHusk");
            ageingTime2 = (Integer)AgeingConfig.SERVER.zombieToHuskAgeingTime.get();
            if (zombieToHusk.getAgeingTme() != ageingTime2) {
                zombieToHusk.setAgeingTme(ageingTime2);
                INSTANCE.replaceAgeing(zombieToHusk);
            }
        }
        if (INSTANCE.isIDUnique(EntityType.field_200725_aD.getRegistryName(), "BabyZombieToBabyHusk") && ((Boolean)AgeingConfig.SERVER.zombieToHuskAgeing.get()).booleanValue()) {
            babyZombieToBabyHusk = new AgeingData("BabyZombieToBabyHusk", (EntityType<? extends Entity>)EntityType.field_200725_aD, AgeingRegistry.createNBTTag("{IsBaby:1b}"), (EntityType<? extends Entity>)EntityType.field_200763_C, AgeingRegistry.createNBTTag("{IsBaby:1b}"), (Integer)AgeingConfig.SERVER.zombieToHuskAgeingTime.get());
            babyZombieToBabyHusk.setCriteria(new BaseCriteria[]{new BiomeTypeCriteria(babyZombieToBabyHusk, BiomeDictionary.Type.HOT)});
            INSTANCE.registerAgeing(babyZombieToBabyHusk);
        } else if (!INSTANCE.isIDUnique(EntityType.field_200725_aD.getRegistryName(), "BabyZombieToBabyHusk")) {
            babyZombieToBabyHusk = INSTANCE.getByID(EntityType.field_200725_aD.getRegistryName(), "BabyZombieToBabyHusk");
            ageingTime2 = (Integer)AgeingConfig.SERVER.zombieToHuskAgeingTime.get();
            if (babyZombieToBabyHusk.getAgeingTme() != ageingTime2) {
                babyZombieToBabyHusk.setAgeingTme(ageingTime2);
                INSTANCE.replaceAgeing(babyZombieToBabyHusk);
            }
        }
        if (INSTANCE.isIDUnique(EntityType.field_200763_C.getRegistryName(), "HuskToZombie") && ((Boolean)AgeingConfig.SERVER.huskToZombieAgeing.get()).booleanValue()) {
            huskToZombie = new AgeingData("HuskToZombie", (EntityType<? extends Entity>)EntityType.field_200763_C, AgeingRegistry.createNBTTag(""), (EntityType<? extends Entity>)EntityType.field_200725_aD, AgeingRegistry.createNBTTag(""), (Integer)AgeingConfig.SERVER.huskToZombieAgeingTime.get());
            huskToZombie.setCriteria(new BaseCriteria[]{new BiomeTypeCriteria(huskToZombie, BiomeDictionary.Type.COLD)});
            INSTANCE.registerAgeing(huskToZombie);
        } else if (!INSTANCE.isIDUnique(EntityType.field_200763_C.getRegistryName(), "HuskToZombie")) {
            huskToZombie = INSTANCE.getByID(EntityType.field_200763_C.getRegistryName(), "HuskToZombie");
            ageingTime2 = (Integer)AgeingConfig.SERVER.huskToZombieAgeingTime.get();
            if (huskToZombie.getAgeingTme() != ageingTime2) {
                huskToZombie.setAgeingTme(ageingTime2);
                INSTANCE.replaceAgeing(huskToZombie);
            }
        }
        if (INSTANCE.isIDUnique(EntityType.field_200763_C.getRegistryName(), "BabyHuskToBabyZombie") && ((Boolean)AgeingConfig.SERVER.huskToZombieAgeing.get()).booleanValue()) {
            babyHuskToBabyZombie = new AgeingData("BabyHuskToBabyZombie", (EntityType<? extends Entity>)EntityType.field_200763_C, AgeingRegistry.createNBTTag("{IsBaby:1b}"), (EntityType<? extends Entity>)EntityType.field_200725_aD, AgeingRegistry.createNBTTag("{IsBaby:1b}"), (Integer)AgeingConfig.SERVER.huskToZombieAgeingTime.get());
            babyHuskToBabyZombie.setCriteria(new BaseCriteria[]{new BiomeTypeCriteria(babyHuskToBabyZombie, BiomeDictionary.Type.COLD)});
            INSTANCE.registerAgeing(babyHuskToBabyZombie);
        } else if (!INSTANCE.isIDUnique(EntityType.field_200763_C.getRegistryName(), "BabyHuskToBabyZombie")) {
            babyHuskToBabyZombie = INSTANCE.getByID(EntityType.field_200763_C.getRegistryName(), "BabyHuskToBabyZombie");
            ageingTime2 = (Integer)AgeingConfig.SERVER.huskToZombieAgeingTime.get();
            if (babyHuskToBabyZombie.getAgeingTme() != ageingTime2) {
                babyHuskToBabyZombie.setAgeingTme(ageingTime2);
                INSTANCE.replaceAgeing(babyHuskToBabyZombie);
            }
        }
        if (INSTANCE.isIDUnique(EntityType.field_200756_av.getRegistryName(), "VillagerToVindicator") && ((Boolean)AgeingConfig.SERVER.villagerToVindicatorAgeing.get()).booleanValue()) {
            villagerToVindicator = new AgeingData("VillagerToVindicator", (EntityType<? extends Entity>)EntityType.field_200756_av, AgeingRegistry.createNBTTag(""), (EntityType<? extends Entity>)EntityType.field_200758_ax, AgeingRegistry.createNBTTag(""), (Integer)AgeingConfig.SERVER.villagerToVindicatorAgeingTime.get());
            villagerToVindicator.setCriteria(new BaseCriteria[]{new LightCriteria(villagerToVindicator, (Integer)AgeingConfig.SERVER.villagerToVindicatorMinLight.get(), (Integer)AgeingConfig.SERVER.villagerToVindicatorMaxLight.get(), false, true)});
            INSTANCE.registerAgeing(villagerToVindicator);
        } else if (!INSTANCE.isIDUnique(EntityType.field_200756_av.getRegistryName(), "VillagerToVindicator")) {
            villagerToVindicator = INSTANCE.getByID(EntityType.field_200756_av.getRegistryName(), "VillagerToVindicator");
            ageingChanged = false;
            criteriaChanged = false;
            ageingTime = (Integer)AgeingConfig.SERVER.villagerToVindicatorAgeingTime.get();
            if (villagerToVindicator.getAgeingTme() != ageingTime) {
                villagerToVindicator.setAgeingTme(ageingTime);
                ageingChanged = true;
            }
            if ((criterias = villagerToVindicator.getCriteria()).length > 0) {
                for (BaseCriteria criteria : criterias) {
                    if (!(criteria instanceof LightCriteria)) continue;
                    lightCriteria = (LightCriteria)criteria;
                    minLight = (Integer)AgeingConfig.SERVER.villagerToVindicatorMinLight.get();
                    maxLight = (Integer)AgeingConfig.SERVER.villagerToVindicatorMaxLight.get();
                    if (lightCriteria.getLightLevelMin() != minLight) {
                        lightCriteria.setLightLevelMin(minLight);
                        criteriaChanged = true;
                    }
                    if (lightCriteria.getLightLevelMax() == maxLight) continue;
                    lightCriteria.setLightLevelMax(maxLight);
                    criteriaChanged = true;
                }
            }
            if (criteriaChanged) {
                villagerToVindicator.setCriteria(criterias);
            }
            if (ageingChanged || criteriaChanged) {
                INSTANCE.replaceAgeing(villagerToVindicator);
            }
        }
        if (INSTANCE.isIDUnique(EntityType.field_200758_ax.getRegistryName(), "VindicatorToEvoker") && ((Boolean)AgeingConfig.SERVER.vindicatorToEvokerAgeing.get()).booleanValue()) {
            vindicatorToEvoker = new AgeingData("VindicatorToEvoker", (EntityType<? extends Entity>)EntityType.field_200758_ax, AgeingRegistry.createNBTTag(""), (EntityType<? extends Entity>)EntityType.field_200806_t, AgeingRegistry.createNBTTag(""), (Integer)AgeingConfig.SERVER.vindicatorToEvokerAgeingTime.get());
            vindicatorToEvoker.setCriteria(new BaseCriteria[]{new MagicCriteria(vindicatorToEvoker, 5)});
            INSTANCE.registerAgeing(vindicatorToEvoker);
        } else if (!INSTANCE.isIDUnique(EntityType.field_200758_ax.getRegistryName(), "VindicatorToEvoker")) {
            vindicatorToEvoker = INSTANCE.getByID(EntityType.field_200758_ax.getRegistryName(), "VindicatorToEvoker");
            ageingTime2 = (Integer)AgeingConfig.SERVER.vindicatorToEvokerAgeingTime.get();
            if (vindicatorToEvoker.getAgeingTme() != ageingTime2) {
                vindicatorToEvoker.setAgeingTme(ageingTime2);
                INSTANCE.replaceAgeing(vindicatorToEvoker);
            }
        }
        if (INSTANCE.isIDUnique(EntityType.field_200761_A.getRegistryName(), "GuardianToElder") && ((Boolean)AgeingConfig.SERVER.guardianToElderAgeing.get()).booleanValue()) {
            guardianToElder = new AgeingData("GuardianToElder", (EntityType<? extends Entity>)EntityType.field_200761_A, AgeingRegistry.createNBTTag(""), (EntityType<? extends Entity>)EntityType.field_200800_n, AgeingRegistry.createNBTTag(""), (Integer)AgeingConfig.SERVER.guardianToElderAgeingTime.get());
            guardianToElder.setCriteria(new BaseCriteria[]{new BossCriteria(guardianToElder, (Integer)AgeingConfig.SERVER.guardianToElderAgeingMax.get(), (Integer)AgeingConfig.SERVER.guardianToElderRange.get())});
            INSTANCE.registerAgeing(guardianToElder);
        } else if (!INSTANCE.isIDUnique(EntityType.field_200761_A.getRegistryName(), "GuardianToElder")) {
            guardianToElder = INSTANCE.getByID(EntityType.field_200761_A.getRegistryName(), "GuardianToElder");
            ageingChanged = false;
            criteriaChanged = false;
            ageingTime = (Integer)AgeingConfig.SERVER.guardianToElderAgeingTime.get();
            if (guardianToElder.getAgeingTme() != ageingTime) {
                guardianToElder.setAgeingTme(ageingTime);
                ageingChanged = true;
            }
            if ((criterias = guardianToElder.getCriteria()).length > 0) {
                for (BaseCriteria criteria : criterias) {
                    if (!(criteria instanceof BossCriteria)) continue;
                    BossCriteria bossCriteria = (BossCriteria)criteria;
                    int ageingMax = (Integer)AgeingConfig.SERVER.guardianToElderAgeingMax.get();
                    int range = (Integer)AgeingConfig.SERVER.guardianToElderRange.get();
                    if (bossCriteria.getMaxInArea() != ageingMax) {
                        bossCriteria.setMaxInArea(ageingMax);
                        criteriaChanged = true;
                    }
                    if (bossCriteria.getCheckRadius() == range) continue;
                    bossCriteria.setCheckRadius(range);
                    criteriaChanged = true;
                }
            }
            if (criteriaChanged) {
                guardianToElder.setCriteria(criterias);
            }
            if (ageingChanged || criteriaChanged) {
                INSTANCE.replaceAgeing(guardianToElder);
            }
        }
        if (INSTANCE.isIDUnique(EntityType.field_200725_aD.getRegistryName(), "BabyToZombie") && ((Boolean)AgeingConfig.SERVER.babyToZombieAgeing.get()).booleanValue()) {
            INSTANCE.registerAgeing(new AgeingData("BabyToZombie", (EntityType<? extends Entity>)EntityType.field_200725_aD, AgeingRegistry.createNBTTag("{IsBaby:1b}"), (EntityType<? extends Entity>)EntityType.field_200725_aD, AgeingRegistry.createNBTTag("{IsBaby:0b}"), (Integer)AgeingConfig.SERVER.babyToZombieAgeingTime.get()));
        } else if (!INSTANCE.isIDUnique(EntityType.field_200725_aD.getRegistryName(), "BabyToZombie")) {
            AgeingData babyToZombie = INSTANCE.getByID(EntityType.field_200725_aD.getRegistryName(), "BabyToZombie");
            ageingTime2 = (Integer)AgeingConfig.SERVER.babyToZombieAgeingTime.get();
            if (babyToZombie.getAgeingTme() != ageingTime2) {
                babyToZombie.setAgeingTme(ageingTime2);
                INSTANCE.replaceAgeing(babyToZombie);
            }
        }
        if (INSTANCE.isIDUnique(EntityType.field_200763_C.getRegistryName(), "BabyToHusk") && ((Boolean)AgeingConfig.SERVER.babyToZombieAgeing.get()).booleanValue()) {
            INSTANCE.registerAgeing(new AgeingData("BabyToHusk", (EntityType<? extends Entity>)EntityType.field_200763_C, AgeingRegistry.createNBTTag("{IsBaby:1b}"), (EntityType<? extends Entity>)EntityType.field_200763_C, AgeingRegistry.createNBTTag("{IsBaby:0b}"), (Integer)AgeingConfig.SERVER.babyToZombieAgeingTime.get()));
        } else if (!INSTANCE.isIDUnique(EntityType.field_200763_C.getRegistryName(), "BabyToHusk")) {
            AgeingData babyToHusk = INSTANCE.getByID(EntityType.field_200763_C.getRegistryName(), "BabyToHusk");
            ageingTime2 = (Integer)AgeingConfig.SERVER.babyToZombieAgeingTime.get();
            if (babyToHusk.getAgeingTme() != ageingTime2) {
                babyToHusk.setAgeingTme(ageingTime2);
                INSTANCE.replaceAgeing(babyToHusk);
            }
        }
        if (INSTANCE.isIDUnique(EntityType.field_200741_ag.getRegistryName(), "SkeletonToStray") && ((Boolean)AgeingConfig.SERVER.skeletonToStrayAgeing.get()).booleanValue()) {
            skeletonToStray = new AgeingData("SkeletonToStray", (EntityType<? extends Entity>)EntityType.field_200741_ag, AgeingRegistry.createNBTTag(""), (EntityType<? extends Entity>)EntityType.field_200750_ap, AgeingRegistry.createNBTTag(""), (Integer)AgeingConfig.SERVER.skeletonToStrayAgeingTime.get());
            skeletonToStray.setCriteria(new BaseCriteria[]{new BiomeTypeCriteria(skeletonToStray, BiomeDictionary.Type.COLD)});
            INSTANCE.registerAgeing(skeletonToStray);
        } else if (!INSTANCE.isIDUnique(EntityType.field_200741_ag.getRegistryName(), "SkeletonToStray")) {
            skeletonToStray = INSTANCE.getByID(EntityType.field_200741_ag.getRegistryName(), "SkeletonToStray");
            ageingTime2 = (Integer)AgeingConfig.SERVER.skeletonToStrayAgeingTime.get();
            if (skeletonToStray.getAgeingTme() != ageingTime2) {
                skeletonToStray.setAgeingTme(ageingTime2);
                INSTANCE.replaceAgeing(skeletonToStray);
            }
        }
        if (INSTANCE.isIDUnique(EntityType.field_200750_ap.getRegistryName(), "StrayToSkeleton") && ((Boolean)AgeingConfig.SERVER.strayToSkeletonAgeing.get()).booleanValue()) {
            strayToSkeleton = new AgeingData("StrayToSkeleton", (EntityType<? extends Entity>)EntityType.field_200750_ap, AgeingRegistry.createNBTTag(""), (EntityType<? extends Entity>)EntityType.field_200741_ag, AgeingRegistry.createNBTTag(""), (Integer)AgeingConfig.SERVER.strayToSkeletonAgeingTime.get());
            strayToSkeleton.setCriteria(new BaseCriteria[]{new BiomeTypeCriteria(strayToSkeleton, BiomeDictionary.Type.HOT)});
            INSTANCE.registerAgeing(strayToSkeleton);
        } else if (!INSTANCE.isIDUnique(EntityType.field_200750_ap.getRegistryName(), "StrayToSkeleton")) {
            strayToSkeleton = INSTANCE.getByID(EntityType.field_200750_ap.getRegistryName(), "StrayToSkeleton");
            ageingTime2 = (Integer)AgeingConfig.SERVER.strayToSkeletonAgeingTime.get();
            if (strayToSkeleton.getAgeingTme() != ageingTime2) {
                strayToSkeleton.setAgeingTme(ageingTime2);
                INSTANCE.replaceAgeing(strayToSkeleton);
            }
        }
        if (INSTANCE.isIDUnique(EntityType.field_200736_ab.getRegistryName(), "RabbitToKiller") && ((Boolean)AgeingConfig.SERVER.rabbitToKillerAgeing.get()).booleanValue()) {
            rabbitToKiller = new AgeingData("RabbitToKiller", (EntityType<? extends Entity>)EntityType.field_200736_ab, AgeingRegistry.createNBTTag(""), (EntityType<? extends Entity>)EntityType.field_200736_ab, AgeingRegistry.createNBTTag("{RabbitType:99}"), (Integer)AgeingConfig.SERVER.rabbitToKillerAgeingTime.get());
            rabbitToKiller.setCriteria(new BaseCriteria[]{new LightCriteria(rabbitToKiller, (Integer)AgeingConfig.SERVER.rabbitToKillerMinLight.get(), (Integer)AgeingConfig.SERVER.rabbitToKillerMaxLight.get(), true, false)});
            INSTANCE.registerAgeing(rabbitToKiller);
        } else if (!INSTANCE.isIDUnique(EntityType.field_200736_ab.getRegistryName(), "RabbitToKiller")) {
            rabbitToKiller = INSTANCE.getByID(EntityType.field_200736_ab.getRegistryName(), "RabbitToKiller");
            ageingChanged = false;
            criteriaChanged = false;
            ageingTime = (Integer)AgeingConfig.SERVER.rabbitToKillerAgeingTime.get();
            if (rabbitToKiller.getAgeingTme() != ageingTime) {
                rabbitToKiller.setAgeingTme(ageingTime);
                ageingChanged = true;
            }
            if ((criterias = rabbitToKiller.getCriteria()).length > 0) {
                for (BaseCriteria criteria : criterias) {
                    if (!(criteria instanceof LightCriteria)) continue;
                    lightCriteria = (LightCriteria)criteria;
                    minLight = (Integer)AgeingConfig.SERVER.rabbitToKillerMinLight.get();
                    maxLight = (Integer)AgeingConfig.SERVER.rabbitToKillerMaxLight.get();
                    if (lightCriteria.getLightLevelMin() != minLight) {
                        lightCriteria.setLightLevelMin(minLight);
                        criteriaChanged = true;
                    }
                    if (lightCriteria.getLightLevelMax() == maxLight) continue;
                    lightCriteria.setLightLevelMax(maxLight);
                    criteriaChanged = true;
                }
            }
            if (criteriaChanged) {
                rabbitToKiller.setCriteria(criterias);
            }
            if (ageingChanged || criteriaChanged) {
                INSTANCE.replaceAgeing(rabbitToKiller);
            }
        }
        if (INSTANCE.isIDUnique(EntityType.field_200796_j.getRegistryName(), "CowToMooshroom") && ((Boolean)AgeingConfig.SERVER.cowToMooshroomAgeing.get()).booleanValue()) {
            cowToMooshroom = new AgeingData("CowToMooshroom", (EntityType<? extends Entity>)EntityType.field_200796_j, AgeingRegistry.createNBTTag(""), (EntityType<? extends Entity>)EntityType.field_200780_T, AgeingRegistry.createNBTTag(""), (Integer)AgeingConfig.SERVER.cowToMooshroomAgeingTime.get());
            cowToMooshroom.setCriteria(new BaseCriteria[]{new BlockBasedCriteria(cowToMooshroom, new Block[]{Blocks.field_150391_bh, Blocks.field_150338_P, Blocks.field_150420_aW, Blocks.field_150337_Q, Blocks.field_150419_aX}, false, (Integer)AgeingConfig.SERVER.cowToMooshroomAgeingRadius.get())});
            INSTANCE.registerAgeing(cowToMooshroom);
        } else if (!INSTANCE.isIDUnique(EntityType.field_200796_j.getRegistryName(), "CowToMooshroom")) {
            cowToMooshroom = INSTANCE.getByID(EntityType.field_200796_j.getRegistryName(), "CowToMooshroom");
            ageingChanged = false;
            criteriaChanged = false;
            ageingTime = (Integer)AgeingConfig.SERVER.cowToMooshroomAgeingTime.get();
            if (cowToMooshroom.getAgeingTme() != ageingTime) {
                cowToMooshroom.setAgeingTme(ageingTime);
                ageingChanged = true;
            }
            if ((criterias = cowToMooshroom.getCriteria()).length > 0) {
                for (BaseCriteria criteria : criterias) {
                    if (!(criteria instanceof BlockBasedCriteria)) continue;
                    BlockBasedCriteria blockCriteria = (BlockBasedCriteria)criteria;
                    int radius = (Integer)AgeingConfig.SERVER.cowToMooshroomAgeingRadius.get();
                    if (blockCriteria.getRadius() == radius) continue;
                    blockCriteria.setRadius(radius);
                    criteriaChanged = true;
                }
            }
            if (criteriaChanged) {
                cowToMooshroom.setCriteria(criterias);
            }
            if (ageingChanged || criteriaChanged) {
                INSTANCE.replaceAgeing(cowToMooshroom);
            }
        }
        if (INSTANCE.isIDUnique(EntityType.field_200741_ag.getRegistryName(), "SkeletonToWitherSkelly") && ((Boolean)AgeingConfig.SERVER.skeletonToWitherSkeletonAgeing.get()).booleanValue()) {
            skeletonToWitherSkelly = new AgeingData("SkeletonToWitherSkelly", (EntityType<? extends Entity>)EntityType.field_200741_ag, AgeingRegistry.createNBTTag(""), (EntityType<? extends Entity>)EntityType.field_200722_aA, AgeingRegistry.createNBTTag(""), (Integer)AgeingConfig.SERVER.skeletonToWitherSkeletonAgeingTime.get());
            skeletonToWitherSkelly.setCriteria(new BaseCriteria[]{new DimensionCriteria(skeletonToWitherSkelly, new ResourceLocation[]{new ResourceLocation("the_nether")})});
            INSTANCE.registerAgeing(skeletonToWitherSkelly);
        } else if (!INSTANCE.isIDUnique(EntityType.field_200741_ag.getRegistryName(), "SkeletonToWitherSkelly")) {
            skeletonToWitherSkelly = INSTANCE.getByID(EntityType.field_200741_ag.getRegistryName(), "SkeletonToWitherSkelly");
            ageingTime2 = (Integer)AgeingConfig.SERVER.skeletonToWitherSkeletonAgeingTime.get();
            if (skeletonToWitherSkelly.getAgeingTme() != ageingTime2) {
                skeletonToWitherSkelly.setAgeingTme(ageingTime2);
                INSTANCE.replaceAgeing(skeletonToWitherSkelly);
            }
        }
        if (INSTANCE.isIDUnique(EntityType.field_200743_ai.getRegistryName(), "SlimeToMagmaCube") && ((Boolean)AgeingConfig.SERVER.slimeToMagmaCubeAgeing.get()).booleanValue()) {
            slimeToMagmaCube = new AgeingData("SlimeToMagmaCube", (EntityType<? extends Entity>)EntityType.field_200743_ai, AgeingRegistry.createNBTTag(""), (EntityType<? extends Entity>)EntityType.field_200771_K, AgeingRegistry.createNBTTag(""), (Integer)AgeingConfig.SERVER.slimeToMagmaCubeAgeingTime.get());
            slimeToMagmaCube.setCriteria(new BaseCriteria[]{new DimensionCriteria(slimeToMagmaCube, new ResourceLocation[]{new ResourceLocation("the_nether")})});
            INSTANCE.registerAgeing(slimeToMagmaCube);
        } else if (!INSTANCE.isIDUnique(EntityType.field_200743_ai.getRegistryName(), "SlimeToMagmaCube")) {
            slimeToMagmaCube = INSTANCE.getByID(EntityType.field_200743_ai.getRegistryName(), "SlimeToMagmaCube");
            ageingTime2 = (Integer)AgeingConfig.SERVER.slimeToMagmaCubeAgeingTime.get();
            if (slimeToMagmaCube.getAgeingTme() != ageingTime2) {
                slimeToMagmaCube.setAgeingTme(ageingTime2);
                INSTANCE.replaceAgeing(slimeToMagmaCube);
            }
        }
        if (INSTANCE.isIDUnique(EntityType.field_200791_e.getRegistryName(), "BatToVex") && ((Boolean)AgeingConfig.SERVER.batToVexAgeing.get()).booleanValue()) {
            INSTANCE.registerAgeing(new AgeingData("BatToVex", (EntityType<? extends Entity>)EntityType.field_200791_e, AgeingRegistry.createNBTTag(""), (EntityType<? extends Entity>)EntityType.field_200755_au, AgeingRegistry.createNBTTag(""), (Integer)AgeingConfig.SERVER.batToVexAgeingTime.get()));
        } else if (!INSTANCE.isIDUnique(EntityType.field_200791_e.getRegistryName(), "BatToVex")) {
            AgeingData batToVex = INSTANCE.getByID(EntityType.field_200791_e.getRegistryName(), "BatToVex");
            ageingTime2 = (Integer)AgeingConfig.SERVER.batToVexAgeingTime.get();
            if (batToVex.getAgeingTme() != ageingTime2) {
                batToVex.setAgeingTme(ageingTime2);
                INSTANCE.replaceAgeing(batToVex);
            }
        }
    }

    public void registerAgeing(AgeingData ageing) {
        ResourceLocation resourceLocation = ageing.getEntity().getRegistryName();
        if (resourceLocation != null) {
            if (ageingList.containsKey(resourceLocation)) {
                ArrayList<AgeingData> dataList = new ArrayList<AgeingData>((Collection)ageingList.get(resourceLocation));
                dataList.add(ageing);
                ageingList.put(resourceLocation, dataList);
            } else {
                ageingList.put(resourceLocation, Collections.singletonList(ageing));
            }
        } else {
            AgeingMobs.LOGGER.error(String.format("Failed to add Ageing Data with ID %s because the entity's resourcelocation is null", ageing.getName()));
        }
    }

    public void removeAgeing(AgeingData ageing) {
        ResourceLocation resourceLocation = ageing.getEntity().getRegistryName();
        if (resourceLocation != null) {
            if (ageingList.containsKey(resourceLocation)) {
                ArrayList dataList = new ArrayList(ageingList.get(resourceLocation));
                dataList.remove(ageing);
                if (dataList.isEmpty()) {
                    ageingList.remove(resourceLocation);
                } else {
                    ageingList.put(resourceLocation, dataList);
                }
            } else {
                AgeingMobs.LOGGER.error(String.format("Tried to remove Ageing Data with id %s but it didn't exist", ageing.getName()));
            }
        } else {
            AgeingMobs.LOGGER.error(String.format("Failed to remove Ageing Data with ID %s because the entity's resourcelocation is null", ageing.getName()));
        }
    }

    public void replaceAgeing(AgeingData ageing) {
        ResourceLocation resourceLocation = ageing.getEntity().getRegistryName();
        String uniqueID = ageing.getName();
        if (resourceLocation != null) {
            if (ageingList.containsKey(resourceLocation)) {
                ArrayList dataList = ageingList.get(resourceLocation);
                if (dataList == null) {
                    dataList = Lists.newArrayList();
                }
                boolean found = false;
                if (!dataList.isEmpty()) {
                    ListIterator<AgeingData> iterator = dataList.listIterator();
                    while (iterator.hasNext()) {
                        AgeingData data = (AgeingData)iterator.next();
                        if (!data.getName().equals(uniqueID)) continue;
                        iterator.set(ageing);
                        found = true;
                    }
                    if (!found) {
                        AgeingMobs.LOGGER.error(String.format("Tried to change Ageing Data with id %s but it didn't exist", ageing.getName()));
                    }
                }
            }
        } else {
            AgeingMobs.LOGGER.error(String.format("Failed to remove Ageing Data with ID %s because the entity's resourcelocation is null", ageing.getName()));
        }
    }

    public static List<AgeingData> getDataList(ResourceLocation resourceLocation) {
        if (ageingList.containsKey(resourceLocation)) {
            List<AgeingData> dataList = ageingList.get(resourceLocation);
            if (dataList == null) {
                return new ArrayList<AgeingData>();
            }
            return dataList;
        }
        return new ArrayList<AgeingData>();
    }

    public static boolean hasEntityAgeing(ResourceLocation resourceLocation) {
        return ageingList.containsKey(resourceLocation);
    }

    public AgeingData getByID(ResourceLocation resourceLocation, String uniqueID) {
        if (ageingList.containsKey(resourceLocation)) {
            ArrayList dataList = ageingList.get(resourceLocation);
            if (dataList == null) {
                dataList = Lists.newArrayList();
            }
            if (!dataList.isEmpty()) {
                for (AgeingData data : dataList) {
                    if (!data.getName().equals(uniqueID)) continue;
                    return data;
                }
            }
        }
        return null;
    }

    public AgeingData getByID(String uniqueID) {
        for (Map.Entry<ResourceLocation, List<AgeingData>> entry : ageingList.entrySet()) {
            List<AgeingData> dataList = entry.getValue();
            if (dataList == null || dataList.isEmpty()) continue;
            for (AgeingData data : dataList) {
                if (!data.getName().equals(uniqueID)) continue;
                return data;
            }
        }
        return null;
    }

    public boolean isIDUnique(ResourceLocation resourceLocation, String uniqueID) {
        if (ageingList.containsKey(resourceLocation)) {
            ArrayList dataList = ageingList.get(resourceLocation);
            if (dataList == null) {
                dataList = Lists.newArrayList();
            }
            if (!dataList.isEmpty()) {
                for (AgeingData data : dataList) {
                    if (!data.getName().equals(uniqueID)) continue;
                    return false;
                }
            }
        }
        return true;
    }

    public static CompoundNBT createNBTTag(String nbtData) {
        CompoundNBT tag = new CompoundNBT();
        try {
            tag = nbtData.startsWith("{") && nbtData.endsWith("}") ? JsonToNBT.func_180713_a((String)nbtData) : JsonToNBT.func_180713_a((String)("{" + nbtData + "}"));
        }
        catch (CommandSyntaxException nbtexception) {
            AgeingMobs.LOGGER.error("nope... " + nbtexception.getMessage());
        }
        return tag;
    }

    public void initializeMagicMap() {
        List magicalBlocks = (List)AgeingConfig.SERVER.magical_blocks.get();
        if (!magicalBlocks.isEmpty()) {
            importanceList = new HashMap();
            for (String blockData : magicalBlocks) {
                String[] blockInfo = blockData.split(";");
                if (blockInfo.length > 2) {
                    AgeingMobs.LOGGER.error("An error has occured. " + blockData + " is using the wrong syntax.");
                    continue;
                }
                if (blockInfo.length != 2) continue;
                String blockName = blockInfo[0];
                double importance = Double.parseDouble(blockInfo[1]);
                Block block = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(blockName));
                if (block == null || importanceList.containsKey(block)) continue;
                importanceList.put(block, importance);
            }
        }
    }

    public HashMap<Block, Double> getMagicMap() {
        return importanceList;
    }

    public void initializeMoonDimensions() {
        List dimensions = (List)AgeingConfig.SERVER.moon_dimensions.get();
        ArrayList<ResourceLocation> dimensionList = new ArrayList<ResourceLocation>();
        for (String string : dimensions) {
            ResourceLocation dim = new ResourceLocation(string);
            if (dimensionList.contains(dim)) continue;
            dimensionList.add(dim);
        }
        moonDimensions = dimensionList;
    }

    public List<ResourceLocation> getMoonDimensions() {
        return moonDimensions;
    }

    public static CompoundNBT entityToNBT(Entity theEntity) {
        ItemStack itemstack;
        CompoundNBT nbttagcompound = theEntity.func_189511_e(new CompoundNBT());
        if (theEntity instanceof PlayerEntity && !(itemstack = ((PlayerEntity)theEntity).field_71071_by.func_70448_g()).func_190926_b()) {
            nbttagcompound.func_218657_a("SelectedItem", (INBT)itemstack.func_77955_b(new CompoundNBT()));
        }
        return nbttagcompound;
    }
}

