/*
 * Decompiled with CFR 0.152.
 */
package com.shynieke.ageingmobs.registry.ageing.criteria;

import com.shynieke.ageingmobs.registry.AgeingRegistry;
import com.shynieke.ageingmobs.registry.ageing.criteria.BaseCriteria;
import com.shynieke.ageingmobs.registry.ageing.iAgeing;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class BossCriteria
extends BaseCriteria {
    private int maxInArea;
    private int checkRadius;
    private boolean isReversing;

    public BossCriteria(iAgeing ageing, int maxInArea, int checkRadius) {
        super(ageing);
        this.maxInArea = maxInArea;
        this.checkRadius = checkRadius;
        this.isReversing = false;
    }

    public int getMaxInArea() {
        return this.maxInArea;
    }

    public void setMaxInArea(int maxInArea) {
        this.maxInArea = maxInArea;
    }

    public int getCheckRadius() {
        return this.checkRadius;
    }

    public void setCheckRadius(int checkRadius) {
        this.checkRadius = checkRadius;
    }

    @Override
    public boolean checkCriteria(World worldIn, Entity entityIn) {
        BlockPos entityPos = entityIn.func_233580_cy_();
        if (this.getMaxInArea() != 0) {
            int checkRadius = this.getCheckRadius();
            int bossAmount = 0;
            AxisAlignedBB areaHitbox = new AxisAlignedBB((double)((float)entityPos.func_177958_n() - 0.5f), (double)((float)entityPos.func_177956_o() - 0.5f), (double)((float)entityPos.func_177952_p() - 0.5f), (double)((float)entityPos.func_177958_n() + 0.5f), (double)((float)entityPos.func_177956_o() + 0.5f), (double)((float)entityPos.func_177952_p() + 0.5f)).func_72321_a((double)(-checkRadius), (double)(-checkRadius), (double)(-checkRadius)).func_72321_a((double)checkRadius, (double)checkRadius, (double)checkRadius);
            if (!worldIn.func_217357_a(Entity.class, areaHitbox).isEmpty()) {
                for (Entity foundEntity : worldIn.func_217357_a(Entity.class, areaHitbox)) {
                    if (foundEntity instanceof PlayerEntity || !foundEntity.func_200600_R().equals(this.getTransformedEntity())) continue;
                    if (!this.getTransformedEntityData().isEmpty()) {
                        CompoundNBT entityTag = AgeingRegistry.entityToNBT(foundEntity);
                        CompoundNBT entityTag2 = this.getTransformedEntityData();
                        if (NBTUtil.func_181123_a((INBT)entityTag2, (INBT)entityTag, (boolean)true)) continue;
                        ++bossAmount;
                        continue;
                    }
                    ++bossAmount;
                }
            }
            if (bossAmount < this.getMaxInArea()) {
                this.isReversing = false;
                return true;
            }
            this.isReversing = true;
            return false;
        }
        this.isReversing = false;
        return true;
    }

    @Override
    public boolean isReversing() {
        return this.isReversing;
    }
}

