/*
 * Decompiled with CFR 0.152.
 */
package com.shynieke.ageingmobs.registry.ageing.criteria;

import com.shynieke.ageingmobs.registry.AgeingRegistry;
import com.shynieke.ageingmobs.registry.ageing.criteria.BaseCriteria;
import com.shynieke.ageingmobs.registry.ageing.iAgeing;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class EntityCriteria
extends BaseCriteria {
    private EntityType<? extends Entity> nearbyEntity;
    private CompoundNBT nearbyEntityData;
    private int radius;

    public EntityCriteria(iAgeing ageing, EntityType<? extends Entity> nearbyEntity, CompoundNBT nearbyEntityData, int radius) {
        super(ageing);
        this.nearbyEntity = nearbyEntity;
        this.nearbyEntityData = nearbyEntityData;
        this.radius = radius;
    }

    public EntityType<? extends Entity> getNearbyEntity() {
        return this.nearbyEntity;
    }

    public void setNearbyEntity(EntityType<? extends Entity> nearbyEntity) {
        this.nearbyEntity = nearbyEntity;
    }

    public CompoundNBT getNearbyEntityData() {
        return this.nearbyEntityData;
    }

    public void setNearbyEntityData(CompoundNBT nearbyEntityData) {
        this.nearbyEntityData = nearbyEntityData;
    }

    public int getRadius() {
        return this.radius;
    }

    public void setRadius(int radius) {
        this.radius = radius;
    }

    @Override
    public boolean checkCriteria(World worldIn, Entity entityIn) {
        BlockPos entityPos = entityIn.func_233580_cy_();
        int nearbyEntityAmount = 0;
        AxisAlignedBB areaHitbox = new AxisAlignedBB((double)((float)entityPos.func_177958_n() - 0.5f), (double)((float)entityPos.func_177956_o() - 0.5f), (double)((float)entityPos.func_177952_p() - 0.5f), (double)((float)entityPos.func_177958_n() + 0.5f), (double)((float)entityPos.func_177956_o() + 0.5f), (double)((float)entityPos.func_177952_p() + 0.5f)).func_72321_a((double)(-this.getRadius()), (double)(-this.getRadius()), (double)(-this.getRadius())).func_72321_a((double)this.getRadius(), (double)this.getRadius(), (double)this.getRadius());
        if (!worldIn.func_217357_a(Entity.class, areaHitbox).isEmpty()) {
            for (Entity foundEntity : worldIn.func_217357_a(Entity.class, areaHitbox)) {
                if (foundEntity instanceof PlayerEntity || !foundEntity.func_200600_R().equals(this.getTransformedEntity())) continue;
                if (!this.getTransformedEntityData().isEmpty()) {
                    CompoundNBT entityTag = AgeingRegistry.entityToNBT(foundEntity);
                    CompoundNBT entityTag2 = this.getNearbyEntityData();
                    if (NBTUtil.func_181123_a((INBT)entityTag2, (INBT)entityTag, (boolean)true)) continue;
                    ++nearbyEntityAmount;
                    continue;
                }
                ++nearbyEntityAmount;
            }
        }
        return nearbyEntityAmount != 0;
    }
}

