/*
 * Decompiled with CFR 0.152.
 */
package com.shynieke.ageingmobs.registry.ageing.criteria;

import com.shynieke.ageingmobs.AgeingMobs;
import com.shynieke.ageingmobs.registry.AgeingRegistry;
import com.shynieke.ageingmobs.registry.ageing.criteria.BaseCriteria;
import com.shynieke.ageingmobs.registry.ageing.iAgeing;
import java.util.HashMap;
import java.util.Iterator;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.World;

public class MagicCriteria
extends BaseCriteria {
    private int range;

    public MagicCriteria(iAgeing ageing, int range) {
        super(ageing);
        this.range = range;
    }

    public int getRange() {
        return this.range;
    }

    public void setRange(int range) {
        this.range = range;
    }

    @Override
    public boolean checkCriteria(World worldIn, Entity entityIn) {
        BlockPos entityPos = entityIn.func_233580_cy_();
        HashMap<Block, Double> magicMap = AgeingRegistry.INSTANCE.getMagicMap();
        if (!magicMap.isEmpty()) {
            double totalImportance = 0.0;
            BlockPos downPos = new BlockPos((Vector3i)entityPos.func_177982_a(-this.getRange(), -this.getRange(), -this.getRange()));
            BlockPos upPos = new BlockPos((Vector3i)entityPos.func_177982_a(this.getRange(), this.getRange(), this.getRange()));
            Iterator posIterator = BlockPos.func_218281_b((BlockPos)downPos, (BlockPos)upPos).iterator();
            while (posIterator.hasNext()) {
                BlockPos pos = (BlockPos)posIterator.next();
                Block foundState = worldIn.func_180495_p(pos).func_177230_c();
                if (!magicMap.containsKey(foundState)) continue;
                double importanceFound = magicMap.getOrDefault(foundState, 0.0);
                totalImportance += importanceFound;
            }
            return totalImportance > 0.0;
        }
        AgeingMobs.LOGGER.error("An error has occured. A criteria is using Magical Blocks but your config has no magical blocks specified.");
        return false;
    }
}

