/*
 * Decompiled with CFR 0.152.
 */
package com.legobmw99.allomancy.modules.powers.command;

import com.legobmw99.allomancy.modules.powers.command.AllomancyPowerType;
import com.legobmw99.allomancy.modules.powers.network.AllomancyCapabilityPacket;
import com.legobmw99.allomancy.modules.powers.util.AllomancyCapability;
import com.legobmw99.allomancy.network.Network;
import com.legobmw99.allomancy.setup.Metal;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.tree.CommandNode;
import com.mojang.brigadier.tree.LiteralCommandNode;
import java.util.function.Predicate;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.command.arguments.EntityArgument;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public class AllomancyPowerCommand {
    protected static final String[] names = new String[Metal.values().length + 1];

    private static Predicate<CommandSource> permissions(int level) {
        return player -> player.func_197034_c(level);
    }

    public static void register(CommandDispatcher<CommandSource> dispatcher) {
        LiteralArgumentBuilder root = (LiteralArgumentBuilder)Commands.func_197057_a((String)"allomancy").requires(AllomancyPowerCommand.permissions(0));
        root.then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.func_197057_a((String)"get").requires(AllomancyPowerCommand.permissions(0))).executes(ctx -> AllomancyPowerCommand.getPowers((CommandContext<CommandSource>)ctx, false))).then(Commands.func_197056_a((String)"targets", (ArgumentType)EntityArgument.func_197094_d()).executes(ctx -> AllomancyPowerCommand.getPowers((CommandContext<CommandSource>)ctx, true))));
        root.then(((LiteralArgumentBuilder)Commands.func_197057_a((String)"add").requires(AllomancyPowerCommand.permissions(2))).then(((RequiredArgumentBuilder)Commands.func_197056_a((String)"type", (ArgumentType)AllomancyPowerType.INSTANCE).executes(ctx -> AllomancyPowerCommand.addPower((CommandContext<CommandSource>)ctx, false))).then(Commands.func_197056_a((String)"targets", (ArgumentType)EntityArgument.func_197094_d()).executes(ctx -> AllomancyPowerCommand.addPower((CommandContext<CommandSource>)ctx, true)))));
        root.then(((LiteralArgumentBuilder)Commands.func_197057_a((String)"remove").requires(AllomancyPowerCommand.permissions(2))).then(((RequiredArgumentBuilder)Commands.func_197056_a((String)"type", (ArgumentType)AllomancyPowerType.INSTANCE).executes(ctx -> AllomancyPowerCommand.removePower((CommandContext<CommandSource>)ctx, false))).then(Commands.func_197056_a((String)"targets", (ArgumentType)EntityArgument.func_197094_d()).executes(ctx -> AllomancyPowerCommand.removePower((CommandContext<CommandSource>)ctx, true)))));
        LiteralCommandNode command = dispatcher.register(root);
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.func_197057_a((String)"ap").requires(AllomancyPowerCommand.permissions(0))).redirect((CommandNode)command));
    }

    private static int getPowers(CommandContext<CommandSource> ctx, boolean hasPlayer) throws CommandSyntaxException {
        int i = 0;
        if (hasPlayer) {
            for (ServerPlayerEntity p : EntityArgument.func_197090_e(ctx, (String)"targets")) {
                AllomancyPowerCommand.getPowers(ctx, p);
                ++i;
            }
        } else {
            AllomancyPowerCommand.getPowers(ctx, ((CommandSource)ctx.getSource()).func_197035_h());
            i = 1;
        }
        return i;
    }

    private static void getPowers(CommandContext<CommandSource> ctx, ServerPlayerEntity player) {
        AllomancyCapability cap = AllomancyCapability.forPlayer((Entity)player);
        StringBuilder powers = new StringBuilder();
        if (cap.isMistborn()) {
            powers.append("all");
        } else if (cap.isUninvested()) {
            powers.append("none");
        } else {
            for (Metal mt : Metal.values()) {
                if (!cap.hasPower(mt)) continue;
                if (powers.length() == 0) {
                    powers.append(mt.getName());
                    continue;
                }
                powers.append(", ").append(mt.getName());
            }
        }
        ((CommandSource)ctx.getSource()).func_197030_a((ITextComponent)new TranslationTextComponent("commands.allomancy.getpowers", new Object[]{player.func_145748_c_(), powers.toString()}), true);
    }

    private static int addPower(CommandContext<CommandSource> ctx, boolean hasPlayer) throws CommandSyntaxException {
        int i = 0;
        if (hasPlayer) {
            for (ServerPlayerEntity p : EntityArgument.func_197090_e(ctx, (String)"targets")) {
                AllomancyPowerCommand.addPower(ctx, p);
                ++i;
            }
        } else {
            AllomancyPowerCommand.addPower(ctx, ((CommandSource)ctx.getSource()).func_197035_h());
            i = 1;
        }
        return i;
    }

    private static void addPower(CommandContext<CommandSource> ctx, ServerPlayerEntity player) {
        AllomancyCapability cap = AllomancyCapability.forPlayer((Entity)player);
        String type = (String)ctx.getArgument("type", String.class);
        if (type.equalsIgnoreCase("all")) {
            cap.setMistborn();
        } else {
            Metal mt = Metal.valueOf(type.toUpperCase());
            cap.addPower(mt);
        }
        Network.sendTo((Object)new AllomancyCapabilityPacket(cap, player.func_145782_y()), player);
        ((CommandSource)ctx.getSource()).func_197030_a((ITextComponent)new TranslationTextComponent("commands.allomancy.addpower", new Object[]{player.func_145748_c_(), type}), true);
    }

    private static int removePower(CommandContext<CommandSource> ctx, boolean hasPlayer) throws CommandSyntaxException {
        int i = 0;
        if (hasPlayer) {
            for (ServerPlayerEntity p : EntityArgument.func_197090_e(ctx, (String)"targets")) {
                AllomancyPowerCommand.removePower(ctx, p);
                ++i;
            }
        } else {
            AllomancyPowerCommand.removePower(ctx, ((CommandSource)ctx.getSource()).func_197035_h());
            i = 1;
        }
        return i;
    }

    private static void removePower(CommandContext<CommandSource> ctx, ServerPlayerEntity player) {
        AllomancyCapability cap = AllomancyCapability.forPlayer((Entity)player);
        String type = (String)ctx.getArgument("type", String.class);
        if (type.equalsIgnoreCase("all")) {
            cap.setUninvested();
        } else {
            Metal mt = Metal.valueOf(type.toUpperCase());
            cap.revokePower(mt);
        }
        Network.sendTo((Object)new AllomancyCapabilityPacket(cap, player.func_145782_y()), player);
        ((CommandSource)ctx.getSource()).func_197030_a((ITextComponent)new TranslationTextComponent("commands.allomancy.removepower", new Object[]{player.func_145748_c_(), type}), true);
    }

    static {
        int i = 0;
        for (Metal mt : Metal.values()) {
            AllomancyPowerCommand.names[i++] = mt.getName();
        }
        AllomancyPowerCommand.names[i] = "all";
    }
}

