/*
 * Decompiled with CFR 0.152.
 */
package shadows.apotheosis;

import java.io.File;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionUtils;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.IIngredientSerializer;
import net.minecraftforge.common.crafting.conditions.IConditionSerializer;
import net.minecraftforge.event.entity.player.AttackEntityEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DeferredWorkQueue;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.IModBusEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLPaths;
import net.minecraftforge.fml.network.NetworkRegistry;
import net.minecraftforge.fml.network.simple.SimpleChannel;
import shadows.apotheosis.advancements.AdvancementTriggers;
import shadows.apotheosis.deadly.DeadlyModule;
import shadows.apotheosis.deadly.loot.affix.Affix;
import shadows.apotheosis.ench.EnchModule;
import shadows.apotheosis.garden.GardenModule;
import shadows.apotheosis.potion.PotionModule;
import shadows.apotheosis.spawn.SpawnerModule;
import shadows.apotheosis.util.EnchantmentIngredient;
import shadows.apotheosis.util.ModuleCondition;
import shadows.apotheosis.util.ParticleMessage;
import shadows.apotheosis.village.VillageModule;
import shadows.placebo.config.Configuration;
import shadows.placebo.recipe.NBTIngredient;
import shadows.placebo.recipe.RecipeHelper;
import shadows.placebo.util.NetworkUtils;

@Mod(value="apotheosis")
public class Apotheosis {
    public static final String MODID = "apotheosis";
    public static final SimpleChannel CHANNEL = NetworkRegistry.ChannelBuilder.named((ResourceLocation)new ResourceLocation("apotheosis", "apotheosis")).clientAcceptedVersions(s -> true).serverAcceptedVersions(s -> true).networkProtocolVersion(() -> "1.0.0").simpleChannel();
    public static final RecipeHelper HELPER = new RecipeHelper("apotheosis");
    public static File configDir;
    public static Configuration config;
    public static boolean enableSpawner;
    public static boolean enableGarden;
    public static boolean enableDeadly;
    public static boolean enableEnch;
    public static boolean enablePotion;
    public static boolean enableVillager;
    public static float localAtkStrength;

    public Apotheosis() {
        Affix.classload();
        configDir = new File(FMLPaths.CONFIGDIR.get().toFile(), MODID);
        config = new Configuration(new File(configDir, "apotheosis.cfg"));
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        enableEnch = config.getBoolean("Enable Enchantment Module", "general", true, "If the enchantment module is enabled.");
        if (enableEnch) {
            bus.register((Object)new EnchModule());
        }
        if (enableSpawner = config.getBoolean("Enable Spawner Module", "general", true, "If the spawner module is enabled.")) {
            bus.register((Object)new SpawnerModule());
        }
        if (enableGarden = config.getBoolean("Enable Garden Module", "general", true, "If the garden module is loaded.")) {
            bus.register((Object)new GardenModule());
        }
        if (enableDeadly = config.getBoolean("Enable Deadly Module", "general", true, "If the deadly module is loaded.")) {
            bus.register((Object)new DeadlyModule());
        }
        if (enablePotion = config.getBoolean("Enable Potion Module", "general", true, "If the potion module is loaded.")) {
            bus.register((Object)new PotionModule());
        }
        if (enableVillager = config.getBoolean("Enable Village Module", "general", enableVillager, "If the village module is loaded.")) {
            bus.register((Object)new VillageModule());
        }
        if (config.hasChanged()) {
            config.save();
        }
        bus.post((Event)new ApotheosisConstruction());
        bus.addListener(this::init);
        bus.addListener(this::initC);
        MinecraftForge.EVENT_BUS.addListener(this::trackCooldown);
    }

    @SubscribeEvent
    public void init(FMLCommonSetupEvent e) {
        NetworkUtils.registerMessage((SimpleChannel)CHANNEL, (int)0, (NetworkUtils.MessageProvider)new ParticleMessage());
        FMLJavaModLoadingContext.get().getModEventBus().post((Event)new ApotheosisSetup());
        DeferredWorkQueue.runLater(AdvancementTriggers::init);
        CraftingHelper.register((IConditionSerializer)new ModuleCondition.Serializer());
        CraftingHelper.register((ResourceLocation)new ResourceLocation(MODID, "enchantment"), (IIngredientSerializer)EnchantmentIngredient.Serializer.INSTANCE);
    }

    @SubscribeEvent
    public void initC(FMLClientSetupEvent e) {
        FMLJavaModLoadingContext.get().getModEventBus().post((Event)new ApotheosisClientSetup());
    }

    public void trackCooldown(AttackEntityEvent e) {
        PlayerEntity p = e.getPlayer();
        localAtkStrength = p.func_184825_o(0.5f);
    }

    public static Ingredient potionIngredient(Potion type) {
        return new NBTIngredient(PotionUtils.func_185188_a((ItemStack)new ItemStack((IItemProvider)Items.field_151068_bn), (Potion)type));
    }

    static {
        enableSpawner = true;
        enableGarden = true;
        enableDeadly = true;
        enableEnch = true;
        enablePotion = true;
        enableVillager = true;
        localAtkStrength = 1.0f;
    }

    public static class ApotheosisClientSetup
    extends Event
    implements IModBusEvent {
    }

    public static class ApotheosisSetup
    extends Event
    implements IModBusEvent {
    }

    public static class ApotheosisConstruction
    extends Event
    implements IModBusEvent {
    }
}

