/*
 * Decompiled with CFR 0.152.
 */
package shadows.apotheosis.deadly.loot.affix.impl;

import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.loot.RandomValueRange;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import shadows.apotheosis.deadly.loot.affix.Affix;
import shadows.apotheosis.deadly.loot.affix.AffixHelper;
import shadows.apotheosis.deadly.loot.modifiers.AffixModifier;

public abstract class RangedAffix
extends Affix {
    protected final RandomValueRange range;

    public RangedAffix(RandomValueRange range, int weight) {
        super(weight);
        this.range = range;
    }

    public RangedAffix(float min, float max, int weight) {
        this(new RandomValueRange(min, max), weight);
    }

    @Override
    public float apply(ItemStack stack, Random rand, @Nullable AffixModifier modifier) {
        float lvl = this.range.func_186507_b(rand);
        if (modifier != null) {
            lvl = modifier.editLevel(this, lvl);
        }
        AffixHelper.addLore(stack, (ITextComponent)new TranslationTextComponent("affix." + this.getRegistryName() + ".desc", new Object[]{String.format("%.2f", Float.valueOf(lvl))}));
        return lvl;
    }

    @Override
    public float getMin() {
        return this.range.func_186509_a();
    }

    @Override
    public float getMax() {
        return this.range.func_186512_b();
    }
}

