/*
 * Decompiled with CFR 0.152.
 */
package shadows.apotheosis.ench;

import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ScreenManager;
import net.minecraft.client.renderer.tileentity.EnchantmentTableTileEntityRenderer;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItem;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.Item;
import net.minecraft.item.Items;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DeferredWorkQueue;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import shadows.apotheosis.ApotheosisObjects;
import shadows.apotheosis.ench.altar.SeaAltarRenderer;
import shadows.apotheosis.ench.table.ApothEnchantScreen;
import shadows.apotheosis.ench.table.EnchantmentStatRegistry;

public class EnchModuleClient {
    static BlockRayTraceResult res = BlockRayTraceResult.func_216352_a((Vector3d)Vector3d.field_186680_a, (Direction)Direction.NORTH, (BlockPos)BlockPos.field_177992_a);

    @SubscribeEvent
    public void tooltips(ItemTooltipEvent e) {
        Item i = e.getItemStack().func_77973_b();
        if (i == Items.field_221672_ax) {
            e.getToolTip().add(new TranslationTextComponent("info.apotheosis.cobweb").func_240699_a_(TextFormatting.GRAY));
        } else if (i == ApotheosisObjects.PRISMATIC_WEB) {
            e.getToolTip().add(new TranslationTextComponent("info.apotheosis.prismatic_cobweb").func_240699_a_(TextFormatting.GRAY));
        } else if (i instanceof BlockItem) {
            Block block = ((BlockItem)i).func_179223_d();
            ClientWorld world = Minecraft.func_71410_x().field_71441_e;
            if (world == null || Minecraft.func_71410_x().field_71439_g == null) {
                return;
            }
            BlockItemUseContext ctx = new BlockItemUseContext((World)world, (PlayerEntity)Minecraft.func_71410_x().field_71439_g, Hand.MAIN_HAND, e.getItemStack(), res){};
            BlockState state = block.func_196258_a(ctx);
            if (state == null) {
                return;
            }
            float maxEterna = EnchantmentStatRegistry.getMaxEterna(state, (World)world, BlockPos.field_177992_a);
            float eterna = EnchantmentStatRegistry.getEterna(state, (World)world, BlockPos.field_177992_a);
            float quanta = EnchantmentStatRegistry.getQuanta(state, (World)world, BlockPos.field_177992_a);
            float arcana = EnchantmentStatRegistry.getArcana(state, (World)world, BlockPos.field_177992_a);
            if (eterna != 0.0f || quanta != 0.0f || arcana != 0.0f) {
                e.getToolTip().add(new TranslationTextComponent("info.apotheosis.ench_stats").func_240699_a_(TextFormatting.GOLD));
            }
            if (eterna != 0.0f) {
                if (eterna > 0.0f) {
                    e.getToolTip().add(new TranslationTextComponent("info.apotheosis.eterna.p", new Object[]{String.format("%.2f", Float.valueOf(eterna)), String.format("%.2f", Float.valueOf(maxEterna))}).func_240699_a_(TextFormatting.GREEN));
                } else {
                    e.getToolTip().add(new TranslationTextComponent("info.apotheosis.eterna", new Object[]{String.format("%.2f", Float.valueOf(eterna))}).func_240699_a_(TextFormatting.GREEN));
                }
            }
            if (quanta != 0.0f) {
                e.getToolTip().add(new TranslationTextComponent("info.apotheosis.quanta" + (quanta > 0.0f ? ".p" : ""), new Object[]{String.format("%.2f", Float.valueOf(quanta * 10.0f))}).func_240699_a_(TextFormatting.RED));
            }
            if (arcana != 0.0f) {
                e.getToolTip().add(new TranslationTextComponent("info.apotheosis.arcana" + (arcana > 0.0f ? ".p" : ""), new Object[]{String.format("%.2f", Float.valueOf(arcana * 10.0f))}).func_240699_a_(TextFormatting.DARK_PURPLE));
            }
        }
    }

    public static void init() {
        DeferredWorkQueue.runLater(() -> {
            ClientRegistry.bindTileEntityRenderer(ApotheosisObjects.ALTAR_TYPE, SeaAltarRenderer::new);
            ClientRegistry.bindTileEntityRenderer(ApotheosisObjects.ENCHANTING_TABLE, EnchantmentTableTileEntityRenderer::new);
            ScreenManager.func_216911_a(ApotheosisObjects.ENCHANTING, ApothEnchantScreen::new);
        });
    }
}

