/*
 * Decompiled with CFR 0.152.
 */
package shadows.apotheosis.ench.asm;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentData;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.FishingBobberEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.CrossbowItem;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.registries.ForgeRegistries;
import shadows.apotheosis.Apotheosis;
import shadows.apotheosis.ApotheosisObjects;
import shadows.apotheosis.ench.EnchModule;
import shadows.apotheosis.ench.EnchantmentInfo;
import shadows.apotheosis.ench.objects.TomeItem;

public class EnchHooks {
    private static ThreadLocal<ListNBT> nbt = new ThreadLocal();

    public static List<EnchantmentData> getEnchantmentDatas(int power, ItemStack stack, boolean allowTreasure) {
        ArrayList<EnchantmentData> list = new ArrayList<EnchantmentData>();
        boolean isBook = stack.func_77973_b() == Items.field_151122_aG;
        boolean typedBook = stack.func_77973_b() instanceof TomeItem;
        block0: for (Enchantment enchantment : ForgeRegistries.ENCHANTMENTS) {
            if (enchantment.func_185261_e() && !allowTreasure || !enchantment.canApplyAtEnchantingTable(stack) && (!isBook || !enchantment.isAllowedOnBooks()) && (!typedBook || !stack.func_77973_b().canApplyAtEnchantingTable(stack, enchantment))) continue;
            EnchantmentInfo info = EnchModule.getEnchInfo(enchantment);
            for (int i = info.getMaxLevel(); i > info.getMinLevel() - 1; --i) {
                if (power < info.getMinPower(i) || power > info.getMaxPower(i)) continue;
                list.add(new EnchantmentData(enchantment, i));
                continue block0;
            }
        }
        return list;
    }

    public static boolean isTempting(boolean was, ItemStack stack) {
        if (EnchantmentHelper.func_77506_a((Enchantment)ApotheosisObjects.TEMPTING, (ItemStack)stack) > 0) {
            return true;
        }
        return was;
    }

    public static void reflectiveHook(LivingEntity user, LivingEntity attacker) {
        int level = EnchantmentHelper.func_77506_a((Enchantment)ApotheosisObjects.REFLECTIVE, (ItemStack)user.func_184607_cu());
        if (level > 0 && user.field_70170_p.field_73012_v.nextInt(Math.max(2, 7 - level)) == 0) {
            DamageSource src = user instanceof PlayerEntity ? DamageSource.func_76365_a((PlayerEntity)((PlayerEntity)user)).func_82726_p().func_76348_h() : DamageSource.field_76376_m;
            attacker.func_70097_a(src, (float)level * 1.6f);
            user.func_184607_cu().func_222118_a(10, attacker, e -> e.func_213361_c(EquipmentSlotType.OFFHAND));
        }
    }

    public static int getMaxLevel(Enchantment ench) {
        if (!Apotheosis.enableEnch) {
            return ench.func_77325_b();
        }
        return EnchModule.getEnchInfo(ench).getMaxLevel();
    }

    public static float getDamageAfterMagicAbsorb(float damage, float enchantModifiers) {
        float clamped = MathHelper.func_76131_a((float)enchantModifiers, (float)0.0f, (float)20.0f);
        float remaining = MathHelper.func_76131_a((float)(enchantModifiers - 20.0f), (float)0.0f, (float)44.0f);
        float factor = 1.0f - clamped / 25.0f;
        if (remaining > 0.0f) {
            factor -= 0.2f * remaining / 60.0f;
        }
        return damage * factor;
    }

    public static int getTicksCaughtDelay(FishingBobberEntity bobber) {
        int lowBound = Math.max(1, 100 - bobber.field_191519_ax * 10);
        int highBound = Math.max(lowBound, 600 - bobber.field_191519_ax * 60);
        return MathHelper.func_76136_a((Random)bobber.field_70146_Z, (int)lowBound, (int)highBound);
    }

    public static void onArrowFired(ItemStack crossbow) {
        int level = EnchantmentHelper.func_77506_a((Enchantment)ApotheosisObjects.CRESCENDO, (ItemStack)crossbow);
        if (level > 0 && nbt.get() != null) {
            int shots = crossbow.func_77978_p().func_74762_e("shots");
            if (shots < level) {
                crossbow.func_77978_p().func_74768_a("shots", shots + 1);
                CrossbowItem.func_220011_a((ItemStack)crossbow, (boolean)true);
                crossbow.func_77978_p().func_218657_a("ChargedProjectiles", (INBT)nbt.get());
            } else {
                crossbow.func_77978_p().func_82580_o("shots");
            }
            nbt.set(null);
        }
    }

    public static void preArrowFired(ItemStack crossbow) {
        int level = EnchantmentHelper.func_77506_a((Enchantment)ApotheosisObjects.CRESCENDO, (ItemStack)crossbow);
        if (level > 0) {
            nbt.set(crossbow.func_77978_p().func_150295_c("ChargedProjectiles", 10).func_74737_b());
        }
    }
}

