/*
 * Decompiled with CFR 0.152.
 */
package shadows.apotheosis.advancements;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.Map;
import java.util.function.Predicate;
import net.minecraft.advancements.criterion.EntityPredicate;
import net.minecraft.advancements.criterion.InventoryChangeTrigger;
import net.minecraft.advancements.criterion.ItemPredicate;
import net.minecraft.advancements.criterion.MinMaxBounds;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.item.SpawnEggItem;
import net.minecraft.loot.ConditionArrayParser;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistries;
import shadows.apotheosis.deadly.loot.LootRarity;
import shadows.apotheosis.deadly.loot.affix.AffixHelper;

public class ExtendedInvTrigger
extends InventoryChangeTrigger {
    public InventoryChangeTrigger.Instance func_230241_b_(JsonObject json, EntityPredicate.AndPredicate andPred, ConditionArrayParser conditionsParser) {
        JsonObject jsonobject = JSONUtils.func_151218_a((JsonObject)json, (String)"slots", (JsonObject)new JsonObject());
        MinMaxBounds.IntBound minmaxbounds$intbound = MinMaxBounds.IntBound.func_211344_a((JsonElement)jsonobject.get("occupied"));
        MinMaxBounds.IntBound minmaxbounds$intbound1 = MinMaxBounds.IntBound.func_211344_a((JsonElement)jsonobject.get("full"));
        MinMaxBounds.IntBound minmaxbounds$intbound2 = MinMaxBounds.IntBound.func_211344_a((JsonElement)jsonobject.get("empty"));
        ItemPredicate[] aitempredicate = ItemPredicate.func_192494_b((JsonElement)json.get("items"));
        if (json.has("apoth")) {
            aitempredicate = this.deserializeApoth(json.getAsJsonObject("apoth"));
        }
        return new InventoryChangeTrigger.Instance(andPred, minmaxbounds$intbound, minmaxbounds$intbound1, minmaxbounds$intbound2, aitempredicate);
    }

    ItemPredicate[] deserializeApoth(JsonObject json) {
        String type = json.get("type").getAsString();
        if (type.equals("spawn_egg")) {
            return new ItemPredicate[]{new TrueItemPredicate(s -> s.func_77973_b() instanceof SpawnEggItem)};
        }
        if (type.equals("enchanted")) {
            Enchantment ench = json.has("enchantment") ? (Enchantment)ForgeRegistries.ENCHANTMENTS.getValue(new ResourceLocation(json.get("enchantment").getAsString())) : null;
            MinMaxBounds.IntBound bound = MinMaxBounds.IntBound.func_211344_a((JsonElement)json.get("level"));
            return new ItemPredicate[]{new TrueItemPredicate(s -> {
                Map enchMap = EnchantmentHelper.func_82781_a((ItemStack)s);
                if (ench != null) {
                    return bound.func_211339_d(enchMap.getOrDefault(ench, 0).intValue());
                }
                return enchMap.values().stream().anyMatch(arg_0 -> ((MinMaxBounds.IntBound)bound).func_211339_d(arg_0));
            })};
        }
        if (type.equals("affix")) {
            return new ItemPredicate[]{new TrueItemPredicate(s -> !AffixHelper.getAffixes(s).isEmpty())};
        }
        if (type.equals("rarity")) {
            LootRarity rarity = LootRarity.valueOf(json.get("rarity").getAsString());
            return new ItemPredicate[]{new TrueItemPredicate(s -> AffixHelper.getRarity(s) == rarity)};
        }
        if (type.equals("nbt")) {
            CompoundNBT tag;
            try {
                tag = JsonToNBT.func_180713_a((String)JSONUtils.func_151206_a((JsonElement)json.get("nbt"), (String)"nbt"));
            }
            catch (CommandSyntaxException e) {
                throw new RuntimeException(e);
            }
            return new ItemPredicate[]{new TrueItemPredicate(s -> {
                if (!s.func_77942_o()) {
                    return false;
                }
                for (String key : tag.func_150296_c()) {
                    if (tag.func_74781_a(key).equals(s.func_77978_p().func_74781_a(key))) continue;
                    return false;
                }
                return true;
            })};
        }
        return new ItemPredicate[0];
    }

    private static class TrueItemPredicate
    extends ItemPredicate {
        Predicate<ItemStack> predicate;

        TrueItemPredicate(Predicate<ItemStack> predicate) {
            this.predicate = predicate;
        }

        public boolean func_192493_a(ItemStack item) {
            return this.predicate.test(item);
        }
    }
}

