/*
 * Decompiled with CFR 0.152.
 */
package shadows.apotheosis.deadly;

import java.io.File;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.resources.IFutureReloadListener;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.registry.WorldGenRegistries;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.feature.Feature;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.AddReloadListenerEvent;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.event.world.BiomeLoadingEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import shadows.apotheosis.Apotheosis;
import shadows.apotheosis.deadly.DeadlyLoot;
import shadows.apotheosis.deadly.config.DeadlyConfig;
import shadows.apotheosis.deadly.gen.BossGenerator;
import shadows.apotheosis.deadly.gen.BrutalSpawnerGenerator;
import shadows.apotheosis.deadly.gen.DeadlyFeature;
import shadows.apotheosis.deadly.gen.SwarmSpawnerGenerator;
import shadows.apotheosis.deadly.loot.BossArmorManager;
import shadows.apotheosis.deadly.loot.LootManager;
import shadows.apotheosis.deadly.loot.affix.AffixEvents;
import shadows.apotheosis.deadly.objects.BossSummonerItem;
import shadows.placebo.config.Configuration;

public class DeadlyModule {
    public static final Logger LOGGER = LogManager.getLogger((String)"Apotheosis : Deadly");

    @SubscribeEvent
    public void preInit(Apotheosis.ApotheosisConstruction e) {
        DeadlyConfig.config = new Configuration(new File(Apotheosis.configDir, "deadly.cfg"));
        MinecraftForge.EVENT_BUS.register((Object)new AffixEvents());
        MinecraftForge.EVENT_BUS.addListener(this::reloads);
        MinecraftForge.EVENT_BUS.addListener(EventPriority.HIGH, this::onBiomeLoad);
    }

    @SubscribeEvent
    public void init(Apotheosis.ApotheosisSetup e) {
        DeadlyConfig.init();
        BrutalSpawnerGenerator.init();
        BossGenerator.init();
        DeadlyLoot.init();
        SwarmSpawnerGenerator.init();
        DeadlyFeature.init();
    }

    @SubscribeEvent
    public void register(RegistryEvent.Register<Feature<?>> e) {
        e.getRegistry().register(DeadlyFeature.INSTANCE.field_222737_a.setRegistryName("deadly_world_gen"));
        Registry.func_218325_a((Registry)WorldGenRegistries.field_243653_e, (String)"apotheosis:deadly_module", DeadlyFeature.INSTANCE);
    }

    @SubscribeEvent
    public void items(RegistryEvent.Register<Item> e) {
        e.getRegistry().register(new BossSummonerItem(new Item.Properties().func_200917_a(1).func_200916_a(ItemGroup.field_78026_f)).setRegistryName("boss_summoner"));
    }

    public void reloads(AddReloadListenerEvent e) {
        e.addListener((IFutureReloadListener)LootManager.INSTANCE);
        e.addListener((IFutureReloadListener)BossArmorManager.INSTANCE);
    }

    public void onBiomeLoad(BiomeLoadingEvent e) {
        if (!DeadlyConfig.BIOME_BLACKLIST.contains(e.getName())) {
            e.getGeneration().getFeatures(GenerationStage.Decoration.UNDERGROUND_DECORATION).add(() -> DeadlyFeature.INSTANCE);
        }
    }
}

