/*
 * Decompiled with CFR 0.152.
 */
package shadows.apotheosis.ench;

import com.google.common.collect.ImmutableSet;
import java.io.File;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.AnvilBlock;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.block.DispenserBlock;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.dispenser.IDispenseItemBehavior;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentType;
import net.minecraft.enchantment.ProtectionEnchantment;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.item.BlockItem;
import net.minecraft.item.HoeItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.ShieldItem;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.potion.Potions;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import shadows.apotheosis.Apotheosis;
import shadows.apotheosis.ApotheosisObjects;
import shadows.apotheosis.ench.EnchModuleClient;
import shadows.apotheosis.ench.EnchModuleEvents;
import shadows.apotheosis.ench.EnchantmentInfo;
import shadows.apotheosis.ench.altar.SeaAltarBlock;
import shadows.apotheosis.ench.altar.SeaAltarTile;
import shadows.apotheosis.ench.anvil.AnvilTile;
import shadows.apotheosis.ench.anvil.ApothAnvilBlock;
import shadows.apotheosis.ench.anvil.ApothAnvilItem;
import shadows.apotheosis.ench.anvil.ObliterationEnchant;
import shadows.apotheosis.ench.anvil.SplittingEnchant;
import shadows.apotheosis.ench.enchantments.BerserkersFuryEnchant;
import shadows.apotheosis.ench.enchantments.CrescendoEnchant;
import shadows.apotheosis.ench.enchantments.HellInfusionEnchantment;
import shadows.apotheosis.ench.enchantments.IcyThornsEnchant;
import shadows.apotheosis.ench.enchantments.KnowledgeEnchant;
import shadows.apotheosis.ench.enchantments.LifeMendingEnchant;
import shadows.apotheosis.ench.enchantments.MagicProtEnchant;
import shadows.apotheosis.ench.enchantments.MinersFervorEnchant;
import shadows.apotheosis.ench.enchantments.NaturesBlessingEnchant;
import shadows.apotheosis.ench.enchantments.ReboundingEnchant;
import shadows.apotheosis.ench.enchantments.ReflectiveEnchant;
import shadows.apotheosis.ench.enchantments.ScavengerEnchant;
import shadows.apotheosis.ench.enchantments.SeaInfusionEnchantment;
import shadows.apotheosis.ench.enchantments.ShieldBashEnchant;
import shadows.apotheosis.ench.enchantments.StableFootingEnchant;
import shadows.apotheosis.ench.enchantments.TemptingEnchant;
import shadows.apotheosis.ench.objects.ApothShearsItem;
import shadows.apotheosis.ench.objects.HellshelfBlock;
import shadows.apotheosis.ench.objects.HellshelfItem;
import shadows.apotheosis.ench.objects.ScrappingTomeItem;
import shadows.apotheosis.ench.objects.SeashelfBlock;
import shadows.apotheosis.ench.objects.SeashelfItem;
import shadows.apotheosis.ench.objects.TomeItem;
import shadows.apotheosis.ench.replacements.BaneEnchant;
import shadows.apotheosis.ench.replacements.DefenseEnchant;
import shadows.apotheosis.ench.table.ApothEnchantBlock;
import shadows.apotheosis.ench.table.ApothEnchantContainer;
import shadows.apotheosis.ench.table.ApothEnchantTile;
import shadows.apotheosis.util.EnchantmentIngredient;
import shadows.placebo.config.Configuration;
import shadows.placebo.loot.LootSystem;
import shadows.placebo.util.PlaceboUtil;

public class EnchModule {
    public static final Map<Enchantment, EnchantmentInfo> ENCHANTMENT_INFO = new HashMap<Enchantment, EnchantmentInfo>();
    public static final Logger LOGGER = LogManager.getLogger((String)"Apotheosis : Enchantment");
    public static final List<TomeItem> TYPED_BOOKS = new LinkedList<TomeItem>();
    public static final DamageSource CORRUPTED = new DamageSource("apoth_corrupted").func_76348_h().func_151518_m();
    public static final EquipmentSlotType[] ARMOR = new EquipmentSlotType[]{EquipmentSlotType.HEAD, EquipmentSlotType.CHEST, EquipmentSlotType.LEGS, EquipmentSlotType.FEET};
    public static final EnchantmentType HOE = EnchantmentType.create((String)"HOE", i -> i instanceof HoeItem);
    public static final EnchantmentType SHIELD = EnchantmentType.create((String)"SHIELD", i -> i instanceof ShieldItem);
    public static final EnchantmentType ANVIL = EnchantmentType.create((String)"ANVIL", i -> i instanceof BlockItem && ((BlockItem)i).func_179223_d() instanceof AnvilBlock);
    static Configuration enchInfoConfig;

    @SubscribeEvent
    public void init(Apotheosis.ApotheosisSetup e) {
        Configuration config = new Configuration(new File(Apotheosis.configDir, "enchantment_module.cfg"));
        if (config.hasChanged()) {
            config.save();
        }
        config = new Configuration(new File(Apotheosis.configDir, "enchantments.cfg"));
        for (Enchantment ench : ForgeRegistries.ENCHANTMENTS) {
            String minF;
            int max = config.getInt("Max Level", ench.getRegistryName().toString(), EnchModule.getDefaultMax(ench), 1, 127, "The max level of this enchantment - normally " + ench.func_77325_b() + ".");
            int min = config.getInt("Min Level", ench.getRegistryName().toString(), ench.func_77319_d(), 1, 127, "The min level of this enchantment.");
            if (min > max) {
                min = max;
            }
            EnchantmentInfo info = new EnchantmentInfo(ench, max, min);
            String maxF = config.getString("Max Power Function", ench.getRegistryName().toString(), "", "A function to determine the max enchanting power.  The variable \"x\" is level.  See: https://github.com/uklimaschewski/EvalEx#usage-examples");
            if (!maxF.isEmpty()) {
                info.setMaxPower(new EnchantmentInfo.ExpressionPowerFunc(maxF));
            }
            if (!(minF = config.getString("Min Power Function", ench.getRegistryName().toString(), "", "A function to determine the min enchanting power.")).isEmpty()) {
                info.setMinPower(new EnchantmentInfo.ExpressionPowerFunc(minF));
            }
            ENCHANTMENT_INFO.put(ench, info);
        }
        if (config.hasChanged()) {
            config.save();
        }
        enchInfoConfig = config;
        Ingredient pot = Apotheosis.potionIngredient(Potions.field_185220_C);
        Apotheosis.HELPER.addShaped((Object)ApotheosisObjects.HELLSHELF, 3, 3, new Object[]{Blocks.field_196653_dH, Blocks.field_196653_dH, Blocks.field_196653_dH, Items.field_151072_bj, "forge:bookshelves", pot, Blocks.field_196653_dH, Blocks.field_196653_dH, Blocks.field_196653_dH});
        Apotheosis.HELPER.addShaped((Object)ApotheosisObjects.PRISMATIC_WEB, 3, 3, new Object[]{null, Items.field_179562_cC, null, Items.field_179562_cC, Blocks.field_196553_aF, Items.field_179562_cC, null, Items.field_179562_cC, null});
        ItemStack book = new ItemStack((IItemProvider)Items.field_151122_aG);
        ItemStack stick = new ItemStack((IItemProvider)Items.field_151055_y);
        ItemStack blaze = new ItemStack((IItemProvider)Items.field_151072_bj);
        Apotheosis.HELPER.addShaped((Object)new ItemStack((IItemProvider)ApotheosisObjects.ARMOR_HEAD_BOOK, 5), 3, 2, new Object[]{book, book, book, book, blaze, book});
        Apotheosis.HELPER.addShaped((Object)new ItemStack((IItemProvider)ApotheosisObjects.ARMOR_CHEST_BOOK, 8), 3, 3, new Object[]{book, blaze, book, book, book, book, book, book, book});
        Apotheosis.HELPER.addShaped((Object)new ItemStack((IItemProvider)ApotheosisObjects.ARMOR_LEGS_BOOK, 7), 3, 3, new Object[]{book, null, book, book, blaze, book, book, book, book});
        Apotheosis.HELPER.addShaped((Object)new ItemStack((IItemProvider)ApotheosisObjects.ARMOR_FEET_BOOK, 4), 3, 2, new Object[]{book, null, book, book, blaze, book});
        Apotheosis.HELPER.addShaped((Object)new ItemStack((IItemProvider)ApotheosisObjects.WEAPON_BOOK, 2), 1, 3, new Object[]{book, book, new ItemStack((IItemProvider)Items.field_151065_br)});
        Apotheosis.HELPER.addShaped((Object)new ItemStack((IItemProvider)ApotheosisObjects.DIGGER_BOOK, 3), 3, 3, new Object[]{book, book, book, null, blaze, null, null, stick, null});
        Apotheosis.HELPER.addShaped((Object)new ItemStack((IItemProvider)ApotheosisObjects.FISHING_ROD_BOOK, 2), 3, 3, new Object[]{null, null, blaze, null, stick, book, stick, null, book});
        Apotheosis.HELPER.addShaped((Object)new ItemStack((IItemProvider)ApotheosisObjects.BOW_BOOK, 3), 3, 3, new Object[]{null, stick, book, blaze, null, book, null, stick, book});
        Apotheosis.HELPER.addShapeless((Object)new ItemStack((IItemProvider)ApotheosisObjects.NULL_BOOK, 6), new Object[]{book, book, book, book, book, book, blaze});
        ItemStack msBrick = new ItemStack((IItemProvider)Blocks.field_196698_dj);
        Apotheosis.HELPER.addShaped((Object)ApotheosisObjects.PRISMATIC_ALTAR, 3, 3, new Object[]{msBrick, null, msBrick, msBrick, Items.field_221944_gd, msBrick, msBrick, Blocks.field_150381_bn, msBrick});
        Apotheosis.HELPER.addShaped((Object)new ItemStack((IItemProvider)ApotheosisObjects.SCRAP_TOME, 8), 3, 3, new Object[]{book, book, book, book, Blocks.field_150467_bQ, book, book, book, book});
        EnchantmentIngredient maxHellshelf = new EnchantmentIngredient((IItemProvider)ApotheosisObjects.HELLSHELF, ApotheosisObjects.HELL_INFUSION, Math.min(3, EnchModule.getEnchInfo(ApotheosisObjects.HELL_INFUSION).getMaxLevel()));
        Apotheosis.HELPER.addShaped((Object)ApotheosisObjects.BLAZING_HELLSHELF, 3, 3, new Object[]{null, Items.field_151059_bz, null, Items.field_151059_bz, maxHellshelf, Items.field_151059_bz, Items.field_151065_br, Items.field_151065_br, Items.field_151065_br});
        Apotheosis.HELPER.addShaped((Object)ApotheosisObjects.GLOWING_HELLSHELF, 3, 3, new Object[]{null, Blocks.field_150426_aN, null, null, maxHellshelf, null, Blocks.field_150426_aN, null, Blocks.field_150426_aN});
        Apotheosis.HELPER.addShaped((Object)ApotheosisObjects.SEASHELF, 3, 3, new Object[]{Blocks.field_196779_gQ, Blocks.field_196779_gQ, Blocks.field_196779_gQ, Apotheosis.potionIngredient(Potions.field_185230_b), "forge:bookshelves", Items.field_196089_aZ, Blocks.field_196779_gQ, Blocks.field_196779_gQ, Blocks.field_196779_gQ});
        EnchantmentIngredient maxSeashelf = new EnchantmentIngredient((IItemProvider)ApotheosisObjects.SEASHELF, ApotheosisObjects.SEA_INFUSION, Math.min(3, EnchModule.getEnchInfo(ApotheosisObjects.SEA_INFUSION).getMaxLevel()));
        Apotheosis.HELPER.addShaped((Object)ApotheosisObjects.CRYSTAL_SEASHELF, 3, 3, new Object[]{null, Items.field_179563_cD, null, null, maxSeashelf, null, Items.field_179563_cD, null, Items.field_179563_cD});
        Apotheosis.HELPER.addShaped((Object)ApotheosisObjects.HEART_SEASHELF, 3, 3, new Object[]{null, Items.field_205158_fa, null, Items.field_179562_cC, maxSeashelf, Items.field_179562_cC, Items.field_179562_cC, Items.field_179562_cC, Items.field_179562_cC});
        Apotheosis.HELPER.addShaped((Object)ApotheosisObjects.ENDSHELF, 3, 3, new Object[]{Blocks.field_196806_hJ, Blocks.field_196806_hJ, Blocks.field_196806_hJ, Items.field_185157_bK, "forge:bookshelves", Items.field_151079_bi, Blocks.field_196806_hJ, Blocks.field_196806_hJ, Blocks.field_196806_hJ});
        Apotheosis.HELPER.addShaped((Object)ApotheosisObjects.PEARL_ENDSHELF, 3, 3, new Object[]{Items.field_221659_bR, null, Items.field_221659_bR, Items.field_151079_bi, ApotheosisObjects.ENDSHELF, Items.field_151079_bi, Items.field_221659_bR, null, Items.field_221659_bR});
        Apotheosis.HELPER.addShaped((Object)ApotheosisObjects.DRACONIC_ENDSHELF, 3, 3, new Object[]{null, Items.field_196151_dA, null, Items.field_151079_bi, ApotheosisObjects.ENDSHELF, Items.field_151079_bi, Items.field_151079_bi, Items.field_151079_bi, Items.field_151079_bi});
        Apotheosis.HELPER.addShaped((Object)ApotheosisObjects.BEESHELF, 3, 3, new Object[]{Items.field_226635_pU_, Items.field_226637_pW_, Items.field_226635_pU_, Items.field_226639_pY_, "forge:bookshelves", Items.field_226639_pY_, Items.field_226635_pU_, Items.field_226637_pW_, Items.field_226635_pU_});
        Apotheosis.HELPER.addShaped((Object)ApotheosisObjects.MELONSHELF, 3, 3, new Object[]{Items.field_221794_dg, Items.field_221794_dg, Items.field_221794_dg, Items.field_151060_bw, "forge:bookshelves", Items.field_151060_bw, Items.field_221794_dg, Items.field_221794_dg, Items.field_221794_dg});
        Apotheosis.HELPER.addShaped((Object)Items.field_151062_by, 3, 3, new Object[]{Items.field_221695_cJ, "forge:gems/diamond", Items.field_221695_cJ, Items.field_151134_bR, Items.field_226638_pX_, Items.field_151134_bR, Items.field_221695_cJ, "forge:gems/diamond", Items.field_221695_cJ});
        LootSystem.defaultBlockTable((Block)ApotheosisObjects.PRISMATIC_ALTAR);
        LootSystem.defaultBlockTable((Block)ApotheosisObjects.BLAZING_HELLSHELF);
        LootSystem.defaultBlockTable((Block)ApotheosisObjects.GLOWING_HELLSHELF);
        LootSystem.defaultBlockTable((Block)ApotheosisObjects.CRYSTAL_SEASHELF);
        LootSystem.defaultBlockTable((Block)ApotheosisObjects.HEART_SEASHELF);
        LootSystem.defaultBlockTable((Block)ApotheosisObjects.ENDSHELF);
        LootSystem.defaultBlockTable((Block)ApotheosisObjects.PEARL_ENDSHELF);
        LootSystem.defaultBlockTable((Block)ApotheosisObjects.DRACONIC_ENDSHELF);
        LootSystem.defaultBlockTable((Block)ApotheosisObjects.BEESHELF);
        LootSystem.defaultBlockTable((Block)ApotheosisObjects.MELONSHELF);
        for (Enchantment ench : ForgeRegistries.ENCHANTMENTS) {
            EnchantmentInfo info = ENCHANTMENT_INFO.get(ench);
            for (int i = 1; i <= info.getMaxLevel(); ++i) {
                if (info.getMinPower(i) <= info.getMaxPower(i)) continue;
                LOGGER.error("Enchantment {} has min/max power {}/{} at level {}, making this level unobtainable.", (Object)ench.getRegistryName(), (Object)info.getMinPower(i), (Object)info.getMaxPower(i), (Object)i);
            }
        }
        MinecraftForge.EVENT_BUS.register((Object)new EnchModuleEvents());
    }

    @SubscribeEvent
    public void client(Apotheosis.ApotheosisClientSetup e) {
        MinecraftForge.EVENT_BUS.register((Object)new EnchModuleClient());
        e.enqueueWork(EnchModuleClient::init);
    }

    @SubscribeEvent
    public void tiles(RegistryEvent.Register<TileEntityType<?>> e) {
        e.getRegistry().register(new TileEntityType(AnvilTile::new, (Set)ImmutableSet.of((Object)Blocks.field_150467_bQ, (Object)Blocks.field_196717_eY, (Object)Blocks.field_196718_eZ), null).setRegistryName("anvil"));
        e.getRegistry().register(new TileEntityType(SeaAltarTile::new, (Set)ImmutableSet.of((Object)((Object)ApotheosisObjects.PRISMATIC_ALTAR)), null).setRegistryName("prismatic_altar"));
        e.getRegistry().register(new TileEntityType(ApothEnchantTile::new, (Set)ImmutableSet.of((Object)Blocks.field_150381_bn), null).setRegistryName("minecraft:enchanting_table"));
    }

    @SubscribeEvent
    public void containers(RegistryEvent.Register<ContainerType<?>> e) {
        e.getRegistry().register(new ContainerType(ApothEnchantContainer::new).setRegistryName("enchanting"));
    }

    @SubscribeEvent
    public void blocks(RegistryEvent.Register<Block> e) {
        e.getRegistry().registerAll((IForgeRegistryEntry[])new Block[]{(Block)new SeaAltarBlock().setRegistryName("apotheosis", "prismatic_altar"), (Block)new ApothAnvilBlock().setRegistryName("minecraft", "anvil"), (Block)new ApothAnvilBlock().setRegistryName("minecraft", "chipped_anvil"), (Block)new ApothAnvilBlock().setRegistryName("minecraft", "damaged_anvil"), (Block)new HellshelfBlock().setRegistryName("hellshelf"), (Block)new Block(AbstractBlock.Properties.func_200945_a((Material)Material.field_151576_e).func_200943_b(1.5f).func_200947_a(SoundType.field_185851_d)).setRegistryName("blazing_hellshelf"), (Block)new Block(AbstractBlock.Properties.func_200945_a((Material)Material.field_151576_e).func_200943_b(1.5f).func_200947_a(SoundType.field_185851_d)).setRegistryName("glowing_hellshelf"), (Block)new SeashelfBlock().setRegistryName("seashelf"), (Block)new Block(AbstractBlock.Properties.func_200945_a((Material)Material.field_151576_e).func_200943_b(1.5f).func_200947_a(SoundType.field_185851_d)).setRegistryName("crystal_seashelf"), (Block)new Block(AbstractBlock.Properties.func_200945_a((Material)Material.field_151576_e).func_200943_b(1.5f).func_200947_a(SoundType.field_185851_d)).setRegistryName("heart_seashelf"), (Block)new Block(AbstractBlock.Properties.func_200945_a((Material)Material.field_151576_e).func_200943_b(1.5f).func_200947_a(SoundType.field_185851_d)).setRegistryName("endshelf"), (Block)new Block(AbstractBlock.Properties.func_200945_a((Material)Material.field_151576_e).func_200943_b(1.5f).func_200947_a(SoundType.field_185851_d)).setRegistryName("pearl_endshelf"), (Block)new Block(AbstractBlock.Properties.func_200945_a((Material)Material.field_151576_e).func_200943_b(1.5f).func_200947_a(SoundType.field_185851_d)).setRegistryName("draconic_endshelf"), (Block)new Block(AbstractBlock.Properties.func_200945_a((Material)Material.field_151575_d).func_200943_b(1.5f).func_200947_a(SoundType.field_185848_a)).setRegistryName("beeshelf"), (Block)new Block(AbstractBlock.Properties.func_200945_a((Material)Material.field_151572_C).func_200943_b(1.5f).func_200947_a(SoundType.field_185848_a)).setRegistryName("melonshelf")});
        PlaceboUtil.registerOverrideBlock((Block)((Block)new ApothEnchantBlock().setRegistryName("minecraft:enchanting_table")), (String)"apotheosis");
    }

    @SubscribeEvent
    public void items(RegistryEvent.Register<Item> e) {
        Item oldShears = Items.field_151097_aZ;
        Item[] itemArray = new Item[27];
        ApothShearsItem shears = new ApothShearsItem();
        itemArray[0] = shears;
        itemArray[1] = (Item)new Item(new Item.Properties().func_200916_a(ItemGroup.field_78026_f)).setRegistryName("apotheosis", "prismatic_web");
        itemArray[2] = new ApothAnvilItem(Blocks.field_150467_bQ);
        itemArray[3] = new ApothAnvilItem(Blocks.field_196717_eY);
        itemArray[4] = new ApothAnvilItem(Blocks.field_196718_eZ);
        itemArray[5] = new TomeItem(Items.field_190931_a, null);
        itemArray[6] = new TomeItem(Items.field_151161_ac, EnchantmentType.ARMOR_HEAD);
        itemArray[7] = new TomeItem(Items.field_151163_ad, EnchantmentType.ARMOR_CHEST);
        itemArray[8] = new TomeItem(Items.field_151173_ae, EnchantmentType.ARMOR_LEGS);
        itemArray[9] = new TomeItem(Items.field_151175_af, EnchantmentType.ARMOR_FEET);
        itemArray[10] = new TomeItem(Items.field_151048_u, EnchantmentType.WEAPON);
        itemArray[11] = new TomeItem(Items.field_151046_w, EnchantmentType.DIGGER);
        itemArray[12] = new TomeItem(Items.field_151112_aM, EnchantmentType.FISHING_ROD);
        itemArray[13] = new TomeItem(Items.field_151031_f, EnchantmentType.BOW);
        itemArray[14] = (Item)new BlockItem((Block)ApotheosisObjects.PRISMATIC_ALTAR, new Item.Properties().func_200916_a(ItemGroup.field_78030_b)).setRegistryName("prismatic_altar");
        itemArray[15] = new ScrappingTomeItem();
        itemArray[16] = (Item)new HellshelfItem(ApotheosisObjects.HELLSHELF).setRegistryName(ApotheosisObjects.HELLSHELF.getRegistryName());
        itemArray[17] = (Item)new BlockItem(ApotheosisObjects.BLAZING_HELLSHELF, new Item.Properties().func_200916_a(ItemGroup.field_78030_b)).setRegistryName("blazing_hellshelf");
        itemArray[18] = (Item)new BlockItem(ApotheosisObjects.GLOWING_HELLSHELF, new Item.Properties().func_200916_a(ItemGroup.field_78030_b)).setRegistryName("glowing_hellshelf");
        itemArray[19] = (Item)new SeashelfItem(ApotheosisObjects.SEASHELF).setRegistryName(ApotheosisObjects.SEASHELF.getRegistryName());
        itemArray[20] = (Item)new BlockItem(ApotheosisObjects.CRYSTAL_SEASHELF, new Item.Properties().func_200916_a(ItemGroup.field_78030_b)).setRegistryName("crystal_seashelf");
        itemArray[21] = (Item)new BlockItem(ApotheosisObjects.HEART_SEASHELF, new Item.Properties().func_200916_a(ItemGroup.field_78030_b)).setRegistryName("heart_seashelf");
        itemArray[22] = (Item)new BlockItem(ApotheosisObjects.ENDSHELF, new Item.Properties().func_200916_a(ItemGroup.field_78030_b)).setRegistryName("endshelf");
        itemArray[23] = (Item)new BlockItem(ApotheosisObjects.DRACONIC_ENDSHELF, new Item.Properties().func_200916_a(ItemGroup.field_78030_b)).setRegistryName("draconic_endshelf");
        itemArray[24] = (Item)new BlockItem(ApotheosisObjects.PEARL_ENDSHELF, new Item.Properties().func_200916_a(ItemGroup.field_78030_b)).setRegistryName("pearl_endshelf");
        itemArray[25] = (Item)new BlockItem(ApotheosisObjects.BEESHELF, new Item.Properties().func_200916_a(ItemGroup.field_78030_b)).setRegistryName("beeshelf");
        itemArray[26] = (Item)new BlockItem(ApotheosisObjects.MELONSHELF, new Item.Properties().func_200916_a(ItemGroup.field_78030_b)).setRegistryName("melonshelf");
        e.getRegistry().registerAll((IForgeRegistryEntry[])itemArray);
        DispenserBlock.func_199774_a((IItemProvider)shears, (IDispenseItemBehavior)((IDispenseItemBehavior)DispenserBlock.field_149943_a.get(oldShears)));
    }

    @SubscribeEvent
    public void enchants(RegistryEvent.Register<Enchantment> e) {
        e.getRegistry().registerAll((IForgeRegistryEntry[])new Enchantment[]{(Enchantment)new HellInfusionEnchantment().setRegistryName("apotheosis", "hell_infusion"), (Enchantment)new MinersFervorEnchant().setRegistryName("apotheosis", "depth_miner"), (Enchantment)new StableFootingEnchant().setRegistryName("apotheosis", "stable_footing"), (Enchantment)new ScavengerEnchant().setRegistryName("apotheosis", "scavenger"), (Enchantment)new LifeMendingEnchant().setRegistryName("apotheosis", "life_mending"), (Enchantment)new IcyThornsEnchant().setRegistryName("apotheosis", "icy_thorns"), (Enchantment)new TemptingEnchant().setRegistryName("apotheosis", "tempting"), (Enchantment)new ShieldBashEnchant().setRegistryName("apotheosis", "shield_bash"), (Enchantment)new ReflectiveEnchant().setRegistryName("apotheosis", "reflective"), (Enchantment)new BerserkersFuryEnchant().setRegistryName("apotheosis", "berserk"), (Enchantment)new KnowledgeEnchant().setRegistryName("apotheosis", "knowledge"), (Enchantment)new SplittingEnchant().setRegistryName("apotheosis", "splitting"), (Enchantment)new NaturesBlessingEnchant().setRegistryName("apotheosis", "natures_blessing"), (Enchantment)new ReboundingEnchant().setRegistryName("apotheosis", "rebounding"), (Enchantment)new MagicProtEnchant().setRegistryName("apotheosis", "magic_protection"), (Enchantment)new SeaInfusionEnchantment().setRegistryName("sea_infusion"), (Enchantment)new BaneEnchant(Enchantment.Rarity.UNCOMMON, CreatureAttribute.field_223224_c_, EquipmentSlotType.MAINHAND).setRegistryName("minecraft", "bane_of_arthropods"), (Enchantment)new BaneEnchant(Enchantment.Rarity.UNCOMMON, CreatureAttribute.field_223223_b_, EquipmentSlotType.MAINHAND).setRegistryName("minecraft", "smite"), (Enchantment)new BaneEnchant(Enchantment.Rarity.COMMON, CreatureAttribute.field_223222_a_, EquipmentSlotType.MAINHAND).setRegistryName("minecraft", "sharpness"), (Enchantment)new BaneEnchant(Enchantment.Rarity.UNCOMMON, CreatureAttribute.field_223225_d_, EquipmentSlotType.MAINHAND).setRegistryName("bane_of_illagers"), (Enchantment)new DefenseEnchant(Enchantment.Rarity.COMMON, ProtectionEnchantment.Type.ALL, ARMOR).setRegistryName("minecraft", "protection"), (Enchantment)new DefenseEnchant(Enchantment.Rarity.UNCOMMON, ProtectionEnchantment.Type.ALL, ARMOR).setRegistryName("minecraft", "fire_protection"), (Enchantment)new DefenseEnchant(Enchantment.Rarity.RARE, ProtectionEnchantment.Type.ALL, ARMOR).setRegistryName("minecraft", "blast_protection"), (Enchantment)new DefenseEnchant(Enchantment.Rarity.UNCOMMON, ProtectionEnchantment.Type.ALL, ARMOR).setRegistryName("minecraft", "projectile_protection"), (Enchantment)new DefenseEnchant(Enchantment.Rarity.UNCOMMON, ProtectionEnchantment.Type.ALL, EquipmentSlotType.FEET).setRegistryName("minecraft", "feather_falling"), (Enchantment)new ObliterationEnchant().setRegistryName("obliteration"), (Enchantment)new CrescendoEnchant().setRegistryName("crescendo")});
    }

    @SubscribeEvent
    public void sounds(RegistryEvent.Register<SoundEvent> e) {
        e.getRegistry().register(new SoundEvent(new ResourceLocation("apotheosis", "altar")).setRegistryName("apotheosis", "altar_sound"));
    }

    public static EnchantmentInfo getEnchInfo(Enchantment ench) {
        EnchantmentInfo info = ENCHANTMENT_INFO.get(ench);
        if (!Apotheosis.enableEnch) {
            return ENCHANTMENT_INFO.computeIfAbsent(ench, e -> new EnchantmentInfo((Enchantment)e, e.func_77325_b(), e.func_77319_d()));
        }
        if (enchInfoConfig == null) {
            LOGGER.error("A mod has attempted to access enchantment information before Apotheosis init, this should not happen.");
            Thread.dumpStack();
            return new EnchantmentInfo(ench, ench.func_77325_b(), ench.func_77319_d());
        }
        if (info == null) {
            String minF;
            int max = enchInfoConfig.getInt("Max Level", ench.getRegistryName().toString(), EnchModule.getDefaultMax(ench), 1, 127, "The max level of this enchantment - normally " + ench.func_77325_b() + ".");
            int min = enchInfoConfig.getInt("Min Level", ench.getRegistryName().toString(), ench.func_77319_d(), 1, 127, "The min level of this enchantment.");
            if (min > max) {
                min = max;
            }
            info = new EnchantmentInfo(ench, max, min);
            String maxF = enchInfoConfig.getString("Max Power Function", ench.getRegistryName().toString(), "", "A function to determine the max enchanting power.  The variable \"x\" is level.  See: https://github.com/uklimaschewski/EvalEx#usage-examples");
            if (!maxF.isEmpty()) {
                info.setMaxPower(new EnchantmentInfo.ExpressionPowerFunc(maxF));
            }
            if (!(minF = enchInfoConfig.getString("Min Power Function", ench.getRegistryName().toString(), "", "A function to determine the min enchanting power.")).isEmpty()) {
                info.setMinPower(new EnchantmentInfo.ExpressionPowerFunc(minF));
            }
            ENCHANTMENT_INFO.put(ench, info);
            if (enchInfoConfig.hasChanged()) {
                enchInfoConfig.save();
            }
            LOGGER.error("Had to late load enchantment info for {}, this is a bug in the mod {} as they are registering late!", (Object)ench.getRegistryName(), (Object)ench.getRegistryName().func_110624_b());
        }
        return info;
    }

    public static int getDefaultMax(Enchantment ench) {
        int level = ench.func_77325_b();
        if (level == 1) {
            return 1;
        }
        int minPower = ench.func_77321_a(level);
        if (minPower >= 150) {
            return level;
        }
        int lastPower = minPower;
        while (minPower < 150) {
            int diff = ench.func_77321_a(++level) - ench.func_77321_a(level - 1);
            int n = minPower = level > ench.func_77325_b() ? ench.func_77321_a(level) + diff * (int)Math.pow(level - ench.func_77325_b(), 1.6) : ench.func_77321_a(level);
            if (lastPower == minPower) {
                --level;
                break;
            }
            lastPower = minPower;
        }
        return level;
    }
}

