/*
 * Decompiled with CFR 0.152.
 */
package shadows.apotheosis.ench.table;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.client.resources.JsonReloadListener;
import net.minecraft.profiler.IProfiler;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IRegistryDelegate;
import shadows.apotheosis.ench.EnchModule;
import shadows.apotheosis.ench.objects.IEnchantingBlock;

public class EnchantingStatManager
extends JsonReloadListener {
    public static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    public static final EnchantingStatManager INSTANCE = new EnchantingStatManager();
    private final Map<IRegistryDelegate<Block>, Stats> stats = new HashMap<IRegistryDelegate<Block>, Stats>();

    protected EnchantingStatManager() {
        super(GSON, "enchanting_stats");
    }

    protected void apply(Map<ResourceLocation, JsonElement> objects, IResourceManager mgr, IProfiler profile) {
        this.stats.clear();
        objects.forEach((key, ele) -> {
            try {
                JsonObject obj = (JsonObject)ele;
                Block b = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(obj.get("block").getAsString()));
                Stats stats = (Stats)GSON.fromJson(obj.get("stats"), Stats.class);
                this.stats.put((IRegistryDelegate<Block>)b.delegate, stats);
            }
            catch (Exception e) {
                EnchModule.LOGGER.error("Failed to read enchantment stat file {}.", key);
                e.printStackTrace();
            }
        });
    }

    public static float getEterna(BlockState state, World world, BlockPos pos) {
        Block block = state.func_177230_c();
        if (EnchantingStatManager.INSTANCE.stats.containsKey(block.delegate)) {
            return EnchantingStatManager.INSTANCE.stats.get((Object)block.delegate).eterna;
        }
        return state.getEnchantPowerBonus((IWorldReader)world, pos);
    }

    public static float getMaxEterna(BlockState state, World world, BlockPos pos) {
        Block block = state.func_177230_c();
        if (EnchantingStatManager.INSTANCE.stats.containsKey(block.delegate)) {
            return EnchantingStatManager.INSTANCE.stats.get((Object)block.delegate).maxEterna;
        }
        if (block instanceof IEnchantingBlock) {
            return ((IEnchantingBlock)block).getMaxEnchantingPower(state, (IWorldReader)world, pos);
        }
        return 15.0f;
    }

    public static float getQuanta(BlockState state, World world, BlockPos pos) {
        Block block = state.func_177230_c();
        if (EnchantingStatManager.INSTANCE.stats.containsKey(block.delegate)) {
            return EnchantingStatManager.INSTANCE.stats.get((Object)block.delegate).quanta;
        }
        if (block instanceof IEnchantingBlock) {
            return ((IEnchantingBlock)block).getQuantaBonus(state, (IWorldReader)world, pos);
        }
        return 0.0f;
    }

    public static float getArcana(BlockState state, World world, BlockPos pos) {
        Block block = state.func_177230_c();
        if (EnchantingStatManager.INSTANCE.stats.containsKey(block.delegate)) {
            return EnchantingStatManager.INSTANCE.stats.get((Object)block.delegate).arcana;
        }
        if (block instanceof IEnchantingBlock) {
            return ((IEnchantingBlock)block).getArcanaBonus(state, (IWorldReader)world, pos);
        }
        return 0.0f;
    }

    public static class Stats {
        final float maxEterna;
        final float eterna;
        final float quanta;
        final float arcana;

        public Stats(float maxEterna, float eterna, float quanta, float arcana) {
            this.maxEterna = maxEterna;
            this.eterna = eterna;
            this.quanta = quanta;
            this.arcana = arcana;
        }
    }
}

