/*
 * Decompiled with CFR 0.152.
 */
package shadows.apotheosis.util;

import com.google.common.collect.ImmutableMap;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Map;
import java.util.stream.Stream;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.common.crafting.IIngredientSerializer;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.ForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import shadows.apotheosis.deadly.loot.affix.AffixHelper;

public class EnchantmentIngredient
extends Ingredient {
    protected final IItemProvider item;
    protected final Enchantment enchantment;
    protected final int minLevel;

    public EnchantmentIngredient(IItemProvider item, Enchantment enchantment, int minLevel) {
        super(Stream.of(new Ingredient.SingleItemList(EnchantmentIngredient.format(item, enchantment, minLevel))));
        this.item = item;
        this.enchantment = enchantment;
        this.minLevel = minLevel;
    }

    private static ItemStack format(IItemProvider item, Enchantment enchantment, int minLevel) {
        ItemStack stack = new ItemStack(item);
        EnchantmentHelper.func_82782_a((Map)ImmutableMap.of((Object)enchantment, (Object)minLevel), (ItemStack)stack);
        AffixHelper.addLore(stack, (ITextComponent)new TranslationTextComponent("ingredient.apotheosis.ench", new Object[]{((IFormattableTextComponent)enchantment.func_200305_d(minLevel)).func_240701_a_(new TextFormatting[]{TextFormatting.DARK_PURPLE, TextFormatting.ITALIC})}));
        return stack;
    }

    public boolean test(ItemStack stack) {
        return super.test(stack) && EnchantmentHelper.func_77506_a((Enchantment)this.enchantment, (ItemStack)stack) >= this.minLevel;
    }

    public boolean isSimple() {
        return false;
    }

    public IIngredientSerializer<? extends Ingredient> getSerializer() {
        return Serializer.INSTANCE;
    }

    public JsonElement func_200304_c() {
        return new JsonObject();
    }

    public static class Serializer
    implements IIngredientSerializer<EnchantmentIngredient> {
        public static final Serializer INSTANCE = new Serializer();

        public EnchantmentIngredient parse(PacketBuffer buffer) {
            ItemStack stack = buffer.func_150791_c();
            Enchantment ench = (Enchantment)((ForgeRegistry)ForgeRegistries.ENCHANTMENTS).getValue(buffer.func_150792_a());
            short level = buffer.readShort();
            return new EnchantmentIngredient((IItemProvider)stack.func_77973_b(), ench, level);
        }

        public EnchantmentIngredient parse(JsonObject json) {
            return null;
        }

        public void write(PacketBuffer buffer, EnchantmentIngredient ingredient) {
            buffer.func_150788_a(new ItemStack(ingredient.item));
            buffer.func_150787_b(((ForgeRegistry)ForgeRegistries.ENCHANTMENTS).getID((IForgeRegistryEntry)ingredient.enchantment));
            buffer.writeShort(ingredient.minLevel);
        }
    }
}

