/*
 * Decompiled with CFR 0.152.
 */
package com.teammetallurgy.aquaculture.entity;

import com.teammetallurgy.aquaculture.api.AquacultureAPI;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.RedstoneDiodeBlock;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.Pose;
import net.minecraft.entity.item.HangingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.GameRules;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;
import net.minecraftforge.fml.network.FMLPlayMessages;
import net.minecraftforge.fml.network.NetworkHooks;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.commons.lang3.Validate;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class FishMountEntity
extends HangingEntity
implements IEntityAdditionalSpawnData {
    private static final Logger PRIVATE_LOGGER = LogManager.getLogger();
    private static final DataParameter<ItemStack> ITEM = EntityDataManager.func_187226_a(FishMountEntity.class, (IDataSerializer)DataSerializers.field_187196_f);
    private float itemDropChance = 1.0f;
    public Entity entity;

    public FishMountEntity(EntityType<? extends FishMountEntity> type, World world) {
        super(type, world);
    }

    public FishMountEntity(EntityType<? extends FishMountEntity> type, World world, BlockPos blockPos, Direction direction) {
        super(type, world, blockPos);
        this.func_174859_a(direction);
    }

    public FishMountEntity(FMLPlayMessages.SpawnEntity spawnPacket, World world) {
        this((EntityType<? extends FishMountEntity>)((EntityType)ForgeRegistries.ENTITIES.getValue(spawnPacket.getAdditionalData().func_192575_l())), world);
    }

    protected float func_213316_a(Pose pose, EntitySize size) {
        return 0.0f;
    }

    protected void func_70088_a() {
        this.func_184212_Q().func_187214_a(ITEM, (Object)ItemStack.field_190927_a);
    }

    protected void func_174859_a(Direction direction) {
        Validate.notNull((Object)direction);
        this.field_174860_b = direction;
        if (direction.func_176740_k().func_176722_c()) {
            this.field_70125_A = 0.0f;
            this.field_70177_z = this.field_174860_b.func_176736_b() * 90;
        } else {
            this.field_70125_A = -90 * direction.func_176743_c().func_179524_a();
            this.field_70177_z = 0.0f;
        }
        this.field_70127_C = this.field_70125_A;
        this.field_70126_B = this.field_70177_z;
        this.func_174856_o();
    }

    public boolean func_70518_d() {
        if (!this.field_70170_p.func_226669_j_((Entity)this)) {
            return false;
        }
        BlockState state = this.field_70170_p.func_180495_p(this.field_174861_a.func_177972_a(this.field_174860_b.func_176734_d()));
        return (state.func_185904_a().func_76220_a() || this.field_174860_b.func_176740_k().func_176722_c() && RedstoneDiodeBlock.func_185546_B((BlockState)state)) && this.field_70170_p.func_175674_a((Entity)this, this.func_174813_aQ(), field_184524_c).isEmpty();
    }

    protected void func_174856_o() {
        if (this.field_174860_b != null) {
            double d0 = 0.46875;
            double posX = (double)this.field_174861_a.func_177958_n() + 0.5 - (double)this.field_174860_b.func_82601_c() * d0;
            double posY = (double)this.field_174861_a.func_177956_o() + 0.5 - (double)this.field_174860_b.func_96559_d() * d0;
            double posZ = (double)this.field_174861_a.func_177952_p() + 0.5 - (double)this.field_174860_b.func_82599_e() * d0;
            this.func_226288_n_(posX, posY, posZ);
            double x1 = (double)this.func_82329_d() / 32.0;
            double x2 = (double)this.func_82329_d() / 32.0;
            double y1 = (double)this.func_82330_g() / 32.0;
            double y2 = (double)this.func_82330_g() / 32.0;
            double z1 = (double)this.func_82329_d() / 32.0;
            double z2 = (double)this.func_82329_d() / 32.0;
            switch (this.field_174860_b.func_176740_k()) {
                case X: {
                    x1 = (this.field_174860_b.func_82601_c() < 0 ? 3.0 : 1.0) / 32.0;
                    x2 = (this.field_174860_b.func_82601_c() > 0 ? 3.0 : 1.0) / 32.0;
                    break;
                }
                case Y: {
                    y1 = (this.field_174860_b.func_96559_d() < 0 ? 3.0 : 1.0) / 32.0;
                    y2 = (this.field_174860_b.func_96559_d() > 0 ? 3.0 : 1.0) / 32.0;
                    z1 = 0.25;
                    z2 = 0.25;
                    break;
                }
                case Z: {
                    z1 = (this.field_174860_b.func_82599_e() < 0 ? 3.0 : 1.0) / 32.0;
                    z2 = (this.field_174860_b.func_82599_e() > 0 ? 3.0 : 1.0) / 32.0;
                }
            }
            this.func_174826_a(new AxisAlignedBB(posX - x1, posY - y1, posZ - z1, posX + x2, posY + y2, posZ + z2));
        }
    }

    public void func_174812_G() {
        this.setDisplayedItem(ItemStack.field_190927_a);
        super.func_174812_G();
    }

    public boolean func_70097_a(@Nonnull DamageSource source, float amount) {
        if (this.func_180431_b(source)) {
            return false;
        }
        if (!source.func_94541_c() && !this.getDisplayedItem().func_190926_b()) {
            if (!this.field_70170_p.field_72995_K) {
                this.dropItemOrSelf(source.func_76346_g(), false);
                this.func_184185_a(SoundEvents.field_187629_cO, 1.0f, 1.0f);
            }
            return true;
        }
        return super.func_70097_a(source, amount);
    }

    public int func_82329_d() {
        return 12;
    }

    public int func_82330_g() {
        return 8;
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean func_70112_a(double distance) {
        double d0 = 16.0;
        return distance < (d0 = d0 * 64.0 * FishMountEntity.func_184183_bd()) * d0;
    }

    public void func_110128_b(@Nullable Entity brokenEntity) {
        this.func_184185_a(SoundEvents.field_187623_cM, 1.0f, 1.0f);
        this.dropItemOrSelf(brokenEntity, true);
    }

    public void func_184523_o() {
        this.func_184185_a(SoundEvents.field_187626_cN, 1.0f, 1.0f);
    }

    private void dropItemOrSelf(@Nullable Entity entity, boolean shouldDropSelf) {
        if (!this.field_70170_p.func_82736_K().func_223586_b(GameRules.field_223604_g)) {
            if (entity == null) {
                this.setDisplayedItem(ItemStack.field_190927_a);
            }
        } else {
            ItemStack displayStack = this.getDisplayedItem();
            this.setDisplayedItem(ItemStack.field_190927_a);
            if (entity instanceof PlayerEntity) {
                PlayerEntity playerentity = (PlayerEntity)entity;
                if (playerentity.field_71075_bZ.field_75098_d) {
                    this.setDisplayedItem(ItemStack.field_190927_a);
                    return;
                }
            }
            if (shouldDropSelf) {
                this.func_199703_a((IItemProvider)this.getItem());
            }
            if (!displayStack.func_190926_b()) {
                displayStack = displayStack.func_77946_l();
                if (this.field_70146_Z.nextFloat() < this.itemDropChance) {
                    this.func_199701_a_(displayStack);
                }
            }
        }
    }

    private Item getItem() {
        ResourceLocation location = this.func_200600_R().getRegistryName();
        if (ForgeRegistries.ITEMS.containsKey(location) && location != null) {
            return (Item)ForgeRegistries.ITEMS.getValue(location);
        }
        return Items.field_190931_a;
    }

    @Nonnull
    public ItemStack getDisplayedItem() {
        return (ItemStack)this.func_184212_Q().func_187225_a(ITEM);
    }

    public void setDisplayedItem(@Nonnull ItemStack stack) {
        this.setDisplayedItemWithUpdate(stack, true);
    }

    public void setDisplayedItemWithUpdate(@Nonnull ItemStack stack, boolean shouldUpdate) {
        if (!stack.func_190926_b()) {
            stack = stack.func_77946_l();
            stack.func_190920_e(1);
        }
        this.func_184212_Q().func_187227_b(ITEM, (Object)stack);
        if (!stack.func_190926_b()) {
            this.func_184185_a(SoundEvents.field_187620_cL, 1.0f, 1.0f);
        }
        if (shouldUpdate && this.field_174861_a != null) {
            this.field_70170_p.func_175666_e(this.field_174861_a, Blocks.field_150350_a);
        }
    }

    public boolean func_174820_d(int inventorySlot, @Nonnull ItemStack stack) {
        if (inventorySlot == 0) {
            this.setDisplayedItem(stack);
            return true;
        }
        return false;
    }

    public void func_184206_a(DataParameter<?> key) {
        if (key.equals(ITEM)) {
            ItemStack displayStack = this.getDisplayedItem();
            if (displayStack != null && !displayStack.func_190926_b()) {
                EntityType entityType = (EntityType)ForgeRegistries.ENTITIES.getValue(displayStack.func_77973_b().getRegistryName());
                if (entityType != null && entityType != EntityType.field_200784_X) {
                    this.entity = entityType.func_200721_a(this.field_70170_p);
                }
            } else {
                this.entity = null;
            }
        }
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        if (!this.getDisplayedItem().func_190926_b()) {
            compound.func_218657_a("Item", (INBT)this.getDisplayedItem().func_77955_b(new CompoundNBT()));
            compound.func_74776_a("ItemDropChance", this.itemDropChance);
        }
        compound.func_74774_a("Facing", (byte)this.field_174860_b.func_176745_a());
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        CompoundNBT nbt = compound.func_74775_l("Item");
        if (nbt != null && !nbt.isEmpty()) {
            ItemStack displayStack;
            ItemStack nbtStack = ItemStack.func_199557_a((CompoundNBT)nbt);
            if (nbtStack.func_190926_b()) {
                PRIVATE_LOGGER.warn("Unable to load item from: {}", (Object)nbt);
            }
            if (!(displayStack = this.getDisplayedItem()).func_190926_b() && !ItemStack.func_77989_b((ItemStack)nbtStack, (ItemStack)displayStack)) {
                this.setDisplayedItem(ItemStack.field_190927_a);
            }
            this.setDisplayedItemWithUpdate(nbtStack, false);
            if (compound.func_150297_b("ItemDropChance", 99)) {
                this.itemDropChance = compound.func_74760_g("ItemDropChance");
            }
        }
        this.func_174859_a(Direction.func_82600_a((int)compound.func_74771_c("Facing")));
    }

    @Nonnull
    public ActionResultType func_184230_a(PlayerEntity player, @Nonnull Hand hand) {
        ItemStack heldStack = player.func_184586_b(hand);
        if (!this.field_70170_p.field_72995_K) {
            Item heldItem;
            EntityType entityType;
            if (this.getDisplayedItem().func_190926_b() && (entityType = (EntityType)ForgeRegistries.ENTITIES.getValue((heldItem = heldStack.func_77973_b()).getRegistryName())) != EntityType.field_200784_X && AquacultureAPI.FISH_DATA.getFish().contains(heldItem)) {
                this.setDisplayedItem(heldStack);
                if (!player.field_71075_bZ.field_75098_d) {
                    heldStack.func_190918_g(1);
                }
            }
            return ActionResultType.CONSUME;
        }
        return super.func_184230_a(player, hand);
    }

    @Nonnull
    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public ItemStack getPickedResult(RayTraceResult target) {
        return !this.getDisplayedItem().func_190926_b() ? this.getDisplayedItem() : new ItemStack((IItemProvider)this.getItem());
    }

    protected void func_70101_b(float yaw, float pitch) {
        super.func_70101_b(yaw, pitch);
        if (pitch == 0.0f) {
            this.func_174859_a(Direction.func_176733_a((double)yaw));
        } else {
            this.func_174859_a(pitch < 0.0f ? Direction.UP : Direction.DOWN);
        }
    }

    public void writeSpawnData(PacketBuffer buffer) {
        buffer.func_192572_a(this.func_200600_R().getRegistryName());
    }

    public void readSpawnData(PacketBuffer additionalData) {
    }
}

