/*
 * Decompiled with CFR 0.152.
 */
package com.teammetallurgy.aquaculture.init;

import com.google.common.collect.Lists;
import com.teammetallurgy.aquaculture.entity.AquaFishingBobberEntity;
import com.teammetallurgy.aquaculture.entity.TurtleLandEntity;
import com.teammetallurgy.aquaculture.entity.WaterArrowEntity;
import com.teammetallurgy.aquaculture.init.AquaItems;
import com.teammetallurgy.aquaculture.loot.BiomePropertiesPredicate;
import com.teammetallurgy.aquaculture.misc.AquaConfig;
import com.teammetallurgy.aquaculture.misc.BiomeHelper;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntitySpawnPlacementRegistry;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.GlobalEntityTypeAttributes;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.SpawnEggItem;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.Heightmap;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.event.world.BiomeLoadingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ObjectHolder;

@Mod.EventBusSubscriber(modid="aquaculture", bus=Mod.EventBusSubscriber.Bus.MOD)
@ObjectHolder(value="aquaculture")
public class AquaEntities {
    private static final List<EntityType<?>> ENTITIES = Lists.newArrayList();
    private static final List<EntityType<?>> MOBS = Lists.newArrayList();
    public static final EntityType<AquaFishingBobberEntity> BOBBER = AquaEntities.register("bobber", EntityType.Builder.func_220319_a((EntityClassification)EntityClassification.MISC).func_200706_c().func_200705_b().func_220321_a(0.25f, 0.25f).setTrackingRange(4).setUpdateInterval(5).setCustomClientFactory(AquaFishingBobberEntity::new));
    public static final EntityType<WaterArrowEntity> WATER_ARROW = AquaEntities.register("water_arrow", EntityType.Builder.func_220322_a(WaterArrowEntity::new, (EntityClassification)EntityClassification.MISC).func_220321_a(0.5f, 0.5f).setCustomClientFactory(WaterArrowEntity::new));
    public static final EntityType<TurtleLandEntity> BOX_TURTLE = AquaEntities.registerMob("box_turtle", 1, 2, 9, Biome.Category.SWAMP, null, null, null, 8356921, 6119722, EntityType.Builder.func_220322_a(TurtleLandEntity::new, (EntityClassification)EntityClassification.CREATURE).func_220321_a(0.5f, 0.25f));
    public static final EntityType<TurtleLandEntity> ARRAU_TURTLE = AquaEntities.registerMob("arrau_turtle", 1, 2, 6, Biome.Category.JUNGLE, null, null, null, 7439738, 5202520, EntityType.Builder.func_220322_a(TurtleLandEntity::new, (EntityClassification)EntityClassification.CREATURE).func_220321_a(0.5f, 0.25f));
    public static final EntityType<TurtleLandEntity> STARSHELL_TURTLE = AquaEntities.registerMob("starshell_turtle", 1, 2, 5, null, null, null, null, 14476005, 0x464645, EntityType.Builder.func_220322_a(TurtleLandEntity::new, (EntityClassification)EntityClassification.CREATURE).func_220321_a(0.5f, 0.25f));

    @SubscribeEvent
    public static void registerEntities(RegistryEvent.Register<EntityType<?>> event) {
        for (EntityType<?> entity : ENTITIES) {
            event.getRegistry().register(entity);
        }
    }

    private static <T extends Entity> EntityType<T> registerMob(String name, int min, int max, int weight, @Nullable Biome.Category include, @Nullable Biome.Category exclude, BiomePropertiesPredicate.TemperatureType temperature, Biome.RainType rainType, int eggPrimary, int eggSecondary, EntityType.Builder<T> builder) {
        return AquaEntities.registerMob(name, min, max, weight, eggPrimary, eggSecondary, Collections.singletonList(String.valueOf(include == null ? "" : include)), Collections.singletonList(String.valueOf(exclude == null ? "" : exclude)), Collections.singletonList(String.valueOf(temperature == null ? "" : temperature)), Collections.singletonList(String.valueOf(rainType == null ? "" : rainType)), builder);
    }

    private static <T extends Entity> EntityType<T> registerMob(String name, int min, int max, int weight, int eggPrimary, int eggSecondary, List<? extends String> include, List<? extends String> exclude, List<? extends String> temperatures, List<? extends String> rainTypes, EntityType.Builder<T> builder) {
        EntityType<T> entityType = AquaEntities.register(name, builder);
        SpawnEggItem spawnEgg = new SpawnEggItem(entityType, eggPrimary, eggSecondary, new Item.Properties().func_200916_a(ItemGroup.field_78026_f));
        AquaItems.register((Item)spawnEgg, name + "_spawn_egg");
        new AquaConfig.Spawn(AquaConfig.BUILDER, name, min, max, weight, include, exclude, temperatures, rainTypes);
        MOBS.add(entityType);
        return entityType;
    }

    public static <T extends Entity> EntityType<T> register(String name, EntityType.Builder<T> builder) {
        ResourceLocation location = new ResourceLocation("aquaculture", name);
        EntityType entityType = builder.func_206830_a(location.toString());
        entityType.setRegistryName(location);
        ENTITIES.add(entityType);
        return entityType;
    }

    public static void setSpawnPlacement() {
        EntitySpawnPlacementRegistry.func_209343_a(BOX_TURTLE, (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, AnimalEntity::func_223316_b);
        EntitySpawnPlacementRegistry.func_209343_a(ARRAU_TURTLE, (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, AnimalEntity::func_223316_b);
        EntitySpawnPlacementRegistry.func_209343_a(STARSHELL_TURTLE, (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, AnimalEntity::func_223316_b);
        GlobalEntityTypeAttributes.put(BOX_TURTLE, (AttributeModifierMap)TurtleLandEntity.getAttributes().func_233813_a_());
        GlobalEntityTypeAttributes.put(ARRAU_TURTLE, (AttributeModifierMap)TurtleLandEntity.getAttributes().func_233813_a_());
        GlobalEntityTypeAttributes.put(STARSHELL_TURTLE, (AttributeModifierMap)TurtleLandEntity.getAttributes().func_233813_a_());
    }

    public static void addEntitySpawns(BiomeLoadingEvent event) {
        for (EntityType<?> entityType : MOBS) {
            String name = Objects.requireNonNull(entityType.getRegistryName()).func_110623_a();
            String subCategory = AquaConfig.Helper.getSubConfig("spawn options", name);
            BiomeHelper.addSpawn(entityType, (Integer)AquaConfig.Helper.get(subCategory, "min"), (Integer)AquaConfig.Helper.get(subCategory, "max"), (Integer)AquaConfig.Helper.get(subCategory, "weight"), (List)AquaConfig.Helper.get(subCategory, "include"), (List)AquaConfig.Helper.get(subCategory, "exclude"), (List)AquaConfig.Helper.get(subCategory, "temperatures"), (List)AquaConfig.Helper.get(subCategory, "rain_types"), event);
        }
    }
}

