/*
 * Decompiled with CFR 0.152.
 */
package com.teammetallurgy.aquaculture.init;

import com.google.common.collect.Lists;
import com.teammetallurgy.aquaculture.entity.AquaFishEntity;
import com.teammetallurgy.aquaculture.entity.FishMountEntity;
import com.teammetallurgy.aquaculture.entity.FishType;
import com.teammetallurgy.aquaculture.init.AquaEntities;
import com.teammetallurgy.aquaculture.init.AquaItems;
import com.teammetallurgy.aquaculture.item.FishMountItem;
import com.teammetallurgy.aquaculture.misc.StackHelper;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntitySpawnPlacementRegistry;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.GlobalEntityTypeAttributes;
import net.minecraft.entity.passive.CatEntity;
import net.minecraft.entity.passive.OcelotEntity;
import net.minecraft.entity.passive.fish.AbstractFishEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.gen.Heightmap;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.registries.ForgeRegistries;

@Mod.EventBusSubscriber(modid="aquaculture", bus=Mod.EventBusSubscriber.Bus.MOD)
public class FishRegistry {
    public static List<EntityType<AquaFishEntity>> fishEntities = Lists.newArrayList();
    public static List<EntityType<FishMountEntity>> fishMounts = Lists.newArrayList();

    public static Item registerFishMount(@Nonnull String name) {
        EntityType.Builder fishMountBuilder = EntityType.Builder.func_220322_a(FishMountEntity::new, (EntityClassification)EntityClassification.MISC).func_220321_a(0.5f, 0.5f).setCustomClientFactory(FishMountEntity::new);
        EntityType fishMount = AquaEntities.register(name, fishMountBuilder);
        FishMountItem fishMountItem = new FishMountItem(fishMount);
        AquaItems.register((Item)fishMountItem, name);
        fishMounts.add(fishMount);
        return fishMountItem;
    }

    public static Item register(@Nonnull Item fishItem, @Nonnull String name) {
        return FishRegistry.register(fishItem, name, FishType.MEDIUM);
    }

    public static Item register(@Nonnull Item fishItem, @Nonnull String name, FishType fishSize) {
        AquaItems.register(fishItem, name);
        EntityType fish = EntityType.Builder.func_220322_a(AquaFishEntity::new, (EntityClassification)EntityClassification.WATER_AMBIENT).func_220321_a(fishSize.getWidth(), fishSize.getHeight()).func_206830_a("minecraft:cod");
        FishRegistry.registerFishEntity(name, (EntityType<AquaFishEntity>)fish);
        AquaFishEntity.TYPES.put((EntityType<AquaFishEntity>)fish, fishSize);
        return fishItem;
    }

    public static EntityType<AquaFishEntity> registerFishEntity(String name, EntityType<AquaFishEntity> entityType) {
        ResourceLocation location = new ResourceLocation("aquaculture", name);
        entityType.setRegistryName(location);
        fishEntities.add(entityType);
        return entityType;
    }

    @SubscribeEvent
    public static void registerFishies(RegistryEvent.Register<EntityType<?>> event) {
        for (EntityType<AquaFishEntity> entityType : fishEntities) {
            event.getRegistry().register(entityType);
            EntitySpawnPlacementRegistry.func_209343_a(entityType, (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.IN_WATER, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, AquaFishEntity::canSpawnHere);
            GlobalEntityTypeAttributes.put(entityType, (AttributeModifierMap)AbstractFishEntity.func_234176_m_().func_233813_a_());
        }
    }

    public static void addCatBreeding() {
        try {
            Field catItems = ObfuscationReflectionHelper.findField(CatEntity.class, (String)"field_213426_bE");
            Field ocelotItems = ObfuscationReflectionHelper.findField(OcelotEntity.class, (String)"field_195402_bB");
            ArrayList<ItemStack> aquaFish = new ArrayList<ItemStack>();
            fishEntities.forEach(f -> aquaFish.add(new ItemStack((IItemProvider)ForgeRegistries.ITEMS.getValue(f.getRegistryName()))));
            aquaFish.removeIf(p -> p.func_77973_b().equals(AquaItems.JELLYFISH));
            FishRegistry.setFinalStatic(catItems, StackHelper.mergeIngredient(CatEntity.field_213426_bE, StackHelper.ingredientFromStackList(aquaFish)));
            FishRegistry.setFinalStatic(ocelotItems, StackHelper.mergeIngredient(OcelotEntity.field_195402_bB, StackHelper.ingredientFromStackList(aquaFish)));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    static void setFinalStatic(Field field, Object newValue) throws Exception {
        field.setAccessible(true);
        Field modifiersField = Field.class.getDeclaredField("modifiers");
        modifiersField.setAccessible(true);
        modifiersField.setInt(field, field.getModifiers() & 0xFFFFFFEF);
        field.set(null, newValue);
    }
}

