/*
 * Decompiled with CFR 0.152.
 */
package com.teammetallurgy.aquaculture.item.crafting;

import com.google.common.collect.Lists;
import com.teammetallurgy.aquaculture.api.AquacultureAPI;
import com.teammetallurgy.aquaculture.init.AquaItems;
import com.teammetallurgy.aquaculture.loot.FishWeightHandler;
import com.teammetallurgy.aquaculture.misc.AquaConfig;
import java.util.ArrayList;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.TieredItem;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.SpecialRecipe;
import net.minecraft.item.crafting.SpecialRecipeSerializer;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ObjectHolder;

@Mod.EventBusSubscriber(modid="aquaculture", bus=Mod.EventBusSubscriber.Bus.MOD)
@ObjectHolder(value="aquaculture")
public class FishFilletRecipe
extends SpecialRecipe {
    private static final SpecialRecipeSerializer<FishFilletRecipe> FISH_FILLET_SERIALIZER = new SpecialRecipeSerializer(FishFilletRecipe::new);

    private FishFilletRecipe(ResourceLocation location) {
        super(location);
    }

    @Nonnull
    public ResourceLocation func_199560_c() {
        return new ResourceLocation("aquaculture", "fish_fillet");
    }

    public boolean matches(@Nonnull CraftingInventory craftingInventory, @Nonnull World world) {
        ItemStack stack = ItemStack.field_190927_a;
        ArrayList list = Lists.newArrayList();
        for (int i = 0; i < craftingInventory.func_70302_i_(); ++i) {
            ItemStack slotStack = craftingInventory.func_70301_a(i);
            if (slotStack.func_190926_b()) continue;
            if (AquacultureAPI.FISH_DATA.hasFilletAmount(slotStack.func_77973_b())) {
                if (!stack.func_190926_b()) {
                    return false;
                }
                stack = slotStack;
                continue;
            }
            if (!(slotStack.func_77973_b().func_206844_a(AquacultureAPI.Tags.FILLET_KNIFE) && slotStack.func_77984_f() && slotStack.func_77973_b() instanceof TieredItem)) {
                return false;
            }
            list.add(slotStack);
        }
        return !stack.func_190926_b() && !list.isEmpty();
    }

    @Nonnull
    public ItemStack getCraftingResult(@Nonnull CraftingInventory craftingInventory) {
        ItemStack fish = ItemStack.field_190927_a;
        Item knife = null;
        for (int i = 0; i < craftingInventory.func_70302_i_(); ++i) {
            ItemStack stackSlot = craftingInventory.func_70301_a(i);
            if (stackSlot.func_190926_b()) continue;
            Item item = stackSlot.func_77973_b();
            if (AquacultureAPI.FISH_DATA.hasFilletAmount(item.getItem())) {
                if (!fish.func_190926_b()) {
                    return ItemStack.field_190927_a;
                }
                fish = stackSlot.func_77946_l();
                continue;
            }
            if (!item.func_206844_a(AquacultureAPI.Tags.FILLET_KNIFE)) {
                return ItemStack.field_190927_a;
            }
            knife = item;
        }
        if (!fish.func_190926_b() && knife != null) {
            int filletAmount = AquacultureAPI.FISH_DATA.getFilletAmount(fish.func_77973_b());
            if (((Boolean)AquaConfig.BASIC_OPTIONS.randomWeight.get()).booleanValue() && fish.func_77978_p() != null && fish.func_77978_p().func_74764_b("fishWeight")) {
                filletAmount = FishWeightHandler.getFilletAmountFromWeight(fish.func_77978_p().func_74769_h("fishWeight"));
            }
            if (knife instanceof TieredItem && ((TieredItem)knife).func_200891_e() == AquacultureAPI.MATS.NEPTUNIUM) {
                filletAmount = (int)((float)filletAmount + (float)filletAmount * 0.25f);
            }
            return new ItemStack((IItemProvider)AquaItems.FISH_FILLET, filletAmount);
        }
        return ItemStack.field_190927_a;
    }

    @Nonnull
    public NonNullList<ItemStack> getRemainingItems(CraftingInventory craftingInventory) {
        NonNullList list = NonNullList.func_191197_a((int)craftingInventory.func_70302_i_(), (Object)ItemStack.field_190927_a);
        for (int i = 0; i < list.size(); ++i) {
            ItemStack stack = craftingInventory.func_70301_a(i);
            if (!stack.func_77973_b().func_206844_a(AquacultureAPI.Tags.FILLET_KNIFE)) continue;
            ItemStack knife = stack.func_77946_l();
            if ((!(knife.func_77973_b() instanceof TieredItem) || ((TieredItem)knife.func_77973_b()).func_200891_e() != AquacultureAPI.MATS.NEPTUNIUM) && knife.func_96631_a(1, new Random(), null)) {
                knife.func_190918_g(1);
            }
            list.set(i, (Object)knife);
        }
        return list;
    }

    @Nonnull
    public IRecipeSerializer<?> func_199559_b() {
        return FISH_FILLET_SERIALIZER;
    }

    public boolean func_194133_a(int width, int height) {
        return width * height >= 2;
    }

    @SubscribeEvent
    public static void registerRecipeSerializer(RegistryEvent.Register<IRecipeSerializer<?>> event) {
        FISH_FILLET_SERIALIZER.setRegistryName(new ResourceLocation("aquaculture", "crafting_special_fish_fillet"));
        event.getRegistry().register(FISH_FILLET_SERIALIZER);
    }
}

