/*
 * Decompiled with CFR 0.152.
 */
package com.teammetallurgy.aquaculture.loot;

import com.google.common.collect.Lists;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.teammetallurgy.aquaculture.Aquaculture;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.advancements.criterion.MinMaxBounds;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.registries.ForgeRegistries;

public class BiomePropertiesPredicate {
    private static final BiomePropertiesPredicate ANY = new BiomePropertiesPredicate(MinMaxBounds.FloatBound.field_211359_e, MinMaxBounds.FloatBound.field_211359_e, MinMaxBounds.FloatBound.field_211359_e, Lists.newArrayList(), Lists.newArrayList(), Lists.newArrayList(), Lists.newArrayList());
    private static final List<Biome.Category> INVALID_CATEGORIES = Arrays.asList(Biome.Category.NETHER, Biome.Category.THEEND, Biome.Category.NONE);
    private final MinMaxBounds.FloatBound x;
    private final MinMaxBounds.FloatBound y;
    private final MinMaxBounds.FloatBound z;
    private final List<Biome.Category> include;
    private final List<Biome.Category> exclude;
    private final List<TemperatureType> temperatureTypes;
    private final List<Biome.RainType> rainTypes;

    public BiomePropertiesPredicate(MinMaxBounds.FloatBound x, MinMaxBounds.FloatBound y, MinMaxBounds.FloatBound z, List<Biome.Category> include, List<Biome.Category> exclude, List<TemperatureType> temperatureTypes, List<Biome.RainType> rainTypes) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.include = include;
        this.exclude = exclude;
        this.temperatureTypes = temperatureTypes;
        this.rainTypes = rainTypes;
    }

    public boolean test(ServerWorld world, float x, float y, float z) {
        if (!this.x.func_211354_d(x)) {
            return false;
        }
        if (!this.y.func_211354_d(y)) {
            return false;
        }
        if (!this.z.func_211354_d(z)) {
            return false;
        }
        BlockPos pos = new BlockPos((double)x, (double)y, (double)z);
        Biome biome = world.func_226691_t_(pos);
        Biome biomeFromRegistry = (Biome)ForgeRegistries.BIOMES.getValue(world.func_241828_r().func_243612_b(Registry.field_239720_u_).func_177774_c((Object)biome));
        return BiomePropertiesPredicate.getValidBiomes(this.include, this.exclude, this.temperatureTypes, this.rainTypes).contains(biomeFromRegistry);
    }

    public static List<Biome> getValidBiomes(List<Biome.Category> includeList, List<Biome.Category> excludeList, List<TemperatureType> temperatureTypes, List<Biome.RainType> rainTypes) {
        ArrayList registryBiomes = Lists.newArrayList((Iterable)ForgeRegistries.BIOMES.getValues());
        ArrayList biomes = Lists.newArrayList((Iterable)registryBiomes);
        if (includeList.isEmpty() && excludeList.isEmpty() && temperatureTypes.isEmpty() && rainTypes.isEmpty()) {
            biomes.clear();
        }
        if (includeList.isEmpty() && !excludeList.isEmpty()) {
            includeList.addAll(Arrays.asList(Biome.Category.values()));
            excludeList.addAll(INVALID_CATEGORIES);
        }
        if (includeList.isEmpty() && excludeList.isEmpty()) {
            excludeList.addAll(INVALID_CATEGORIES);
        }
        if (!includeList.isEmpty()) {
            if (includeList.stream().noneMatch(INVALID_CATEGORIES::contains)) {
                excludeList.addAll(INVALID_CATEGORIES);
            }
        }
        if (!includeList.isEmpty()) {
            biomes.removeIf(biome -> includeList.stream().noneMatch(BiomePropertiesPredicate.withSpecialCases(biome.getRegistryName(), biome.func_201856_r(), true)::contains));
        }
        if (!excludeList.isEmpty()) {
            biomes.removeIf(biome -> excludeList.stream().anyMatch(BiomePropertiesPredicate.withSpecialCases(biome.getRegistryName(), biome.func_201856_r(), false)::contains));
        }
        if (!temperatureTypes.isEmpty()) {
            biomes.removeIf(biome -> !temperatureTypes.contains((Object)BiomePropertiesPredicate.getTemperatureType(biome.func_242445_k(), biome.getRegistryName())));
        }
        if (!rainTypes.isEmpty()) {
            biomes.removeIf(biome -> !rainTypes.contains(biome.func_201851_b()));
        }
        return biomes;
    }

    public static TemperatureType getTemperatureType(float temp, ResourceLocation id) {
        String biomeName;
        String string = biomeName = id != null ? id.func_110623_a() : "";
        if (temp >= 1.0f || biomeName.contains("hot") || !biomeName.contains("lukewarm") && biomeName.contains("warm")) {
            return TemperatureType.HOT;
        }
        if (temp < 0.15f || biomeName.contains("cold") || biomeName.contains("frozen")) {
            return TemperatureType.COLD;
        }
        if (temp >= 0.15f && temp < 1.0f) {
            return TemperatureType.TEMPERATE;
        }
        return TemperatureType.HOT;
    }

    public static List<Biome.Category> withSpecialCases(ResourceLocation id, Biome.Category category, boolean isInclude) {
        String biomeName = id != null ? id.func_110623_a() : "";
        ArrayList categories = Lists.newArrayList();
        if (category != Biome.Category.NONE) {
            categories.add(category);
        }
        if (biomeName.contains("shore") || biomeName.contains("beach")) {
            categories.add(Biome.Category.BEACH);
        }
        return categories;
    }

    public JsonElement serialize() {
        if (this == ANY) {
            return JsonNull.INSTANCE;
        }
        JsonObject object = new JsonObject();
        if (!(this.x.func_211335_c() && this.y.func_211335_c() && this.z.func_211335_c())) {
            JsonObject posObj = new JsonObject();
            posObj.add("x", this.x.func_200321_c());
            posObj.add("y", this.y.func_200321_c());
            posObj.add("z", this.z.func_200321_c());
            object.add("position", (JsonElement)posObj);
        }
        if (this.include != null) {
            for (Biome.Category category : this.include) {
                object.add("include", (JsonElement)object.getAsJsonArray(category.func_222352_a()));
            }
        }
        if (this.exclude != null) {
            for (Biome.Category category : this.exclude) {
                object.add("exclude", (JsonElement)object.getAsJsonArray(category.func_222352_a()));
            }
        }
        if (this.temperatureTypes != null) {
            for (TemperatureType temperatureTypes : this.temperatureTypes) {
                object.add("temperature", (JsonElement)object.getAsJsonArray(temperatureTypes.getName()));
            }
        }
        if (this.rainTypes != null) {
            for (Biome.RainType rainType : this.rainTypes) {
                object.add("rain_type", (JsonElement)object.getAsJsonArray(rainType.func_222361_a()));
            }
        }
        return object;
    }

    public static BiomePropertiesPredicate deserialize(@Nullable JsonElement element) {
        if (element != null && !element.isJsonNull()) {
            JsonObject location = JSONUtils.func_151210_l((JsonElement)element, (String)"location");
            JsonObject position = JSONUtils.func_151218_a((JsonObject)location, (String)"position", (JsonObject)new JsonObject());
            MinMaxBounds.FloatBound x = MinMaxBounds.FloatBound.func_211356_a((JsonElement)position.get("x"));
            MinMaxBounds.FloatBound y = MinMaxBounds.FloatBound.func_211356_a((JsonElement)position.get("y"));
            MinMaxBounds.FloatBound z = MinMaxBounds.FloatBound.func_211356_a((JsonElement)position.get("z"));
            ArrayList include = Lists.newArrayList();
            if (location.has("include")) {
                JsonArray includeArray = JSONUtils.func_151214_t((JsonObject)location, (String)"include");
                for (int entry = 0; entry < includeArray.size(); ++entry) {
                    String name = includeArray.get(entry).getAsString().toLowerCase(Locale.ROOT);
                    Biome.Category category = Biome.Category.func_235103_a_((String)name);
                    if (category == null) {
                        Aquaculture.LOG.error("Failed to include Biome Category: " + name + ". Please check your loot tables");
                        continue;
                    }
                    include.add(category);
                }
            }
            ArrayList exclude = Lists.newArrayList();
            if (location.has("exclude")) {
                JsonArray excludeArray = JSONUtils.func_151214_t((JsonObject)location, (String)"exclude");
                for (int entry = 0; entry < excludeArray.size(); ++entry) {
                    String name = excludeArray.get(entry).getAsString().toLowerCase(Locale.ROOT);
                    Biome.Category category = Biome.Category.func_235103_a_((String)name);
                    if (category == null) {
                        Aquaculture.LOG.error("Failed to exclude Biome Category: " + name + ". Please check your loot tables");
                        continue;
                    }
                    exclude.add(category);
                }
            }
            ArrayList temperatureTypes = Lists.newArrayList();
            if (location.has("temperature")) {
                JsonArray temperatureArray = JSONUtils.func_151214_t((JsonObject)location, (String)"temperature");
                for (int entry = 0; entry < temperatureArray.size(); ++entry) {
                    String name = temperatureArray.get(entry).getAsString().toLowerCase(Locale.ROOT);
                    TemperatureType temperatureType = TemperatureType.getTemperatureType(name);
                    if (temperatureType == null) {
                        Aquaculture.LOG.error("Could not find Biome Temperature Type: " + name + ". Please check your loot tables");
                        continue;
                    }
                    temperatureTypes.add(temperatureType);
                }
            }
            ArrayList rainTypes = Lists.newArrayList();
            if (location.has("rain_type")) {
                JsonArray rainTypeArray = JSONUtils.func_151214_t((JsonObject)location, (String)"rain_type");
                for (int entry = 0; entry < rainTypeArray.size(); ++entry) {
                    String name = rainTypeArray.get(entry).getAsString().toLowerCase(Locale.ROOT);
                    Biome.RainType rainType = Biome.RainType.func_235122_a_((String)name);
                    if (rainType == null) {
                        Aquaculture.LOG.error("Could not find Biome Rain Type: " + name + ". Please check your loot tables");
                        continue;
                    }
                    rainTypes.add(rainType);
                }
            }
            return new BiomePropertiesPredicate(x, y, z, include, exclude, temperatureTypes, rainTypes);
        }
        return ANY;
    }

    public static enum TemperatureType implements IStringSerializable
    {
        COLD("cold"),
        TEMPERATE("temperate"),
        HOT("hot");

        private static final Map<String, TemperatureType> BY_NAME;
        private final String name;

        private TemperatureType(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public static TemperatureType getTemperatureType(String name) {
            return BY_NAME.get(name);
        }

        @Nonnull
        public String func_176610_l() {
            return this.name;
        }

        static {
            BY_NAME = Arrays.stream(TemperatureType.values()).collect(Collectors.toMap(TemperatureType::getName, precipitation -> precipitation));
        }
    }
}

