/*
 * Decompiled with CFR 0.152.
 */
package com.teammetallurgy.aquaculture.misc;

import com.teammetallurgy.aquaculture.loot.BiomePropertiesPredicate;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import net.minecraft.entity.EntityType;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.MobSpawnInfo;
import net.minecraftforge.event.world.BiomeLoadingEvent;

public class BiomeHelper {
    public static List<Biome.Category> toBiomeCategoryList(List<? extends String> stringList) {
        ArrayList<Biome.Category> newList = new ArrayList<Biome.Category>();
        for (String string : stringList) {
            Biome.Category category = Biome.Category.func_235103_a_((String)string.toLowerCase(Locale.ROOT));
            if (category == null) continue;
            newList.add(category);
        }
        return newList;
    }

    public static List<BiomePropertiesPredicate.TemperatureType> toBiomeTemperatureTypeList(List<? extends String> stringList) {
        ArrayList<BiomePropertiesPredicate.TemperatureType> newList = new ArrayList<BiomePropertiesPredicate.TemperatureType>();
        for (String string : stringList) {
            BiomePropertiesPredicate.TemperatureType temperatureType = BiomePropertiesPredicate.TemperatureType.getTemperatureType(string.toLowerCase(Locale.ROOT));
            if (temperatureType == null) continue;
            newList.add(temperatureType);
        }
        return newList;
    }

    public static List<Biome.RainType> toBiomeRainTypeList(List<? extends String> stringList) {
        ArrayList<Biome.RainType> newList = new ArrayList<Biome.RainType>();
        for (String string : stringList) {
            Biome.RainType rainType = Biome.RainType.func_235122_a_((String)string.toLowerCase(Locale.ROOT));
            if (rainType == null) continue;
            newList.add(rainType);
        }
        return newList;
    }

    public static void addSpawn(EntityType<?> entityType, int min, int max, int weight, List<? extends String> include, List<? extends String> exclude, List<? extends String> temperatures, List<? extends String> rain, BiomeLoadingEvent event) {
        if (weight > 0) {
            List<Biome.Category> includeList = BiomeHelper.toBiomeCategoryList(include);
            List<Biome.Category> excludeList = BiomeHelper.toBiomeCategoryList(exclude);
            List<BiomePropertiesPredicate.TemperatureType> temperatureTypes = BiomeHelper.toBiomeTemperatureTypeList(temperatures);
            List<Biome.RainType> rainTypes = BiomeHelper.toBiomeRainTypeList(rain);
            List<Biome> spawnableBiomes = BiomePropertiesPredicate.getValidBiomes(includeList, excludeList, temperatureTypes, rainTypes);
            for (Biome biome : spawnableBiomes) {
                if (!event.getName().equals((Object)biome.getRegistryName())) continue;
                event.getSpawns().getSpawner(entityType.func_220339_d()).add(new MobSpawnInfo.Spawners(entityType, weight, min, max));
            }
        }
    }
}

