/*
 * Decompiled with CFR 0.152.
 */
package shadows.attained;

import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.config.ModConfig;
import org.apache.commons.lang3.tuple.Pair;
import shadows.attained.AttainedDrops;

public class AttainedConfig {
    static final ForgeConfigSpec spec;
    public static final AttainedConfig INSTANCE;
    public final ForgeConfigSpec.IntValue dropChance;
    public final ForgeConfigSpec.BooleanValue allowBonemeal;
    public final ForgeConfigSpec.IntValue spreaderRadius;
    public final ForgeConfigSpec.BooleanValue revertToDirt;
    public final ForgeConfigSpec.BooleanValue rightClickFarm;

    AttainedConfig(ForgeConfigSpec.Builder build) {
        build.comment("Server Configuration");
        build.push("server");
        this.dropChance = build.comment("The 1/n chance for life essence to drop from a monster.").defineInRange("Drop Chance", 18, 1, Integer.MAX_VALUE);
        this.allowBonemeal = build.comment("If bonemeal works on vitalized plants.").define("Allow Bonemeal", false);
        this.spreaderRadius = build.comment("The radius of the Vitality Spreader.").defineInRange("Vitality Spreader Radius", 2, 0, 5);
        this.revertToDirt = build.comment("If vitalized soil will revert to dirt (instead of vitalized soil) after growing 1-4 bulbs.").define("Dirt Reversion", true);
        this.rightClickFarm = build.comment("If bulbs can be harvested on right click.").define("Simple Harvest", true);
        build.pop();
    }

    @SubscribeEvent
    public static void onLoad(ModConfig.Loading e) {
        if (e.getConfig().getModId().equals("attained_drops")) {
            AttainedDrops.LOGGER.info("Loaded config file!");
        }
    }

    static {
        Pair specPair = new ForgeConfigSpec.Builder().configure(AttainedConfig::new);
        spec = (ForgeConfigSpec)specPair.getRight();
        INSTANCE = (AttainedConfig)specPair.getLeft();
    }
}

