/*
 * Decompiled with CFR 0.152.
 */
package shadows.attained.api;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.loading.FMLPaths;
import net.minecraftforge.registries.ForgeRegistries;
import shadows.attained.AttainedDrops;
import shadows.attained.api.IAttainedType;
import shadows.attained.api.ITypedBlock;
import shadows.attained.blocks.BlockBulb;
import shadows.attained.blocks.BlockSoil;
import shadows.attained.blocks.CustomBulbType;
import shadows.attained.blocks.DefaultTypes;

public class PlantingRegistry {
    public static final Map<IAttainedType, BlockSoil> SOILS = new HashMap<IAttainedType, BlockSoil>();
    public static final Map<IAttainedType, BlockBulb> BULBS = new HashMap<IAttainedType, BlockBulb>();

    public static IAttainedType byStack(ItemStack stack) {
        for (IAttainedType s : SOILS.keySet()) {
            if (!stack.func_77969_a(s.getDrop())) continue;
            return s;
        }
        return null;
    }

    private static void loadCustomTypes() {
        Properties props;
        File f = new File(FMLPaths.CONFIGDIR.get().toFile(), "attained_drops_custom.properties");
        if (!f.exists()) {
            try {
                f.createNewFile();
                props = new Properties();
                String comment = "In this file, each new line entry is a new bulb type.  A line must contain the following information: name=item|color\r\nName: This is the internal name of this bulb type.  It may only use lowercase letters and numbers, and must be unique.\r\nItem: This is the relevant item, used to vitalize soil and the item dropped by the bulb.  Must be an item registry name, such as minecraft:diamond\r\nColor: This is a hex integer that represents the color of this soil/bulb combo.  It must be six digits long, and requires the 0x prefix.  Ex: 0xFFFFFF\r\nAn example definition for redstone is redstone=minecraft:redstone|0xAA0F01";
                props.store(new FileOutputStream(f), comment);
            }
            catch (IOException e) {
                e.printStackTrace();
                return;
            }
        }
        props = new Properties();
        try (FileInputStream stream = new FileInputStream(f);){
            props.load(stream);
        }
        catch (IOException e) {
            AttainedDrops.LOGGER.error("Failed to load custom block properties file!");
            e.printStackTrace();
        }
        for (Object o : props.keySet()) {
            String name = (String)o;
            String unparsed = props.getProperty(name);
            try {
                String[] split = unparsed.split("\\|");
                int color = Integer.parseInt(split[1].contains("0x") ? split[1].substring(2) : split[1], split[1].contains("0x") ? 16 : 10);
                CustomBulbType type = new CustomBulbType(name, color, () -> new ItemStack((IItemProvider)ForgeRegistries.ITEMS.getValue(new ResourceLocation(split[0]))));
                SOILS.put(type, new BlockSoil(type));
                BULBS.put(type, new BlockBulb(type));
            }
            catch (Exception e) {
                AttainedDrops.LOGGER.error("Error loading custom block definition for: " + name);
                e.printStackTrace();
            }
        }
    }

    public static void load() {
        ITypedBlock b;
        for (DefaultTypes t : DefaultTypes.values()) {
            if (t == DefaultTypes.NONE) continue;
            b = new BlockBulb(t);
            BULBS.put(t, (BlockBulb)b);
        }
        for (DefaultTypes t : DefaultTypes.VALUES) {
            b = new BlockSoil(t);
            SOILS.put(t, (BlockSoil)b);
        }
        PlantingRegistry.loadCustomTypes();
    }
}

