/*
 * Decompiled with CFR 0.152.
 */
package com.minecraftabnormals.autumnity.core;

import com.minecraftabnormals.abnormals_core.core.util.DataUtil;
import com.minecraftabnormals.abnormals_core.core.util.registry.RegistryHelper;
import com.minecraftabnormals.autumnity.core.AutumnityConfig;
import com.minecraftabnormals.autumnity.core.other.AutumnityClient;
import com.minecraftabnormals.autumnity.core.other.AutumnityCompat;
import com.minecraftabnormals.autumnity.core.registry.AutumnityBiomes;
import com.minecraftabnormals.autumnity.core.registry.AutumnityEffects;
import com.minecraftabnormals.autumnity.core.registry.AutumnityEntities;
import com.minecraftabnormals.autumnity.core.registry.AutumnityFeatures;
import com.minecraftabnormals.autumnity.core.registry.AutumnityPaintings;
import com.minecraftabnormals.autumnity.core.registry.AutumnityParticles;
import com.minecraftabnormals.autumnity.core.registry.AutumnityPotions;
import com.minecraftabnormals.autumnity.core.registry.AutumnityStructures;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;

@Mod(value="autumnity")
public class Autumnity {
    public static final String MOD_ID = "autumnity";
    public static final RegistryHelper REGISTRY_HELPER = new RegistryHelper("autumnity");

    public Autumnity() {
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        REGISTRY_HELPER.register(modEventBus);
        AutumnityPaintings.PAINTINGS.register(modEventBus);
        AutumnityEffects.EFFECTS.register(modEventBus);
        AutumnityPotions.POTIONS.register(modEventBus);
        AutumnityFeatures.FEATURES.register(modEventBus);
        AutumnityStructures.STRUCTURES.register(modEventBus);
        AutumnityParticles.PARTICLES.register(modEventBus);
        MinecraftForge.EVENT_BUS.register((Object)this);
        modEventBus.addListener(EventPriority.LOWEST, this::commonSetup);
        DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> () -> modEventBus.addListener(this::clientSetup));
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, AutumnityConfig.COMMON_SPEC);
        DataUtil.registerConfigCondition((String)MOD_ID, (Object[])new Object[]{AutumnityConfig.COMMON});
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> {
            AutumnityCompat.registerCompat();
            AutumnityPotions.registerBrewingRecipes();
            AutumnityBiomes.addBiomeTypes();
            AutumnityBiomes.addBiomesToGeneration();
            AutumnityFeatures.Configured.registerConfiguredFeatures();
            AutumnityStructures.Configured.registerConfiguredStructureFeatures();
            AutumnityStructures.registerNoiseSettings();
            AutumnityEntities.registerSpawns();
        });
    }

    private void clientSetup(FMLClientSetupEvent event) {
        AutumnityEntities.registerRenderers();
        event.enqueueWork(() -> {
            AutumnityClient.registerRenderLayers();
            AutumnityClient.registerBlockColors();
        });
    }
}

