/*
 * Decompiled with CFR 0.152.
 */
package com.markus1002.autumnity.client.renderer.entity;

import com.markus1002.autumnity.common.entity.item.boat.ModBoatEntity;
import com.markus1002.autumnity.core.util.Reference;
import com.mojang.blaze3d.platform.GlStateManager;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.entity.model.BoatModel;
import net.minecraft.entity.Entity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ModBoatRenderer<T extends ModBoatEntity>
extends EntityRenderer<T> {
    private static final ResourceLocation[] BOAT_TEXTURES = new ResourceLocation[]{Reference.location("textures/entity/boat/maple.png")};
    protected final BoatModel field_76998_a = new BoatModel();

    public ModBoatRenderer(EntityRendererManager renderManagerIn) {
        super(renderManagerIn);
        this.field_76989_e = 0.8f;
    }

    public void doRender(T entity, double x, double y, double z, float entityYaw, float partialTicks) {
        GlStateManager.pushMatrix();
        this.setupTranslation(x, y, z);
        this.setupRotation(entity, entityYaw, partialTicks);
        this.func_180548_c((Entity)entity);
        if (this.field_188301_f) {
            GlStateManager.enableColorMaterial();
            GlStateManager.setupSolidRenderingTextureCombine((int)this.func_188298_c((Entity)entity));
        }
        this.field_76998_a.func_78088_a(entity, partialTicks, 0.0f, -0.1f, 0.0f, 0.0f, 0.0625f);
        if (this.field_188301_f) {
            GlStateManager.tearDownSolidRenderingTextureCombine();
            GlStateManager.disableColorMaterial();
        }
        GlStateManager.popMatrix();
        super.func_76986_a(entity, x, y, z, entityYaw, partialTicks);
    }

    public void setupRotation(T entityIn, float entityYaw, float partialTicks) {
        float f2;
        GlStateManager.rotatef((float)(180.0f - entityYaw), (float)0.0f, (float)1.0f, (float)0.0f);
        float f = (float)entityIn.func_70268_h() - partialTicks;
        float f1 = entityIn.func_70271_g() - partialTicks;
        if (f1 < 0.0f) {
            f1 = 0.0f;
        }
        if (f > 0.0f) {
            GlStateManager.rotatef((float)(MathHelper.func_76126_a((float)f) * f * f1 / 10.0f * (float)entityIn.func_70267_i()), (float)1.0f, (float)0.0f, (float)0.0f);
        }
        if (!MathHelper.func_180185_a((float)(f2 = entityIn.func_203056_b(partialTicks)), (float)0.0f)) {
            GlStateManager.rotatef((float)entityIn.func_203056_b(partialTicks), (float)1.0f, (float)0.0f, (float)1.0f);
        }
        GlStateManager.scalef((float)-1.0f, (float)-1.0f, (float)1.0f);
    }

    public void setupTranslation(double x, double y, double z) {
        GlStateManager.translatef((float)((float)x), (float)((float)y + 0.375f), (float)((float)z));
    }

    protected ResourceLocation getEntityTexture(T entity) {
        return BOAT_TEXTURES[((ModBoatEntity)((Object)entity)).getModBoatType().ordinal()];
    }

    public boolean func_188295_H_() {
        return true;
    }

    public void renderMultipass(T entityIn, double x, double y, double z, float entityYaw, float partialTicks) {
        GlStateManager.pushMatrix();
        this.setupTranslation(x, y, z);
        this.setupRotation(entityIn, entityYaw, partialTicks);
        this.func_180548_c((Entity)entityIn);
        this.field_76998_a.func_187054_b(entityIn, partialTicks, 0.0f, -0.1f, 0.0f, 0.0f, 0.0625f);
        GlStateManager.popMatrix();
    }
}

