/*
 * Decompiled with CFR 0.152.
 */
package com.markus1002.autumnity.client.renderer.entity.model;

import com.markus1002.autumnity.common.entity.passive.SnailEntity;
import com.mojang.blaze3d.platform.GlStateManager;
import net.minecraft.client.renderer.entity.model.EntityModel;
import net.minecraft.client.renderer.entity.model.RendererModel;
import net.minecraft.client.renderer.model.Model;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class SnailModel<T extends SnailEntity>
extends EntityModel<T> {
    private final RendererModel body;
    private final RendererModel hideBody;
    private final RendererModel shell;
    private final RendererModel eye1;
    private final RendererModel eye2;
    private final RendererModel tentacle1;
    private final RendererModel tentacle2;

    public SnailModel() {
        this.field_78090_t = 64;
        this.field_78089_u = 64;
        this.body = new RendererModel((Model)this, 0, 0);
        this.body.func_78793_a(0.0f, 24.0f, -9.0f);
        this.body.func_78790_a(-4.0f, 0.0f, 0.0f, 8, 18, 6, 0.0f);
        this.hideBody = new RendererModel((Model)this, 0, 0);
        this.hideBody.func_78793_a(0.0f, 24.0f, -6.0f);
        this.hideBody.func_78790_a(-4.0f, 0.0f, 0.0f, 8, 12, 6, 0.0f);
        this.eye1 = new RendererModel((Model)this, 28, 0);
        this.eye1.func_78793_a(2.5f, 18.0f, -7.0f);
        this.eye1.func_78790_a(-1.0f, -6.0f, -1.0f, 2, 7, 2, 0.0f);
        this.eye2 = new RendererModel((Model)this, 28, 0);
        this.eye2.field_78809_i = true;
        this.eye2.func_78793_a(-2.5f, 18.0f, -7.0f);
        this.eye2.func_78790_a(-1.0f, -6.0f, -1.0f, 2, 7, 2, 0.0f);
        this.tentacle1 = new RendererModel((Model)this, 28, 9);
        this.tentacle1.func_78793_a(3.0f, 22.0f, -9.0f);
        this.tentacle1.func_78790_a(-1.0f, -1.0f, -2.0f, 2, 2, 2, 0.0f);
        this.tentacle2 = new RendererModel((Model)this, 28, 9);
        this.tentacle2.func_78793_a(-3.0f, 22.0f, -9.0f);
        this.tentacle2.func_78790_a(-1.0f, -1.0f, -2.0f, 2, 2, 2, 0.0f);
        this.shell = new RendererModel((Model)this, 0, 24);
        this.shell.func_78793_a(0.0f, 7.0f, -1.0f);
        this.shell.func_78790_a(-4.5f, 0.0f, 0.0f, 9, 14, 14, 0.0f);
    }

    public void render(T entityIn, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch, float scale) {
        this.setRotationAngles(entityIn, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch, scale);
        if (this.field_217114_e) {
            GlStateManager.pushMatrix();
            GlStateManager.scalef((float)0.5f, (float)0.5f, (float)0.5f);
            GlStateManager.translatef((float)0.0f, (float)(24.0f * scale), (float)0.0f);
            if (((SnailEntity)((Object)entityIn)).getHideTicks() == 0.0f) {
                this.body.func_78785_a(scale);
            } else {
                this.hideBody.func_78785_a(scale);
            }
            if (((SnailEntity)((Object)entityIn)).getHideTicks() < 3.0f) {
                this.eye1.func_78785_a(scale);
                this.eye2.func_78785_a(scale);
            }
            this.tentacle1.func_78785_a(scale);
            this.tentacle2.func_78785_a(scale);
            this.shell.func_78785_a(scale);
            GlStateManager.popMatrix();
        } else {
            if (((SnailEntity)((Object)entityIn)).getHideTicks() == 0.0f) {
                this.body.func_78785_a(scale);
            } else {
                this.hideBody.func_78785_a(scale);
            }
            if (((SnailEntity)((Object)entityIn)).getHideTicks() < 3.0f) {
                this.eye1.func_78785_a(scale);
                this.eye2.func_78785_a(scale);
            }
            this.tentacle1.func_78785_a(scale);
            this.tentacle2.func_78785_a(scale);
            this.shell.func_78785_a(scale);
        }
    }

    public void setLivingAnimations(T entityIn, float limbSwing, float limbSwingAmount, float partialTick) {
        float f = ((SnailEntity)((Object)entityIn)).getHidingAnimationScale(partialTick);
        float f1 = 3.0f * f;
        float f2 = MathHelper.func_76131_a((float)(10.0f * f), (float)0.0f, (float)5.0f);
        this.hideBody.func_78793_a(0.0f, 24.0f, -9.0f + f1);
        this.eye1.func_78793_a(2.5f, 18.0f + f2, -7.0f + f1);
        this.eye2.func_78793_a(-2.5f, 18.0f + f2, -7.0f + f1);
        this.tentacle1.func_78793_a(3.0f, 22.0f, -9.0f + f1);
        this.tentacle2.func_78793_a(-3.0f, 22.0f, -9.0f + f1);
        this.shell.func_78793_a(0.0f, 7.0f, -1.0f - f1);
    }

    public void setRotationAngles(T entityIn, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch, float scaleFactor) {
        boolean flag = ((SnailEntity)((Object)entityIn)).getHideTicks() == 0.0f;
        this.body.field_78795_f = 1.5707964f;
        this.hideBody.field_78795_f = 1.5707964f;
        if (flag) {
            this.eye1.field_78795_f = headPitch * ((float)Math.PI / 180) * 0.5f + 0.25f;
            this.eye1.field_78796_g = netHeadYaw * ((float)Math.PI / 180) * 0.5f;
            this.eye1.field_78808_h = 0.25f;
        } else {
            this.eye1.field_78795_f = 0.0f;
            this.eye1.field_78796_g = 0.0f;
            this.eye1.field_78808_h = 0.0f;
        }
        this.eye2.field_78795_f = this.eye1.field_78795_f;
        this.eye2.field_78796_g = this.eye1.field_78796_g;
        this.eye2.field_78808_h = -this.eye1.field_78808_h;
        this.shell.field_78795_f = -0.22f;
        if (((SnailEntity)((Object)entityIn)).isEating()) {
            this.tentacle1.field_78796_g = 0.25f * MathHelper.func_76126_a((float)(0.6f * ageInTicks));
            this.tentacle2.field_78796_g = -this.tentacle1.field_78796_g;
        } else {
            this.tentacle1.field_78796_g = 0.0f;
            this.tentacle2.field_78796_g = 0.0f;
        }
    }
}

