/*
 * Decompiled with CFR 0.152.
 */
package com.markus1002.autumnity.common.block;

import com.markus1002.autumnity.common.entity.passive.SnailEntity;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.BreakableBlock;
import net.minecraft.entity.Entity;
import net.minecraft.fluid.IFluidState;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.IProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;

public class SnailSlimeFullBlock
extends BreakableBlock {
    public static final BooleanProperty SLIPPERY = BooleanProperty.func_177716_a((String)"slippery");
    protected static final VoxelShape SHAPE = Block.func_208617_a((double)0.0, (double)1.0, (double)0.0, (double)16.0, (double)14.0, (double)16.0);
    protected static final VoxelShape SLIPPERY_SHAPE = Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);

    public SnailSlimeFullBlock(Block.Properties properties) {
        super(properties);
        this.func_180632_j((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((IProperty)SLIPPERY, (Comparable)Boolean.valueOf(false)));
    }

    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.TRANSLUCENT;
    }

    public VoxelShape func_220071_b(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return (Boolean)state.func_177229_b((IProperty)SLIPPERY) == false ? SHAPE : super.func_220071_b(state, worldIn, pos, context);
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        return (BlockState)this.func_176223_P().func_206870_a((IProperty)SLIPPERY, (Comparable)Boolean.valueOf(this.shouldBeSlippery(context.func_195995_a(), (IBlockReader)context.func_195991_k())));
    }

    public BlockState func_196271_a(BlockState stateIn, Direction facing, BlockState facingState, IWorld worldIn, BlockPos currentPos, BlockPos facingPos) {
        return (BlockState)stateIn.func_206870_a((IProperty)SLIPPERY, (Comparable)Boolean.valueOf(this.shouldBeSlippery(currentPos, (IBlockReader)worldIn)));
    }

    public final boolean shouldBeSlippery(BlockPos blockPos, IBlockReader iBlockReader) {
        for (Direction direction : Direction.values()) {
            Block block;
            BlockPos blockpos1 = blockPos.func_177972_a(direction);
            if (!this.doesBlockMakeSlippery(blockpos1, block = iBlockReader.func_180495_p(blockpos1).func_177230_c(), iBlockReader)) continue;
            return true;
        }
        return false;
    }

    public final boolean doesBlockMakeSlippery(BlockPos blockPos, Block block, IBlockReader iBlockReader) {
        IFluidState ifluidstate = iBlockReader.func_204610_c(blockPos);
        return block == Blocks.field_196577_ad || ifluidstate.func_206884_a(FluidTags.field_206959_a);
    }

    public void func_180658_a(World worldIn, BlockPos pos, Entity entityIn, float fallDistance) {
        if (entityIn.func_70093_af()) {
            super.func_180658_a(worldIn, pos, entityIn, fallDistance);
        } else {
            entityIn.func_180430_e(fallDistance, 0.0f);
        }
    }

    public void func_196262_a(BlockState state, World worldIn, BlockPos pos, Entity entityIn) {
        if (!((Boolean)state.func_177229_b((IProperty)SLIPPERY)).booleanValue() && !(entityIn instanceof SnailEntity)) {
            if (entityIn.func_174813_aQ().field_72337_e <= (double)pos.func_177956_o() + 0.0625) {
                if (!entityIn.func_70093_af()) {
                    entityIn.func_213295_a(state, new Vec3d(1.0, 0.0, 1.0));
                }
            } else {
                entityIn.func_213317_d(entityIn.func_213322_ci().func_216372_d(0.4, 1.0, 0.4));
            }
        }
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new IProperty[]{SLIPPERY});
    }

    public float getSlipperiness(BlockState state, IWorldReader world, BlockPos pos, @Nullable Entity entity) {
        return (Boolean)state.func_177229_b((IProperty)SLIPPERY) != false ? 0.98f : 0.6f;
    }

    public boolean isStickyBlock(BlockState state) {
        return (Boolean)state.func_177229_b((IProperty)SLIPPERY) == false;
    }
}

