/*
 * Decompiled with CFR 0.152.
 */
package com.markus1002.autumnity.common.entity.item.boat;

import com.markus1002.autumnity.core.registry.ModBlocks;
import com.markus1002.autumnity.core.registry.ModEntities;
import com.markus1002.autumnity.core.registry.ModItems;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.item.BoatEntity;
import net.minecraft.item.Item;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.GameRules;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.FMLPlayMessages;
import net.minecraftforge.fml.network.NetworkHooks;

public class ModBoatEntity
extends BoatEntity {
    private static final DataParameter<Integer> BOAT_TYPE = EntityDataManager.func_187226_a(ModBoatEntity.class, (IDataSerializer)DataSerializers.field_187192_b);

    public ModBoatEntity(EntityType<? extends BoatEntity> entityType, World worldIn) {
        super(entityType, worldIn);
    }

    public ModBoatEntity(World worldIn, double x, double y, double z) {
        this(ModEntities.BOAT, worldIn);
        this.func_70107_b(x, y, z);
        this.func_213317_d(Vec3d.field_186680_a);
        this.field_70169_q = x;
        this.field_70167_r = y;
        this.field_70166_s = z;
    }

    public ModBoatEntity(FMLPlayMessages.SpawnEntity packet, World worldIn) {
        super(ModEntities.BOAT, worldIn);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(BOAT_TYPE, (Object)BoatType.MAPLE.ordinal());
    }

    public void setModBoatType(BoatType boatType) {
        this.field_70180_af.func_187227_b(BOAT_TYPE, (Object)boatType.ordinal());
    }

    public BoatType getModBoatType() {
        return BoatType.byId((Integer)this.field_70180_af.func_187225_a(BOAT_TYPE));
    }

    protected void func_213281_b(CompoundNBT compound) {
        compound.func_74778_a("Type", this.getModBoatType().getName());
    }

    protected void func_70037_a(CompoundNBT compound) {
        if (compound.func_150297_b("Type", 8)) {
            this.setModBoatType(BoatType.getTypeFromString(compound.func_74779_i("Type")));
        }
    }

    protected void func_184231_a(double y, boolean onGroundIn, BlockState state, BlockPos pos) {
        this.field_184473_aH = this.func_213322_ci().field_72448_b;
        if (!this.func_184218_aH()) {
            if (onGroundIn) {
                if (this.field_70143_R > 3.0f) {
                    if (this.field_184469_aF != BoatEntity.Status.ON_LAND) {
                        this.field_70143_R = 0.0f;
                        return;
                    }
                    this.func_180430_e(this.field_70143_R, 1.0f);
                    if (!this.field_70170_p.field_72995_K && !this.field_70128_L) {
                        this.func_70106_y();
                        if (this.field_70170_p.func_82736_K().func_223586_b(GameRules.field_223604_g)) {
                            this.dropBreakItems();
                        }
                    }
                }
                this.field_70143_R = 0.0f;
            } else if (!this.field_70170_p.func_204610_c(new BlockPos((Entity)this).func_177977_b()).func_206884_a(FluidTags.field_206959_a) && y < 0.0) {
                this.field_70143_R = (float)((double)this.field_70143_R - y);
            }
        }
    }

    protected void dropBreakItems() {
        for (int i = 0; i < 3; ++i) {
            this.func_199703_a((IItemProvider)this.getPlanks());
        }
        for (int j = 0; j < 2; ++j) {
            this.func_199703_a((IItemProvider)Items.field_151055_y);
        }
    }

    public Item func_184455_j() {
        switch (this.getModBoatType()) {
            default: 
        }
        return ModItems.MAPLE_BOAT;
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    protected Block getPlanks() {
        switch (this.getModBoatType()) {
            default: 
        }
        return ModBlocks.MAPLE_PLANKS;
    }

    public static enum BoatType {
        MAPLE("maple");

        private final String name;

        private BoatType(String nameIn) {
            this.name = nameIn;
        }

        public String getName() {
            return this.name;
        }

        public String toString() {
            return this.name;
        }

        public static BoatType byId(int id) {
            BoatType[] aboatentity$type = BoatType.values();
            if (id < 0 || id >= aboatentity$type.length) {
                id = 0;
            }
            return aboatentity$type[id];
        }

        public static BoatType getTypeFromString(String nameIn) {
            BoatType[] aboatentity$type = BoatType.values();
            for (int i = 0; i < aboatentity$type.length; ++i) {
                if (!aboatentity$type[i].getName().equals(nameIn)) continue;
                return aboatentity$type[i];
            }
            return aboatentity$type[0];
        }
    }
}

