/*
 * Decompiled with CFR 0.152.
 */
package com.markus1002.autumnity.core;

import com.markus1002.autumnity.core.Config;
import com.markus1002.autumnity.core.registry.ModEntities;
import com.markus1002.autumnity.core.registry.ModFeatures;
import com.markus1002.autumnity.core.registry.ModParticles;
import com.markus1002.autumnity.core.registry.ModPotions;
import com.markus1002.autumnity.core.util.EventHandler;
import com.markus1002.autumnity.core.util.VanillaCompatibility;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.client.event.ParticleFactoryRegisterEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="autumnity")
public class Autumnity {
    private static final Logger LOGGER = LogManager.getLogger((String)"autumnity");

    public Autumnity() {
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::setup);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::clientSetup);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::particleSetup);
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, Config.COMMON_SPEC);
        MinecraftForge.EVENT_BUS.register((Object)new EventHandler());
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    private void setup(FMLCommonSetupEvent event) {
        VanillaCompatibility.setupVanillaCompatibility();
        ModPotions.setupBrewingRecipes();
        for (Biome biome : ForgeRegistries.BIOMES.getValues()) {
            ModFeatures.setupBiomeFeatures(biome);
            ModEntities.setupEntitySpawns(biome);
        }
    }

    private void clientSetup(FMLClientSetupEvent event) {
        ModEntities.setupEntitiesClient();
        VanillaCompatibility.setupVanillaCompatibilityClient();
    }

    private void particleSetup(ParticleFactoryRegisterEvent event) {
        ModParticles.registerFactories();
    }
}

