/*
 * Decompiled with CFR 0.152.
 */
package com.markus1002.autumnity.core;

import com.google.common.collect.Lists;
import java.util.List;
import net.minecraftforge.common.ForgeConfigSpec;
import org.apache.commons.lang3.tuple.Pair;

public class Config {
    static final ForgeConfigSpec COMMON_SPEC;
    public static final Common COMMON;

    static {
        Pair specPair = new ForgeConfigSpec.Builder().configure(Common::new);
        COMMON_SPEC = (ForgeConfigSpec)specPair.getRight();
        COMMON = (Common)specPair.getLeft();
    }

    public static class Common {
        public final ForgeConfigSpec.ConfigValue<List<String>> mapleTreeBiomes;
        public final ForgeConfigSpec.ConfigValue<List<String>> snailSpawnBiomes;
        public final ForgeConfigSpec.ConfigValue<List<String>> snailBreedingItems;
        public final ForgeConfigSpec.ConfigValue<List<String>> snailFood;
        public final ForgeConfigSpec.ConfigValue<List<String>> snailBlockFood;

        Common(ForgeConfigSpec.Builder builder) {
            builder.comment("Husbandry Plus Settings").push("common");
            this.mapleTreeBiomes = builder.comment("A list of biomes where maple trees can naturally generate. The list doesn't include maple forests.").define("Maple Tree Biomes", (Object)Lists.newArrayList((Object[])new String[]{"minecraft:forest", "minecraft:wooded_hills", "minecraft:flower_forest"}));
            this.snailSpawnBiomes = builder.comment("A list of biomes where snails can spawn. The list doesn't include maple forests.").define("Snail Spawn Biomes", (Object)Lists.newArrayList());
            this.snailBreedingItems = builder.comment("A list of items that can be used to breed snails.").define("Snail Breeding Items", (Object)Lists.newArrayList((Object[])new String[]{"minecraft:mushroom_stew", "minecraft:suspicious_stew"}));
            this.snailFood = builder.comment("A list of items that can be fed to snails to produce snail slime.").define("Snail Food", (Object)Lists.newArrayList((Object[])new String[]{"minecraft:brown_mushroom", "minecraft:red_mushroom", "minecraft:mushroom_stem", "minecraft:brown_mushroom_block", "minecraft:red_mushroom_block", "quark:glowshroom", "quark:glowshroom_stem", "quark:glowshroom_block"}));
            this.snailBlockFood = builder.comment("A list of blocks snails can eat to produce snail slime.").define("Snail Block Food", (Object)Lists.newArrayList((Object[])new String[]{"minecraft:brown_mushroom", "minecraft:red_mushroom", "quark:glowshroom"}));
            builder.pop();
        }
    }
}

