/*
 * Decompiled with CFR 0.152.
 */
package com.markus1002.autumnity.core.registry;

import com.markus1002.autumnity.common.world.biome.MapleForestBiome;
import com.markus1002.autumnity.core.util.Reference;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.common.BiomeManager;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class ModBiomes {
    public static final Biome MAPLE_FOREST = new MapleForestBiome();

    @SubscribeEvent
    public static void registerBiomes(RegistryEvent.Register<Biome> event) {
        ModBiomes.addBiome(MAPLE_FOREST, "maple_forest", 8, true, BiomeManager.BiomeType.COOL, BiomeDictionary.Type.FOREST, BiomeDictionary.Type.OVERWORLD);
    }

    private static void addBiome(Biome biome, String name, int weight, boolean canGenerate, BiomeManager.BiomeType biomeType, BiomeDictionary.Type ... types) {
        biome.setRegistryName(Reference.location(name));
        ForgeRegistries.BIOMES.register((IForgeRegistryEntry)biome);
        BiomeDictionary.addTypes((Biome)biome, (BiomeDictionary.Type[])types);
        if (canGenerate) {
            BiomeManager.addBiome((BiomeManager.BiomeType)biomeType, (BiomeManager.BiomeEntry)new BiomeManager.BiomeEntry(biome, weight));
        }
        BiomeManager.addSpawnBiome((Biome)biome);
    }
}

