/*
 * Decompiled with CFR 0.152.
 */
package com.markus1002.autumnity.core.registry;

import com.markus1002.autumnity.client.renderer.entity.ModBoatRenderer;
import com.markus1002.autumnity.client.renderer.entity.SnailRenderer;
import com.markus1002.autumnity.common.entity.item.boat.ModBoatEntity;
import com.markus1002.autumnity.common.entity.passive.SnailEntity;
import com.markus1002.autumnity.core.Config;
import com.markus1002.autumnity.core.util.Reference;
import java.util.List;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntityType;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.network.FMLPlayMessages;
import net.minecraftforge.registries.ForgeRegistries;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class ModEntities {
    public static final EntityType<ModBoatEntity> BOAT = EntityType.Builder.func_220322_a(ModBoatEntity::new, (EntityClassification)EntityClassification.MISC).func_220321_a(1.375f, 0.5625f).setTrackingRange(64).setShouldReceiveVelocityUpdates(true).setUpdateInterval(3).setCustomClientFactory((spawnEntity, worldIn) -> new ModBoatEntity((FMLPlayMessages.SpawnEntity)spawnEntity, (World)worldIn)).func_206830_a(Reference.location("boat").toString());
    public static final EntityType<SnailEntity> SNAIL = EntityType.Builder.func_220322_a(SnailEntity::new, (EntityClassification)EntityClassification.CREATURE).func_220321_a(0.8f, 0.9f).setTrackingRange(64).setShouldReceiveVelocityUpdates(true).setUpdateInterval(3).func_206830_a(Reference.location("snail").toString());

    @SubscribeEvent
    public static void registerEntities(RegistryEvent.Register<EntityType<?>> event) {
        ModEntities.registerEntity(BOAT, "boat");
        ModEntities.registerEntity(SNAIL, "snail");
    }

    public static void setupEntitySpawns(Biome biome) {
        if (((List)Config.COMMON.snailSpawnBiomes.get()).contains(biome.getRegistryName().toString())) {
            ModEntities.addEntitySpawn(biome, EntityClassification.CREATURE, new Biome.SpawnListEntry(SNAIL, 4, 2, 3));
        }
    }

    private static void addEntitySpawn(Biome biome, EntityClassification entityclassification, Biome.SpawnListEntry spawnlistentry) {
        biome.func_76747_a(entityclassification).add(spawnlistentry);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void setupEntitiesClient() {
        RenderingRegistry.registerEntityRenderingHandler(ModBoatEntity.class, ModBoatRenderer::new);
        RenderingRegistry.registerEntityRenderingHandler(SnailEntity.class, SnailRenderer::new);
    }

    private static void registerEntity(EntityType<?> entity, String name) {
        entity.setRegistryName(Reference.location(name));
        ForgeRegistries.ENTITIES.register(entity);
    }
}

