/*
 * Decompiled with CFR 0.152.
 */
package com.markus1002.autumnity.common.block;

import com.markus1002.autumnity.common.block.TallFoulBerryBushBlock;
import com.markus1002.autumnity.core.registry.AutumnityBlocks;
import com.markus1002.autumnity.core.registry.AutumnityItems;
import java.util.Random;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.BushBlock;
import net.minecraft.block.IGrowable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ForgeHooks;

public class FoulBerryBushBlock
extends BushBlock
implements IGrowable {
    public static final IntegerProperty AGE = BlockStateProperties.field_222512_Y;
    private static final VoxelShape[] SHAPES = new VoxelShape[]{Block.func_208617_a((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)8.0, (double)13.0), Block.func_208617_a((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)14.0, (double)14.0)};

    public FoulBerryBushBlock(AbstractBlock.Properties properties) {
        super(properties);
        this.func_180632_j((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((Property)AGE, (Comparable)Integer.valueOf(0)));
    }

    public ItemStack func_185473_a(IBlockReader worldIn, BlockPos pos, BlockState state) {
        return new ItemStack((IItemProvider)AutumnityItems.FOUL_BERRIES.get());
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return SHAPES[(Integer)state.func_177229_b((Property)AGE)];
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_180655_c(BlockState stateIn, World worldIn, BlockPos pos, Random rand) {
        if ((Integer)stateIn.func_177229_b((Property)AGE) == 1 && rand.nextInt(5) == 0) {
            VoxelShape voxelshape = this.func_220053_a(stateIn, (IBlockReader)worldIn, pos, ISelectionContext.func_216377_a());
            Vector3d vector3d = voxelshape.func_197752_a().func_189972_c();
            double d0 = (double)pos.func_177958_n() + vector3d.field_72450_a;
            double d1 = (double)pos.func_177952_p() + vector3d.field_72449_c;
            int i = Effects.field_76436_u.func_76401_j();
            double d2 = (double)(i >> 16 & 0xFF) / 255.0;
            double d3 = (double)(i >> 8 & 0xFF) / 255.0;
            double d4 = (double)(i >> 0 & 0xFF) / 255.0;
            worldIn.func_195594_a((IParticleData)ParticleTypes.field_197625_r, d0 + (double)(rand.nextFloat() / 5.0f), (double)pos.func_177956_o() + (0.5 - (double)rand.nextFloat()), d1 + (double)(rand.nextFloat() / 5.0f), d2, d3, d4);
        }
    }

    public void func_225542_b_(BlockState state, ServerWorld worldIn, BlockPos pos, Random rand) {
        if (worldIn.func_226659_b_(pos.func_177984_a(), 0) >= 9 && ForgeHooks.onCropsGrowPre((World)worldIn, (BlockPos)pos, (BlockState)state, (rand.nextInt(4) == 0 ? 1 : 0) != 0)) {
            if ((Integer)state.func_177229_b((Property)AGE) == 0) {
                worldIn.func_180501_a(pos, (BlockState)state.func_206870_a((Property)AGE, (Comparable)Integer.valueOf(1)), 2);
            } else if (worldIn.func_175623_d(pos.func_177984_a())) {
                TallFoulBerryBushBlock tallfoulberrybush = (TallFoulBerryBushBlock)AutumnityBlocks.TALL_FOUL_BERRY_BUSH.get();
                tallfoulberrybush.placeAt((IWorld)worldIn, pos, 0, 2);
            }
            ForgeHooks.onCropsGrowPost((World)worldIn, (BlockPos)pos, (BlockState)state);
        }
    }

    public void func_196262_a(BlockState state, World worldIn, BlockPos pos, Entity entityIn) {
        if (entityIn instanceof LivingEntity && entityIn.func_200600_R() != EntityType.field_226289_e_) {
            LivingEntity livingentity = (LivingEntity)entityIn;
            entityIn.func_213295_a(state, new Vector3d((double)0.8f, 0.75, (double)0.8f));
            if (!(worldIn.field_72995_K || livingentity.func_70644_a(Effects.field_76436_u) || livingentity.func_225608_bj_())) {
                livingentity.func_195064_c(new EffectInstance(Effects.field_76436_u, 120));
            }
        }
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{AGE});
    }

    public boolean func_176473_a(IBlockReader worldIn, BlockPos pos, BlockState state, boolean isClient) {
        return true;
    }

    public boolean func_180670_a(World worldIn, Random rand, BlockPos pos, BlockState state) {
        return true;
    }

    public void func_225535_a_(ServerWorld worldIn, Random rand, BlockPos pos, BlockState state) {
        if ((Integer)state.func_177229_b((Property)AGE) == 0) {
            worldIn.func_180501_a(pos, (BlockState)state.func_206870_a((Property)AGE, (Comparable)Integer.valueOf(1)), 2);
        } else if (worldIn.func_175623_d(pos.func_177984_a())) {
            TallFoulBerryBushBlock tallfoulberrybush = (TallFoulBerryBushBlock)AutumnityBlocks.TALL_FOUL_BERRY_BUSH.get();
            tallfoulberrybush.placeAt((IWorld)worldIn, pos, 0, 2);
        }
    }
}

