/*
 * Decompiled with CFR 0.152.
 */
package com.markus1002.autumnity.common.block;

import com.markus1002.autumnity.core.registry.ModBlocks;
import com.markus1002.autumnity.core.registry.ModEffects;
import com.markus1002.autumnity.core.registry.ModItems;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.DoublePlantBlock;
import net.minecraft.block.IGrowable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.potion.EffectInstance;
import net.minecraft.state.IProperty;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.state.properties.DoubleBlockHalf;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ForgeHooks;

public class TallFoulBerryBushBlock
extends DoublePlantBlock
implements IGrowable {
    public static final IntegerProperty AGE = BlockStateProperties.field_208168_U;
    private static final VoxelShape TOP_SHAPE = Block.func_208617_a((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)6.0, (double)15.0);
    private static final VoxelShape SHAPE = Block.func_208617_a((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)16.0, (double)15.0);

    public TallFoulBerryBushBlock(Block.Properties properties) {
        super(properties);
        this.func_180632_j((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((IProperty)field_176492_b, (Comparable)DoubleBlockHalf.LOWER)).func_206870_a((IProperty)AGE, (Comparable)Integer.valueOf(0)));
    }

    public ItemStack func_185473_a(IBlockReader worldIn, BlockPos pos, BlockState state) {
        return new ItemStack((IItemProvider)ModItems.FOUL_BERRIES.get());
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        if ((Integer)state.func_177229_b((IProperty)AGE) == 0 && state.func_177229_b((IProperty)field_176492_b) == DoubleBlockHalf.UPPER) {
            return TOP_SHAPE;
        }
        return SHAPE;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_180655_c(BlockState stateIn, World worldIn, BlockPos pos, Random rand) {
        if (rand.nextInt(10) == 0) {
            VoxelShape voxelshape = this.func_220053_a(stateIn, (IBlockReader)worldIn, pos, ISelectionContext.func_216377_a());
            Vec3d vec3d = voxelshape.func_197752_a().func_189972_c();
            double d0 = (double)pos.func_177958_n() + vec3d.field_72450_a;
            double d1 = (double)pos.func_177952_p() + vec3d.field_72449_c;
            int i = ModEffects.LIFE_STASIS.func_76401_j();
            double d2 = (double)(i >> 16 & 0xFF) / 255.0;
            double d3 = (double)(i >> 8 & 0xFF) / 255.0;
            double d4 = (double)(i >> 0 & 0xFF) / 255.0;
            worldIn.func_195594_a((IParticleData)ParticleTypes.field_197625_r, d0 + (double)(rand.nextFloat() / 5.0f), (double)pos.func_177956_o() + (0.5 - (double)rand.nextFloat()), d1 + (double)(rand.nextFloat() / 5.0f), d2, d3, d4);
        }
    }

    public void func_225534_a_(BlockState state, ServerWorld worldIn, BlockPos pos, Random rand) {
        super.func_225534_a_(state, worldIn, pos, rand);
        int i = (Integer)state.func_177229_b((IProperty)AGE);
        if (i < 3 && state.func_177229_b((IProperty)field_176492_b) == DoubleBlockHalf.LOWER && worldIn.func_226659_b_(pos.func_177984_a(), 0) >= 9 && ForgeHooks.onCropsGrowPre((World)worldIn, (BlockPos)pos, (BlockState)state, (rand.nextInt(4) == 0 ? 1 : 0) != 0)) {
            worldIn.func_180501_a(pos, (BlockState)state.func_206870_a((IProperty)AGE, (Comparable)Integer.valueOf(i + 1)), 2);
            TallFoulBerryBushBlock.setHalfState((World)worldIn, pos, state, i + 1);
            ForgeHooks.onCropsGrowPost((World)worldIn, (BlockPos)pos, (BlockState)state);
        }
    }

    public void func_196262_a(BlockState state, World worldIn, BlockPos pos, Entity entityIn) {
        if (entityIn instanceof LivingEntity && entityIn.func_200600_R() != EntityType.field_226289_e_) {
            entityIn.func_213295_a(state, new Vec3d((double)0.8f, 0.75, (double)0.8f));
            if (!worldIn.field_72995_K) {
                ((LivingEntity)entityIn).func_195064_c(new EffectInstance(ModEffects.LIFE_STASIS, 400));
            }
        }
    }

    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult p_225533_6_) {
        boolean flag;
        int i = (Integer)state.func_177229_b((IProperty)AGE);
        boolean bl = flag = i == 3;
        if (!flag && player.func_184586_b(handIn).func_77973_b() == Items.field_196106_bc) {
            return ActionResultType.PASS;
        }
        if (i > 1) {
            TallFoulBerryBushBlock.func_180635_a((World)worldIn, (BlockPos)pos, (ItemStack)new ItemStack((IItemProvider)ModItems.FOUL_BERRIES.get(), 2 + worldIn.field_73012_v.nextInt(2)));
            worldIn.func_184133_a((PlayerEntity)null, pos, SoundEvents.field_219693_lB, SoundCategory.BLOCKS, 1.0f, 0.8f + worldIn.field_73012_v.nextFloat() * 0.4f);
            worldIn.func_180501_a(pos, (BlockState)state.func_206870_a((IProperty)AGE, (Comparable)Integer.valueOf(i - 1)), 2);
            TallFoulBerryBushBlock.setHalfState(worldIn, pos, state, i - 1);
            return ActionResultType.SUCCESS;
        }
        return super.func_225533_a_(state, worldIn, pos, player, handIn, p_225533_6_);
    }

    public void func_196390_a(IWorld worldIn, BlockPos pos, int flags) {
        this.placeAt(worldIn, pos, 3, flags);
    }

    public void placeAt(IWorld worldIn, BlockPos pos, int age, int flags) {
        worldIn.func_180501_a(pos, (BlockState)((BlockState)this.func_176223_P().func_206870_a((IProperty)field_176492_b, (Comparable)DoubleBlockHalf.LOWER)).func_206870_a((IProperty)AGE, (Comparable)Integer.valueOf(age)), flags);
        worldIn.func_180501_a(pos.func_177984_a(), (BlockState)((BlockState)this.func_176223_P().func_206870_a((IProperty)field_176492_b, (Comparable)DoubleBlockHalf.UPPER)).func_206870_a((IProperty)AGE, (Comparable)Integer.valueOf(age)), flags);
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new IProperty[]{field_176492_b, AGE});
    }

    public boolean func_176473_a(IBlockReader worldIn, BlockPos pos, BlockState state, boolean isClient) {
        return (Integer)state.func_177229_b((IProperty)AGE) < 3;
    }

    public boolean func_180670_a(World worldIn, Random rand, BlockPos pos, BlockState state) {
        return true;
    }

    public void func_225535_a_(ServerWorld worldIn, Random rand, BlockPos pos, BlockState state) {
        int i = Math.min(3, (Integer)state.func_177229_b((IProperty)AGE) + 1);
        worldIn.func_180501_a(pos, (BlockState)state.func_206870_a((IProperty)AGE, (Comparable)Integer.valueOf(i)), 2);
        TallFoulBerryBushBlock.setHalfState((World)worldIn, pos, state, i);
    }

    public Block.OffsetType func_176218_Q() {
        return Block.OffsetType.NONE;
    }

    private static void setHalfState(World worldIn, BlockPos pos, BlockState state, int age) {
        if (state.func_177229_b((IProperty)field_176492_b) == DoubleBlockHalf.UPPER) {
            if (worldIn.func_180495_p(pos.func_177977_b()).func_177230_c() == ModBlocks.TALL_FOUL_BERRY_BUSH.get()) {
                worldIn.func_180501_a(pos.func_177977_b(), (BlockState)worldIn.func_180495_p(pos.func_177977_b()).func_206870_a((IProperty)AGE, (Comparable)Integer.valueOf(age)), 2);
            }
        } else if (worldIn.func_180495_p(pos.func_177984_a()).func_177230_c() == ModBlocks.TALL_FOUL_BERRY_BUSH.get()) {
            worldIn.func_180501_a(pos.func_177984_a(), (BlockState)worldIn.func_180495_p(pos.func_177984_a()).func_206870_a((IProperty)AGE, (Comparable)Integer.valueOf(age)), 2);
        }
    }
}

