/*
 * Decompiled with CFR 0.152.
 */
package com.markus1002.autumnity.core.registry;

import com.markus1002.autumnity.common.world.biome.ModBiomeFeatures;
import com.markus1002.autumnity.common.world.gen.feature.FallenLeavesFeature;
import com.markus1002.autumnity.common.world.gen.feature.MapleTreeFeature;
import com.markus1002.autumnity.core.Config;
import java.util.List;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.feature.ConfiguredFeature;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraft.world.gen.feature.TreeFeatureConfig;
import net.minecraft.world.gen.placement.AtSurfaceWithExtraConfig;
import net.minecraft.world.gen.placement.IPlacementConfig;
import net.minecraft.world.gen.placement.Placement;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class ModFeatures {
    public static final Feature<TreeFeatureConfig> MAPLE_TREE = new MapleTreeFeature(TreeFeatureConfig::func_227338_a_);
    public static final Feature<NoFeatureConfig> FALLEN_LEAVES = new FallenLeavesFeature(NoFeatureConfig::func_214639_a);

    @SubscribeEvent
    public static void registerFeatures(RegistryEvent.Register<Feature<?>> event) {
        ModFeatures.registerFeature(MAPLE_TREE, "maple_tree");
        ModFeatures.registerFeature(FALLEN_LEAVES, "fallen_leaves");
    }

    private static void registerFeature(Feature<?> feature, String name) {
        feature.setRegistryName(name);
        ForgeRegistries.FEATURES.register(feature);
    }

    public static void setupBiomeFeatures(Biome biome) {
        if (((List)Config.COMMON.mapleTreeBiomes.get()).contains(biome.getRegistryName().toString())) {
            ModFeatures.addBiomeFeature(biome, GenerationStage.Decoration.VEGETAL_DECORATION, MAPLE_TREE.func_225566_b_((IFeatureConfig)ModBiomeFeatures.MAPLE_TREE_CONFIG).func_227228_a_(Placement.field_215027_m.func_227446_a_((IPlacementConfig)new AtSurfaceWithExtraConfig(1, 0.05f, 1))));
        }
    }

    private static void addBiomeFeature(Biome biome, GenerationStage.Decoration decorationStage, ConfiguredFeature<?, ?> featureIn) {
        if (!biome.func_203607_a(decorationStage).contains(featureIn)) {
            biome.func_203611_a(decorationStage, featureIn);
        }
    }
}

