/*
 * Decompiled with CFR 0.152.
 */
package com.talp1.talpsadditions.entity.ResourceSheep;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.AgeableEntity;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.IShearable;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.EatGrassGoal;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.PanicGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.ai.goal.WaterAvoidingRandomWalkingGoal;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.IForgeShearable;

public class ResourceSheepEntity
extends AnimalEntity
implements IShearable,
IForgeShearable {
    private String resourceType;
    private boolean sheared;
    private int sheepTimer;
    private EatGrassGoal eatGrassGoal;

    public boolean isSheared() {
        return this.sheared;
    }

    public void setSheared(boolean sheared) {
        this.sheared = sheared;
    }

    public String getResourceType() {
        return this.resourceType;
    }

    public void setResourceType(String resourceType) {
        this.resourceType = resourceType;
    }

    public ResourceSheepEntity(EntityType<? extends ResourceSheepEntity> type, World worldIn) {
        super(type, worldIn);
        this.setSheared(false);
    }

    @Nullable
    public ILivingEntityData func_213386_a(IWorld worldIn, DifficultyInstance difficultyIn, SpawnReason reason, @Nullable ILivingEntityData spawnDataIn, @Nullable CompoundNBT dataTag) {
        return super.func_213386_a(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
    }

    @Nullable
    public AgeableEntity func_90011_a(AgeableEntity ageable) {
        return null;
    }

    public void func_230263_a_(SoundCategory category) {
        this.field_70170_p.func_217384_a((PlayerEntity)null, (Entity)this, SoundEvents.field_187763_eJ, category, 1.0f, 1.0f);
        this.setSheared(true);
        this.func_199703_a((IItemProvider)this.convertStringToItem(this.resourceType));
    }

    public boolean func_230262_K__() {
        return this.func_70089_S() && !this.isSheared() && !this.func_70631_g_();
    }

    public boolean isShearable(@Nonnull ItemStack item, World world, BlockPos pos) {
        return this.func_230262_K__();
    }

    @Nonnull
    public List<ItemStack> onSheared(@Nullable PlayerEntity player, @Nonnull ItemStack item, World world, BlockPos pos, int fortune) {
        world.func_217384_a(null, (Entity)this, SoundEvents.field_187763_eJ, player == null ? SoundCategory.BLOCKS : SoundCategory.PLAYERS, 1.0f, 1.0f);
        if (!world.field_72995_K) {
            ArrayList<ItemStack> items = new ArrayList<ItemStack>();
            this.setSheared(true);
            items.add(new ItemStack((IItemProvider)this.convertStringToItem(this.resourceType)));
            return items;
        }
        return Collections.emptyList();
    }

    public void func_70615_aA() {
        this.setSheared(false);
    }

    protected float func_213348_b(Pose poseIn, EntitySize sizeIn) {
        return 0.95f * sizeIn.field_220316_b;
    }

    protected SoundEvent func_184639_G() {
        return SoundEvents.field_187757_eG;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return SoundEvents.field_187761_eI;
    }

    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_187759_eH;
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        this.setSheared(compound.func_74767_n("Sheared"));
        this.setResourceType(compound.func_74779_i("ResourceType"));
    }

    private Item convertStringToItem(String stringItem) {
        switch (stringItem) {
            case "coal": {
                return Items.field_151044_h;
            }
            case "diamond": {
                return Items.field_151045_i;
            }
            case "iron": {
                return Items.field_151042_j;
            }
            case "emerald": {
                return Items.field_151166_bC;
            }
            case "lapis": {
                return Items.field_196128_bn;
            }
            case "redstone": {
                return Items.field_151137_ax;
            }
            case "gold": {
                return Items.field_151043_k;
            }
            case "quartz": {
                return Items.field_151128_bU;
            }
            case "netherite": {
                return Items.field_234759_km_;
            }
        }
        return Items.field_151044_h;
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74757_a("Sheared", this.isSheared());
        compound.func_74778_a("ResourceType", this.getResourceType());
    }

    @OnlyIn(value=Dist.CLIENT)
    public float getHeadRotationPointY(float p_70894_1_) {
        if (this.sheepTimer <= 0) {
            return 0.0f;
        }
        if (this.sheepTimer >= 4 && this.sheepTimer <= 36) {
            return 1.0f;
        }
        return this.sheepTimer < 4 ? ((float)this.sheepTimer - p_70894_1_) / 4.0f : -((float)(this.sheepTimer - 40) - p_70894_1_) / 4.0f;
    }

    @OnlyIn(value=Dist.CLIENT)
    public float getHeadRotationAngleX(float p_70890_1_) {
        if (this.sheepTimer > 4 && this.sheepTimer <= 36) {
            float f = ((float)(this.sheepTimer - 4) - p_70890_1_) / 32.0f;
            return 0.62831855f + 0.21991149f * MathHelper.func_76126_a((float)(f * 28.7f));
        }
        return this.sheepTimer > 0 ? 0.62831855f : this.field_70125_A * ((float)Math.PI / 180);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_70103_a(byte id) {
        if (id == 10) {
            this.sheepTimer = 40;
        } else {
            super.func_70103_a(id);
        }
    }

    public static AttributeModifierMap.MutableAttribute setCustomAttributes() {
        return MobEntity.func_233666_p_().func_233815_a_(Attributes.field_233818_a_, 8.0).func_233815_a_(Attributes.field_233821_d_, (double)0.23f);
    }

    public void func_70636_d() {
        if (this.field_70170_p.field_72995_K) {
            this.sheepTimer = Math.max(0, this.sheepTimer - 1);
        }
        super.func_70636_d();
    }

    protected void func_184651_r() {
        this.eatGrassGoal = new EatGrassGoal((MobEntity)this);
        this.field_70714_bg.func_75776_a(0, (Goal)new SwimGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(1, (Goal)new PanicGoal((CreatureEntity)this, 1.25));
        this.field_70714_bg.func_75776_a(2, (Goal)this.eatGrassGoal);
        this.field_70714_bg.func_75776_a(3, (Goal)new WaterAvoidingRandomWalkingGoal((CreatureEntity)this, 1.0));
        this.field_70714_bg.func_75776_a(4, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 6.0f));
        this.field_70714_bg.func_75776_a(5, (Goal)new LookRandomlyGoal((MobEntity)this));
    }

    protected void func_70619_bc() {
        this.sheepTimer = this.eatGrassGoal.func_151499_f();
        super.func_70619_bc();
    }

    public boolean func_70877_b(ItemStack stack) {
        return false;
    }
}

