/*
 * Decompiled with CFR 0.152.
 */
package com.talp1.talpsadditions.container;

import com.talp1.talpsadditions.utils.EnergyStorageHandler;
import com.talp1.talpsadditions.utils.RegistryHandler;
import java.util.ArrayList;
import java.util.Arrays;
import net.minecraft.block.Block;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIntArray;
import net.minecraft.util.IWorldPosCallable;
import net.minecraft.util.IntArray;
import net.minecraft.util.IntReferenceHolder;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.SlotItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;

public class GenLabContainer
extends Container {
    private TileEntity tileEntity;
    private PlayerEntity playerEntity;
    private IItemHandler playerInventory;
    private final IIntArray genLabData;
    private static ArrayList<Item> baseItems = new ArrayList<Item>(Arrays.asList(Items.field_151008_G, Items.field_221603_aE, (Item)RegistryHandler.bush_leaf.get(), Items.field_221796_dh));
    private static ArrayList<Item> toInjItems = new ArrayList<Item>(Arrays.asList((Item)RegistryHandler.petal.get(), Items.field_196106_bc, Items.field_222083_lx, Items.field_222078_li, Items.field_196118_bi, Items.field_222069_lA, Items.field_196126_bm, Items.field_221732_cb, Items.field_221896_ff, Items.field_221698_bk, Items.field_221739_dF, Items.field_221654_ao, Items.field_221858_em, Items.field_221696_bj, Items.field_221866_eq, Items.field_234794_rw_));
    private static ArrayList<Item> injIntoItems = new ArrayList<Item>(Arrays.asList(Items.field_151110_aK, Items.field_151014_N, (Item)RegistryHandler.bush_sprout.get()));
    private static ArrayList<Item> geneItems = new ArrayList<Item>(Arrays.asList((Item)RegistryHandler.bush_gene.get(), (Item)RegistryHandler.chicken_gene.get(), (Item)RegistryHandler.vine_gene.get(), (Item)RegistryHandler.sheep_gene.get()));
    private static ArrayList<Item> geneMod = new ArrayList<Item>(Arrays.asList((Item)RegistryHandler.animal_gen_modifier.get(), (Item)RegistryHandler.vegetal_gen_modifier.get()));

    public GenLabContainer(int windowId, World world, BlockPos pos, PlayerInventory playerInventory, PlayerEntity player) {
        this(windowId, world, pos, playerInventory, player, (IIntArray)new IntArray(2));
    }

    public GenLabContainer(int windowId, World world, BlockPos pos, PlayerInventory playerInventory, PlayerEntity player, IIntArray genLabDataIn) {
        super((ContainerType)RegistryHandler.gen_lab_container.get(), windowId);
        this.tileEntity = world.func_175625_s(pos);
        this.playerEntity = player;
        this.playerInventory = new InvWrapper((IInventory)playerInventory);
        GenLabContainer.func_216959_a((IIntArray)genLabDataIn, (int)2);
        this.genLabData = genLabDataIn;
        if (this.tileEntity != null) {
            this.tileEntity.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).ifPresent(h -> {
                this.func_75146_a((Slot)new SlotItemHandler(h, 0, 48, -48));
                this.func_75146_a((Slot)new SlotItemHandler(h, 1, 110, -48));
                this.func_75146_a((Slot)new SlotItemHandler(h, 2, 27, -8));
                this.func_75146_a((Slot)new SlotItemHandler(h, 3, 131, -8));
                this.func_75146_a((Slot)new SlotItemHandler(h, 4, 27, 34));
                this.func_75146_a((Slot)new SlotItemHandler(h, 5, 81, 81));
            });
        }
        this.layoutPlayerInventorySlots(10, 90);
        this.trackPower();
        this.func_216961_a(genLabDataIn);
    }

    private void trackPower() {
        this.func_216958_a(new IntReferenceHolder(){

            public int func_221495_b() {
                return GenLabContainer.this.getEnergy() & 0xFFFF;
            }

            public void func_221494_a(int value) {
                GenLabContainer.this.tileEntity.getCapability(CapabilityEnergy.ENERGY).ifPresent(h -> {
                    int energyStored = h.getEnergyStored() & 0xFFFF0000;
                    ((EnergyStorageHandler)((Object)h)).setEnergy(energyStored + (value & 0xFFFF));
                });
            }
        });
        this.func_216958_a(new IntReferenceHolder(){

            public int func_221495_b() {
                return GenLabContainer.this.getEnergy() >> 16 & 0xFFFF;
            }

            public void func_221494_a(int value) {
                GenLabContainer.this.tileEntity.getCapability(CapabilityEnergy.ENERGY).ifPresent(h -> {
                    int energyStored = h.getEnergyStored() & 0xFFFF;
                    ((EnergyStorageHandler)((Object)h)).setEnergy(energyStored | value << 16);
                });
            }
        });
    }

    public int getEnergy() {
        return this.tileEntity.getCapability(CapabilityEnergy.ENERGY).map(IEnergyStorage::getEnergyStored).orElse(0);
    }

    public boolean func_75145_c(PlayerEntity playerIn) {
        return GenLabContainer.func_216963_a((IWorldPosCallable)IWorldPosCallable.func_221488_a((World)this.tileEntity.func_145831_w(), (BlockPos)this.tileEntity.func_174877_v()), (PlayerEntity)this.playerEntity, (Block)((Block)RegistryHandler.gen_lab_block.get()));
    }

    public ItemStack func_82846_b(PlayerEntity playerIn, int index) {
        ItemStack itemstack = ItemStack.field_190927_a;
        Slot slot = (Slot)this.field_75151_b.get(index);
        if (slot != null && slot.func_75216_d()) {
            ItemStack stack = slot.func_75211_c();
            itemstack = stack.func_77946_l();
            if (index == 0 || index == 1 || index == 2 || index == 3 || index == 4 || index == 5) {
                if (!this.func_75135_a(stack, 6, 42, true)) {
                    return ItemStack.field_190927_a;
                }
                slot.func_75220_a(stack, itemstack);
            } else if (geneItems.contains(stack.func_77973_b()) ? !this.func_75135_a(stack, 0, 1, false) : (geneMod.contains(stack.func_77973_b()) ? !this.func_75135_a(stack, 1, 2, false) : (baseItems.contains(stack.func_77973_b()) ? !this.func_75135_a(stack, 2, 3, false) : (toInjItems.contains(stack.func_77973_b()) ? !this.func_75135_a(stack, 3, 4, false) : (injIntoItems.contains(stack.func_77973_b()) ? !this.func_75135_a(stack, 4, 5, false) : (index < 34 ? !this.func_75135_a(stack, 34, 42, false) : index < 42 && !this.func_75135_a(stack, 1, 34, false))))))) {
                return ItemStack.field_190927_a;
            }
            if (stack.func_190926_b()) {
                slot.func_75215_d(ItemStack.field_190927_a);
            } else {
                slot.func_75218_e();
            }
            if (stack.func_190916_E() == itemstack.func_190916_E()) {
                return ItemStack.field_190927_a;
            }
            slot.func_190901_a(playerIn, stack);
        }
        return itemstack;
    }

    private int addSlotRange(IItemHandler handler, int index, int x, int y, int amount, int dx) {
        for (int i = 0; i < amount; ++i) {
            this.func_75146_a((Slot)new SlotItemHandler(handler, index, x, y));
            x += dx;
            ++index;
        }
        return index;
    }

    private int addSlotBox(IItemHandler handler, int index, int x, int y, int horAmount, int dx, int verAmount, int dy) {
        for (int j = 0; j < verAmount; ++j) {
            index = this.addSlotRange(handler, index, x, y, horAmount, dx);
            y += dy;
        }
        return index;
    }

    private void layoutPlayerInventorySlots(int leftCol, int topRow) {
        this.addSlotBox(this.playerInventory, 9, leftCol - 2, topRow * 2 - 9 - 60, 9, 18, 3, 18);
        this.addSlotRange(this.playerInventory, 0, leftCol - 2, topRow * 2 + 49 - 60, 9, 18);
    }

    public int getProgress() {
        return this.genLabData.func_221476_a(0);
    }

    public int getTotal() {
        return this.genLabData.func_221476_a(1);
    }
}

