/*
 * Decompiled with CFR 0.152.
 */
package com.talp1.talpsadditions.tile_entity;

import com.talp1.talpsadditions.utils.EnergyStorageHandler;
import com.talp1.talpsadditions.utils.RegistryHandler;
import java.util.ArrayList;
import java.util.Arrays;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.IIntArray;
import net.minecraft.util.IItemProvider;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;

public class GenLabTE
extends TileEntity
implements ITickableTileEntity {
    private final int USAGE_PER_TICK = 50;
    private int timer = -1;
    private int currAmount = 0;
    private boolean isCrafting = false;
    private ArrayList<Item> lastRecipe;
    private int totalTime = -1;
    private Item currResult = null;
    public final IIntArray genLabData = new IIntArray(){

        public int func_221476_a(int index) {
            switch (index) {
                case 0: {
                    return GenLabTE.this.timer;
                }
                case 1: {
                    return GenLabTE.this.totalTime;
                }
            }
            return 0;
        }

        public void func_221477_a(int index, int value) {
            switch (index) {
                case 0: {
                    GenLabTE.this.timer = value;
                    break;
                }
                case 1: {
                    GenLabTE.this.totalTime = value;
                }
            }
        }

        public int func_221478_a() {
            return 2;
        }
    };
    private ItemStackHandler itemHandler = this.createItemHandler();
    public EnergyStorageHandler energyStorage = this.createEnergyHandler();
    private LazyOptional<IItemHandler> handler = LazyOptional.of(() -> this.itemHandler);
    private LazyOptional<IEnergyStorage> energy = LazyOptional.of(() -> this.energyStorage);
    private static ArrayList<Item> baseItems = new ArrayList<Item>(Arrays.asList(Items.field_151008_G, Items.field_221603_aE, (Item)RegistryHandler.bush_leaf.get(), Items.field_221796_dh));
    private static ArrayList<Item> toInjItems = new ArrayList<Item>(Arrays.asList((Item)RegistryHandler.petal.get(), Items.field_196106_bc, Items.field_222083_lx, Items.field_222078_li, Items.field_196118_bi, Items.field_222069_lA, Items.field_196126_bm, Items.field_221732_cb, Items.field_221896_ff, Items.field_221698_bk, Items.field_221739_dF, Items.field_221654_ao, Items.field_221858_em, Items.field_221696_bj, Items.field_221866_eq, Items.field_234794_rw_));
    private static ArrayList<Item> injIntoItems = new ArrayList<Item>(Arrays.asList(Items.field_151110_aK, Items.field_151014_N, (Item)RegistryHandler.bush_sprout.get()));
    private static ArrayList<Item> geneItems = new ArrayList<Item>(Arrays.asList((Item)RegistryHandler.bush_gene.get(), (Item)RegistryHandler.chicken_gene.get(), (Item)RegistryHandler.vine_gene.get(), (Item)RegistryHandler.sheep_gene.get()));
    private static ArrayList<Item> geneMod = new ArrayList<Item>(Arrays.asList((Item)RegistryHandler.animal_gen_modifier.get(), (Item)RegistryHandler.vegetal_gen_modifier.get()));

    public Item getCurrResult() {
        return this.currResult;
    }

    public void setCurrResult(Item currResult, int amount) {
        this.currResult = currResult;
        this.currAmount = amount;
    }

    public GenLabTE() {
        super((TileEntityType)RegistryHandler.gen_lab_te.get());
        this.lastRecipe = new ArrayList();
    }

    private void setTimerInSecond(int sec) {
        this.timer = sec * 20;
    }

    private void decreaseTimer() {
        --this.timer;
        this.func_70296_d();
    }

    private boolean checkIfDone() {
        return this.timer == 0;
    }

    private boolean isTimerDisabled() {
        return this.timer == -1;
    }

    private void disbleTimer() {
        this.timer = -1;
        this.totalTime = -1;
    }

    private Item getItemInSlot(int slot) {
        return this.itemHandler.getStackInSlot(slot).func_77973_b();
    }

    private void dropContent() {
        for (int i = 0; i <= 5; ++i) {
            if (this.itemHandler.getStackInSlot(i).func_190926_b()) continue;
            this.func_145831_w().func_217376_c((Entity)new ItemEntity(this.func_145831_w(), (double)this.func_174877_v().func_177958_n(), (double)(this.func_174877_v().func_177956_o() + 1), (double)this.func_174877_v().func_177952_p(), this.itemHandler.getStackInSlot(i)));
        }
    }

    public void func_145843_s() {
        super.func_145843_s();
        this.dropContent();
        this.handler.invalidate();
        this.energy.invalidate();
    }

    private EnergyStorageHandler createEnergyHandler() {
        return new EnergyStorageHandler(50000, 0){

            public boolean canReceive() {
                return true;
            }

            public int receiveEnergy(int maxReceive, boolean simulate) {
                if (!this.canReceive()) {
                    return 0;
                }
                int energyReceived = Math.min(this.capacity - this.energy, Math.min(this.maxReceive, maxReceive));
                if (!simulate) {
                    this.energy += energyReceived;
                }
                GenLabTE.this.func_70296_d();
                return energyReceived;
            }

            public int extractEnergy(int maxExtract, boolean simulate) {
                if (!this.canExtract()) {
                    return 0;
                }
                int energyExtracted = Math.min(this.energy, Math.min(this.maxExtract, maxExtract));
                if (!simulate) {
                    this.energy -= energyExtracted;
                }
                GenLabTE.this.func_70296_d();
                return energyExtracted;
            }
        };
    }

    private ItemStackHandler createItemHandler() {
        return new ItemStackHandler(6){

            protected void onContentsChanged(int slot) {
                GenLabTE.this.func_70296_d();
            }

            public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
                switch (slot) {
                    case 0: {
                        return geneItems.contains(stack.func_77973_b());
                    }
                    case 1: {
                        return geneMod.contains(stack.func_77973_b());
                    }
                    case 2: {
                        return baseItems.contains(stack.func_77973_b());
                    }
                    case 3: {
                        return toInjItems.contains(stack.func_77973_b());
                    }
                    case 4: {
                        return injIntoItems.contains(stack.func_77973_b());
                    }
                    case 5: {
                        return false;
                    }
                }
                return super.isItemValid(slot, stack);
            }

            @Nonnull
            public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
                return this.isItemValid(slot, stack) ? super.insertItem(slot, stack, simulate) : stack;
            }
        };
    }

    private void saveRecipe() {
        this.lastRecipe.clear();
        for (int i = 0; i < 5; ++i) {
            if (this.itemHandler.getStackInSlot(i).func_190926_b()) continue;
            this.lastRecipe.add(i, this.itemHandler.getStackInSlot(i).func_77973_b());
        }
    }

    private void startCrafting(int timerDuration) {
        this.saveRecipe();
        this.totalTime = timerDuration * 20;
        this.isCrafting = true;
        if (this.isTimerDisabled()) {
            this.setTimerInSecond(timerDuration);
        }
    }

    private boolean checkSlots() {
        for (int i = 0; i < 5; ++i) {
            if (!this.itemHandler.getStackInSlot(i).func_190926_b()) {
                if (this.itemHandler.getStackInSlot(i).func_77973_b() == this.lastRecipe.get(i)) continue;
                this.stopCrafting();
                return false;
            }
            this.stopCrafting();
            return false;
        }
        return true;
    }

    private void stopCrafting() {
        this.isCrafting = false;
        this.totalTime = -1;
        this.disbleTimer();
        this.func_70296_d();
    }

    private void produceResult() {
        this.itemHandler.extractItem(0, 1, false);
        this.itemHandler.extractItem(1, 1, false);
        this.itemHandler.extractItem(2, 1, false);
        this.itemHandler.extractItem(3, 1, false);
        this.itemHandler.extractItem(4, 1, false);
        if (this.itemHandler.getStackInSlot(5).func_190926_b()) {
            this.itemHandler.setStackInSlot(5, new ItemStack((IItemProvider)this.getCurrResult(), this.currAmount));
        } else if (this.itemHandler.getStackInSlot(5).func_77973_b() == this.getCurrResult() && this.itemHandler.getStackInSlot(5).func_190916_E() + this.currAmount <= 64) {
            this.itemHandler.getStackInSlot(5).func_190920_e(this.itemHandler.getStackInSlot(5).func_190916_E() + this.currAmount);
        } else {
            this.dropContent();
            this.func_145831_w().func_217376_c((Entity)new ItemEntity(this.func_145831_w(), (double)this.func_174877_v().func_177958_n(), (double)(this.func_174877_v().func_177956_o() + 1), (double)this.func_174877_v().func_177952_p(), new ItemStack((IItemProvider)this.getCurrResult(), this.currAmount)));
        }
    }

    public void func_73660_a() {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        BlockState blockState = this.field_145850_b.func_180495_p(this.field_174879_c);
        if (this.energyStorage.getEnergyStored() > 0 && this.timer > 0) {
            this.field_145850_b.func_180501_a(this.field_174879_c, (BlockState)blockState.func_206870_a((Property)BlockStateProperties.field_208194_u, (Comparable)Boolean.valueOf(true)), 3);
        } else {
            this.field_145850_b.func_180501_a(this.field_174879_c, (BlockState)blockState.func_206870_a((Property)BlockStateProperties.field_208194_u, (Comparable)Boolean.valueOf(false)), 3);
        }
        if (this.isCrafting) {
            this.energyStorage.consumeEnergy(50);
            this.decreaseTimer();
            this.checkSlots();
            if (this.energyStorage.getEnergyStored() < 50) {
                this.stopCrafting();
            }
            if (this.checkIfDone()) {
                this.isCrafting = false;
                this.disbleTimer();
                this.produceResult();
            }
        } else {
            if (this.getItemInSlot(0) == RegistryHandler.bush_gene.get() && this.getItemInSlot(1) == RegistryHandler.vegetal_gen_modifier.get() && this.getItemInSlot(2) == RegistryHandler.bush_leaf.get() && this.getItemInSlot(4) == RegistryHandler.bush_sprout.get()) {
                if (this.getItemInSlot(3) == Items.field_222083_lx) {
                    this.startCrafting(15);
                    this.setCurrResult((Item)RegistryHandler.blue_hydrangea_sprout.get(), 1);
                }
                if (this.getItemInSlot(3) == Items.field_222078_li) {
                    this.startCrafting(15);
                    this.setCurrResult((Item)RegistryHandler.red_hydrangea_sprout.get(), 1);
                }
                if (this.getItemInSlot(3) == Items.field_196118_bi) {
                    this.startCrafting(15);
                    this.setCurrResult((Item)RegistryHandler.pink_hydrangea_sprout.get(), 1);
                }
                if (this.getItemInSlot(3) == Items.field_222069_lA) {
                    this.startCrafting(15);
                    this.setCurrResult((Item)RegistryHandler.white_hydrangea_sprout.get(), 1);
                }
                if (this.getItemInSlot(3) == Items.field_196126_bm) {
                    this.startCrafting(15);
                    this.setCurrResult((Item)RegistryHandler.lilac_hydrangea_sprout.get(), 1);
                }
            }
            if (this.getItemInSlot(0) == RegistryHandler.bush_gene.get() && this.getItemInSlot(1) == RegistryHandler.vegetal_gen_modifier.get() && this.getItemInSlot(2) == RegistryHandler.bush_leaf.get() && this.getItemInSlot(3) == Items.field_196106_bc && this.getItemInSlot(4) == Items.field_151014_N) {
                this.startCrafting(15);
                this.setCurrResult((Item)RegistryHandler.bush_sprout.get(), 1);
            }
            if (this.getItemInSlot(0) == RegistryHandler.vine_gene.get() && this.getItemInSlot(1) == RegistryHandler.vegetal_gen_modifier.get() && this.getItemInSlot(2) == Items.field_221796_dh && this.getItemInSlot(3) == RegistryHandler.petal.get() && this.getItemInSlot(4) == Items.field_151014_N) {
                this.startCrafting(20);
                this.setCurrResult((Item)RegistryHandler.floreal_vines_item.get(), 2);
            }
            if (this.getItemInSlot(0) == RegistryHandler.chicken_gene.get() && this.getItemInSlot(1) == RegistryHandler.animal_gen_modifier.get() && this.getItemInSlot(2) == Items.field_151008_G && this.getItemInSlot(4) == Items.field_151110_aK) {
                if (this.getItemInSlot(3) == Items.field_221896_ff) {
                    this.startCrafting(60);
                    this.setCurrResult(RegistryHandler.ExtraRegHandler.coalChickenSpawnEgg.getItem(), 1);
                }
                if (this.getItemInSlot(3) == Items.field_221732_cb) {
                    this.startCrafting(60);
                    this.setCurrResult(RegistryHandler.ExtraRegHandler.diamondChickenSpawnEgg.getItem(), 1);
                }
                if (this.getItemInSlot(3) == Items.field_221739_dF) {
                    this.startCrafting(60);
                    this.setCurrResult(RegistryHandler.ExtraRegHandler.emeraldChickenSpawnEgg.getItem(), 1);
                }
                if (this.getItemInSlot(3) == Items.field_221696_bj) {
                    this.startCrafting(60);
                    this.setCurrResult(RegistryHandler.ExtraRegHandler.goldChickenSpawnEgg.getItem(), 1);
                }
                if (this.getItemInSlot(3) == Items.field_221698_bk) {
                    this.startCrafting(60);
                    this.setCurrResult(RegistryHandler.ExtraRegHandler.ironChickenSpawnEgg.getItem(), 1);
                }
                if (this.getItemInSlot(3) == Items.field_221654_ao) {
                    this.startCrafting(60);
                    this.setCurrResult(RegistryHandler.ExtraRegHandler.lapisChickenSpawnEgg.getItem(), 1);
                }
                if (this.getItemInSlot(3) == Items.field_221866_eq) {
                    this.startCrafting(60);
                    this.setCurrResult(RegistryHandler.ExtraRegHandler.quartzChickenSpawnEgg.getItem(), 1);
                }
                if (this.getItemInSlot(3) == Items.field_234794_rw_) {
                    this.startCrafting(60);
                    this.setCurrResult(RegistryHandler.ExtraRegHandler.netheriteChickenSpawnEgg.getItem(), 1);
                }
                if (this.getItemInSlot(3) == Items.field_221858_em) {
                    this.startCrafting(60);
                    this.setCurrResult(RegistryHandler.ExtraRegHandler.redstoneChickenSpawnEgg.getItem(), 1);
                }
            }
            if (this.getItemInSlot(0) == RegistryHandler.sheep_gene.get() && this.getItemInSlot(1) == RegistryHandler.animal_gen_modifier.get() && this.getItemInSlot(2) == Items.field_221603_aE && this.getItemInSlot(4) == Items.field_151110_aK) {
                if (this.getItemInSlot(3) == Items.field_221896_ff) {
                    this.startCrafting(60);
                    this.setCurrResult(RegistryHandler.ExtraRegHandler.coalSheepSpawnEgg.getItem(), 1);
                }
                if (this.getItemInSlot(3) == Items.field_221732_cb) {
                    this.startCrafting(60);
                    this.setCurrResult(RegistryHandler.ExtraRegHandler.diamondSheepSpawnEgg.getItem(), 1);
                }
                if (this.getItemInSlot(3) == Items.field_221739_dF) {
                    this.startCrafting(60);
                    this.setCurrResult(RegistryHandler.ExtraRegHandler.emeraldSheepSpawnEgg.getItem(), 1);
                }
                if (this.getItemInSlot(3) == Items.field_221696_bj) {
                    this.startCrafting(60);
                    this.setCurrResult(RegistryHandler.ExtraRegHandler.goldSheepSpawnEgg.getItem(), 1);
                }
                if (this.getItemInSlot(3) == Items.field_221698_bk) {
                    this.startCrafting(60);
                    this.setCurrResult(RegistryHandler.ExtraRegHandler.ironSheepSpawnEgg.getItem(), 1);
                }
                if (this.getItemInSlot(3) == Items.field_221654_ao) {
                    this.startCrafting(60);
                    this.setCurrResult(RegistryHandler.ExtraRegHandler.lapisSheepSpawnEgg.getItem(), 1);
                }
                if (this.getItemInSlot(3) == Items.field_221866_eq) {
                    this.startCrafting(60);
                    this.setCurrResult(RegistryHandler.ExtraRegHandler.quartzSheepSpawnEgg.getItem(), 1);
                }
                if (this.getItemInSlot(3) == Items.field_234794_rw_) {
                    this.startCrafting(60);
                    this.setCurrResult(RegistryHandler.ExtraRegHandler.netheriteSheepSpawnEgg.getItem(), 1);
                }
                if (this.getItemInSlot(3) == Items.field_221858_em) {
                    this.startCrafting(60);
                    this.setCurrResult(RegistryHandler.ExtraRegHandler.redstoneSheepSpawnEgg.getItem(), 1);
                }
            }
            if (this.getItemInSlot(0) == RegistryHandler.vine_gene.get() && this.getItemInSlot(1) == RegistryHandler.vegetal_gen_modifier.get() && this.getItemInSlot(2) == Items.field_221796_dh && this.getItemInSlot(3) == Items.field_221898_fg && this.getItemInSlot(4) == Items.field_151014_N) {
                this.startCrafting(20);
                this.setCurrResult((Item)RegistryHandler.frosted_vines_item.get(), 2);
            }
        }
    }

    public CompoundNBT func_189515_b(CompoundNBT compound) {
        super.func_189515_b(compound);
        compound.func_218657_a("inv", (INBT)this.itemHandler.serializeNBT());
        compound.func_218657_a("energy", (INBT)this.energyStorage.serializeNBT());
        compound.func_74768_a("progress", this.getTimer());
        compound.func_74768_a("total_time", this.getTotalTime());
        return compound;
    }

    public void func_230337_a_(BlockState state, CompoundNBT nbt) {
        super.func_230337_a_(state, nbt);
        this.itemHandler.deserializeNBT(nbt.func_74775_l("inv"));
        this.energyStorage.deserializeNBT(nbt.func_74775_l("energy"));
        nbt.func_74762_e("progress");
        nbt.func_74762_e("total_time");
    }

    public int getTimer() {
        return this.timer;
    }

    public int getTotalTime() {
        return this.totalTime;
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.handler.cast();
        }
        if (cap == CapabilityEnergy.ENERGY) {
            return this.energy.cast();
        }
        return super.getCapability(cap, side);
    }
}

