/*
 * Decompiled with CFR 0.152.
 */
package com.talp1.talpsadditions.world.features;

import com.mojang.serialization.Codec;
import com.talp1.talpsadditions.utils.RegistryHandler;
import java.util.Random;
import net.minecraft.block.BlockState;
import net.minecraft.block.LeavesBlock;
import net.minecraft.block.VineBlock;
import net.minecraft.state.Property;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.NoFeatureConfig;

public class FlorealVineFeature
extends Feature<NoFeatureConfig> {
    private static final Direction[] DIRECTIONS = Direction.values();

    public FlorealVineFeature(Codec<NoFeatureConfig> p_i232002_1_) {
        super(p_i232002_1_);
    }

    public boolean place(ISeedReader world, ChunkGenerator chunkGenerator, Random rand, BlockPos startPos, NoFeatureConfig config) {
        return this.generate(world, chunkGenerator, rand, startPos, config);
    }

    public boolean generate(ISeedReader reader, ChunkGenerator generator, Random rand, BlockPos pos, NoFeatureConfig config) {
        BlockPos.Mutable blockpos$mutable = pos.func_239590_i_();
        for (int i = 0; i < 35; ++i) {
            this.tryToPlace((BlockPos)blockpos$mutable, reader, this.getValidRand(rand));
        }
        return true;
    }

    private int getValidRand(Random random) {
        int currRand = random.nextInt(255);
        while (currRand < 63) {
            currRand = random.nextInt(255);
        }
        return currRand;
    }

    private void tryToPlace(BlockPos pos, ISeedReader reader, int yIn) {
        BlockPos currPos = new BlockPos(pos.func_177958_n(), yIn, pos.func_177952_p());
        this.checkValidSpot(currPos, reader);
    }

    private void checkValidSpot(BlockPos pos, ISeedReader worldIn) {
        if (worldIn.func_175623_d(pos)) {
            for (Direction dir : DIRECTIONS) {
                if (dir == Direction.DOWN || !(worldIn.func_180495_p(pos.func_177972_a(dir)).func_177230_c() instanceof LeavesBlock)) continue;
                this.setVine(worldIn, pos, dir);
                this.tryToCreateHanging(pos, worldIn, dir);
            }
        }
    }

    private void setVine(ISeedReader worldIn, BlockPos pos, Direction dir) {
        worldIn.func_180501_a(pos, (BlockState)((VineBlock)RegistryHandler.floreal_vines.get()).func_176223_P().func_206870_a((Property)VineBlock.func_176267_a((Direction)dir), (Comparable)Boolean.TRUE), 2);
    }

    private void tryToCreateHanging(BlockPos pos, ISeedReader reader, Direction direction) {
        if (direction != Direction.UP) {
            for (int i = 0; i < new Random().nextInt(3) + 1; ++i) {
                if (!reader.func_175623_d(pos.func_177979_c(i))) continue;
                this.setVine(reader, pos.func_177979_c(i), direction);
            }
        }
    }
}

