/*
 * Decompiled with CFR 0.152.
 */
package xaero.common.core;

import java.lang.reflect.Field;
import net.minecraft.class_1657;
import net.minecraft.class_1664;
import net.minecraft.class_2626;
import net.minecraft.class_2637;
import net.minecraft.class_2672;
import net.minecraft.class_2818;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_634;
import net.minecraft.class_638;
import net.minecraft.class_742;
import xaero.common.AXaeroMinimap;
import xaero.common.XaeroMinimapSession;
import xaero.common.core.IXaeroMinimapClientPlayNetHandler;
import xaero.common.mixin.MixinChunkDeltaUpdateS2CPacketAccessor;
import xaero.patreon.Patreon5;

public class XaeroMinimapCore {
    public static AXaeroMinimap modMain;
    public static Field chunkCleanField;
    public static XaeroMinimapSession currentSession;

    public static void ensureField() {
        if (chunkCleanField == null) {
            try {
                chunkCleanField = class_2818.class.getDeclaredField("xaero_chunkClean");
            }
            catch (NoSuchFieldException | SecurityException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static void chunkUpdateCallback(int chunkX, int chunkZ) {
        XaeroMinimapCore.ensureField();
        class_638 world = class_310.method_1551().field_1687;
        if (world != null) {
            try {
                for (int x = chunkX - 1; x < chunkX + 2; ++x) {
                    for (int z = chunkZ - 1; z < chunkZ + 2; ++z) {
                        class_2818 chunk = world.method_8497(x, z);
                        if (chunk == null) continue;
                        chunkCleanField.set(chunk, false);
                    }
                }
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static void onChunkData(class_2672 packetIn) {
        XaeroMinimapCore.chunkUpdateCallback(packetIn.method_11523(), packetIn.method_11524());
    }

    public static void onBlockChange(class_2626 packetIn) {
        XaeroMinimapCore.chunkUpdateCallback(packetIn.method_11309().method_10263() >> 4, packetIn.method_11309().method_10260() >> 4);
    }

    public static void onMultiBlockChange(class_2637 packetIn) {
        MixinChunkDeltaUpdateS2CPacketAccessor packetAccess = (MixinChunkDeltaUpdateS2CPacketAccessor)packetIn;
        XaeroMinimapCore.chunkUpdateCallback(packetAccess.getSectionPos().method_10263(), packetAccess.getSectionPos().method_10260());
    }

    public static class_2960 getPlayerCape(class_742 player) {
        return Patreon5.getPlayerCape(modMain.getFileLayoutID(), player);
    }

    public static Boolean isWearing(class_1657 player, class_1664 part) {
        if (part != class_1664.field_7559 || !(player instanceof class_742)) {
            return null;
        }
        return Patreon5.isWearingCape(modMain.getFileLayoutID(), (class_742)player);
    }

    public static void onPlayNetHandler(class_634 netHandler) {
        try {
            XaeroMinimapSession minimapSession;
            IXaeroMinimapClientPlayNetHandler netHandlerAccess = (IXaeroMinimapClientPlayNetHandler)netHandler;
            if (netHandlerAccess.getXaero_minimapSession() != null) {
                return;
            }
            if (currentSession != null) {
                System.out.println("Previous minimap session still active. Probably using MenuMobs. Forcing it to end...");
                XaeroMinimapCore.cleanupCurrentSession();
            }
            currentSession = minimapSession = modMain.createSession();
            minimapSession.init();
            netHandlerAccess.setXaero_minimapSession(minimapSession);
        }
        catch (Throwable e) {
            if (currentSession != null) {
                XaeroMinimapCore.cleanupCurrentSession();
            }
            RuntimeException wrappedException = new RuntimeException("Exception initializing Xaero's Minimap! ", e);
            modMain.getInterfaces().getMinimapInterface().setCrashedWith(wrappedException);
            class_310.method_1551().field_1687.method_8525();
        }
    }

    private static void cleanupCurrentSession() {
        try {
            currentSession.cleanup();
        }
        catch (Throwable supressed) {
            supressed.printStackTrace();
        }
        finally {
            currentSession = null;
        }
    }

    public static void onPlayNetHandlerCleanup(class_634 netHandler) {
        try {
            XaeroMinimapSession netHandlerSession = ((IXaeroMinimapClientPlayNetHandler)netHandler).getXaero_minimapSession();
            if (netHandlerSession == null) {
                return;
            }
            try {
                netHandlerSession.cleanup();
            }
            finally {
                if (netHandlerSession == currentSession) {
                    currentSession = null;
                }
                ((IXaeroMinimapClientPlayNetHandler)netHandler).setXaero_minimapSession(null);
            }
        }
        catch (Throwable e) {
            RuntimeException wrappedException = new RuntimeException("Exception finalizing Xaero's Minimap! ", e);
            modMain.getInterfaces().getMinimapInterface().setCrashedWith(wrappedException);
        }
    }

    public static void beforeRespawn(class_1657 player) {
        if (player == class_310.method_1551().field_1724) {
            XaeroMinimapSession minimapSession = XaeroMinimapSession.getCurrentSession();
            minimapSession.getWaypointsManager().createDeathpoint(player);
        }
    }

    static {
        chunkCleanField = null;
    }
}

