/*
 * Decompiled with CFR 0.152.
 */
package xaero.common.events;

import com.mojang.blaze3d.systems.RenderSystem;
import java.io.IOException;
import java.lang.reflect.Field;
import net.minecraft.class_1041;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_2635;
import net.minecraft.class_310;
import net.minecraft.class_3675;
import net.minecraft.class_429;
import net.minecraft.class_437;
import net.minecraft.class_4398;
import net.minecraft.class_442;
import net.minecraft.class_4439;
import net.minecraft.class_4587;
import net.minecraft.class_4877;
import net.minecraft.class_500;
import net.minecraft.class_638;
import xaero.common.AXaeroMinimap;
import xaero.common.XaeroMinimapSession;
import xaero.common.anim.OldAnimation;
import xaero.common.gui.GuiEditMode;
import xaero.common.gui.GuiWidgetUpdateAll;
import xaero.common.settings.ModSettings;
import xaero.patreon.Patreon5;

public class ForgeEventHandler {
    private AXaeroMinimap modMain;
    private class_437 lastGuiOpen;
    private Field realmsTaskField;
    private Field realmsTaskServerField;
    private boolean crosshairDisabledByThisMod = false;
    public static boolean renderCrosshairs = true;
    public class_4877 latestRealm;

    public ForgeEventHandler(AXaeroMinimap modMain) {
        this.modMain = modMain;
    }

    public class_437 handleGuiOpen(class_437 gui) {
        if (gui != null && gui.getClass() == class_429.class) {
            if (!ModSettings.settingsButton) {
                return gui;
            }
            gui = this.modMain.getGuiHelper().getMyOptions();
            try {
                this.modMain.getSettings().saveSettings();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (gui instanceof class_442 || gui instanceof class_500) {
            this.modMain.getSettings().resetServerSettings();
        }
        if (gui instanceof class_4398) {
            try {
                class_4439 realmsTask;
                class_4877 realm;
                class_4398 realmsTaskScreen;
                Object task;
                if (this.realmsTaskField == null) {
                    try {
                        this.realmsTaskField = class_4398.class.getDeclaredField("field_19919");
                    }
                    catch (NoSuchFieldException nsfe) {
                        this.realmsTaskField = class_4398.class.getDeclaredField("task");
                    }
                    this.realmsTaskField.setAccessible(true);
                }
                if (this.realmsTaskServerField == null) {
                    try {
                        this.realmsTaskServerField = class_4439.class.getDeclaredField("field_20224");
                    }
                    catch (NoSuchFieldException nsfe) {
                        this.realmsTaskServerField = class_4439.class.getDeclaredField("server");
                    }
                    this.realmsTaskServerField.setAccessible(true);
                }
                if ((task = this.realmsTaskField.get(realmsTaskScreen = (class_4398)gui)) instanceof class_4439 && (realm = (class_4877)this.realmsTaskServerField.get(realmsTask = (class_4439)task)) != null && (this.latestRealm == null || realm.field_22599 != this.latestRealm.field_22599)) {
                    this.latestRealm = realm;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.lastGuiOpen = gui;
        return gui;
    }

    public boolean handleRenderStatusEffectOverlay(class_4587 matrixStack) {
        return false;
    }

    protected void handleRenderGameOverlayEventPreOverridable(class_4587 matrixStack, float partialTicks) {
        class_1041 mainwindow = class_310.method_1551().method_22683();
        RenderSystem.clear((int)256, (boolean)class_310.field_1703);
        RenderSystem.matrixMode((int)5889);
        RenderSystem.loadIdentity();
        RenderSystem.ortho((double)0.0, (double)((double)mainwindow.method_4489() / mainwindow.method_4495()), (double)((double)mainwindow.method_4506() / mainwindow.method_4495()), (double)0.0, (double)1000.0, (double)3000.0);
        RenderSystem.matrixMode((int)5888);
        RenderSystem.loadIdentity();
        RenderSystem.translatef((float)0.0f, (float)0.0f, (float)-2000.0f);
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        XaeroMinimapSession minimapSession = XaeroMinimapSession.getCurrentSession();
        if (minimapSession != null) {
            this.modMain.getInterfaceRenderer().renderInterfaces(minimapSession, matrixStack, partialTicks);
            this.modMain.getInterfaces().getMinimapInterface().getWaypointsGuiRenderer().drawSetChange(minimapSession.getWaypointsManager(), matrixStack, class_310.method_1551().method_22683());
            if (renderCrosshairs && minimapSession.getMinimapProcessor().isEnlargedMap() && this.modMain.getSettings().centeredEnlarged) {
                renderCrosshairs = false;
                this.crosshairDisabledByThisMod = true;
            }
        }
        OldAnimation.tick();
    }

    public void handleRenderGameOverlayEventPre(class_4587 matrixStack, float partialTicks) {
        if (class_3675.method_15987((long)class_310.method_1551().method_22683().method_4490(), (int)256)) {
            GuiEditMode.cancel(this.modMain.getInterfaces());
        }
        this.handleRenderGameOverlayEventPreOverridable(matrixStack, partialTicks);
    }

    public void handleRenderGameOverlayEventPost() {
        if (this.crosshairDisabledByThisMod) {
            renderCrosshairs = true;
            this.crosshairDisabledByThisMod = false;
        }
    }

    public String handleClientSendChatEvent(String message) {
        if (message.startsWith("xaero_waypoint_add:")) {
            String[] args = message.split(":");
            message = "";
            XaeroMinimapSession minimapSession = XaeroMinimapSession.getCurrentSession();
            minimapSession.getWaypointSharing().onWaypointAdd(args);
        } else if (message.equals("/xaero_tp_anyway")) {
            message = "";
            XaeroMinimapSession minimapSession = XaeroMinimapSession.getCurrentSession();
            minimapSession.getWaypointsManager().teleportAnyway();
        }
        return message;
    }

    public void handleClientChatReceivedEvent(class_2635 e) {
        if (e.method_11388() == null) {
            return;
        }
        class_2561 text = e.method_11388();
        String textString = text.getString();
        if (textString.contains("xaero_waypoint:") || textString.contains("xaero-waypoint:")) {
            XaeroMinimapSession minimapSession = XaeroMinimapSession.getCurrentSession();
            minimapSession.getWaypointSharing().onWaypointReceived(textString, e);
        }
    }

    public void handleRenderWorldLastEvent(class_4587 matrixStack, float partialTicks) {
        XaeroMinimapSession minimapSession = XaeroMinimapSession.getCurrentSession();
        if (minimapSession != null && class_310.method_1551().field_1687 == minimapSession.getMinimapProcessor().mainWorld) {
            this.modMain.getInterfaces().getMinimapInterface().getWaypointsIngameRenderer().render(minimapSession, partialTicks);
        }
    }

    public void handleDrawScreenEventPost(class_437 gui) {
        if (Patreon5.needsNotification() && gui instanceof class_442) {
            class_310.method_1551().method_1507((class_437)new GuiWidgetUpdateAll(this.modMain));
        } else if (this.modMain.isOutdated()) {
            this.modMain.setOutdated(false);
        }
    }

    public void handlePlayerSetSpawnEvent(class_2338 newSpawnPoint, class_1937 world) {
        XaeroMinimapSession minimapSession;
        if (world instanceof class_638 && (minimapSession = XaeroMinimapSession.getCurrentSession()) != null) {
            minimapSession.getWaypointsManager().setCurrentSpawn(newSpawnPoint, (class_638)world);
        }
    }

    public Object getLastGuiOpen() {
        return this.lastGuiOpen;
    }
}

