/*
 * Decompiled with CFR 0.152.
 */
package xaero.common.gui;

import net.minecraft.class_1074;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_4587;
import xaero.common.gui.IDropDownCallback;

public class GuiDropDown
extends class_332 {
    public static final int background = -939524096;
    public static final int selectedBackground = -922757376;
    public static final int selectedHoveredBackground = -10496;
    public static final int trim = -6250336;
    public static final int trimInside = -13487566;
    private static final int h = 11;
    private int x;
    private int y;
    private int xOffset = 0;
    private int yOffset = 0;
    private int w;
    private String[] realOptions = new String[0];
    private String[] options = new String[0];
    private int selected = 0;
    private boolean closed = true;
    private int scroll;
    private long scrollTime;
    private int autoScrolling;
    private IDropDownCallback callback;

    public GuiDropDown(String[] options, int x, int y, int w, Integer selected, IDropDownCallback callback) {
        this.x = x;
        this.y = y;
        this.w = w;
        this.realOptions = options;
        this.callback = callback;
        this.options = new String[this.realOptions.length + 1];
        System.arraycopy(this.realOptions, 0, this.options, 1, this.realOptions.length);
        this.selectId(selected, false);
    }

    public int size() {
        return this.realOptions.length;
    }

    public int getXWithOffset() {
        return this.x + this.xOffset;
    }

    public int getYWithOffset() {
        return this.y + this.yOffset;
    }

    private void drawSlot(class_4587 matrixStack, String text, int slotIndex, int pos, int mouseX, int mouseY, int scaledHeight) {
        int slotBackground;
        if (this.closed && this.onDropDown(mouseX, mouseY, scaledHeight) || !this.closed && this.onDropDownSlot(mouseX, mouseY, pos)) {
            slotBackground = slotIndex - 1 == this.selected ? -10496 : -13487566;
            GuiDropDown.method_25294((class_4587)matrixStack, (int)this.getXWithOffset(), (int)(this.getYWithOffset() + 11 * pos), (int)(this.getXWithOffset() + this.w), (int)(this.getYWithOffset() + 11 + 11 * pos), (int)slotBackground);
        } else {
            slotBackground = slotIndex - 1 == this.selected ? -922757376 : -939524096;
            GuiDropDown.method_25294((class_4587)matrixStack, (int)this.getXWithOffset(), (int)(this.getYWithOffset() + 11 * pos), (int)(this.getXWithOffset() + this.w), (int)(this.getYWithOffset() + 11 + 11 * pos), (int)slotBackground);
        }
        this.method_25292(matrixStack, this.getXWithOffset() + 1, this.getXWithOffset() + this.w - 1, this.getYWithOffset() + 11 * pos, -13487566);
        int textWidth = class_310.method_1551().field_1772.method_1727(text);
        boolean shortened = false;
        while (textWidth > this.w - 2) {
            text = text.substring(1);
            textWidth = class_310.method_1551().field_1772.method_1727("..." + text);
            shortened = true;
        }
        if (shortened) {
            text = "..." + text;
        }
        int textColor = 0xFFFFFF;
        GuiDropDown.method_25300((class_4587)matrixStack, (class_327)class_310.method_1551().field_1772, (String)text, (int)(this.getXWithOffset() + this.w / 2), (int)(this.getYWithOffset() + 2 + 11 * pos), (int)textColor);
    }

    private void drawMenu(class_4587 matrixStack, int amount, int mouseX, int mouseY, int scaledHeight) {
        int first;
        boolean scrolling = this.scrolling(scaledHeight);
        int totalH = 11 * (amount + (scrolling ? 2 : 0));
        int height = scaledHeight;
        this.yOffset = this.y + totalH + 1 > height ? height - this.y - totalH - 1 : 0;
        int n = first = this.closed ? 0 : this.scroll;
        if (scrolling) {
            this.drawSlot(matrixStack, (this.scroll == 0 ? "\u00a78" : "\u00a77") + class_1074.method_4662((String)"gui.xaero_up", (Object[])new Object[0]), -1, 0, mouseX, mouseY, scaledHeight);
            this.drawSlot(matrixStack, (this.scroll + this.optionLimit(scaledHeight) >= this.options.length ? "\u00a78" : "\u00a77") + class_1074.method_4662((String)"gui.xaero_down", (Object[])new Object[0]), -1, amount + 1, mouseX, mouseY, scaledHeight);
        }
        for (int i = first; i < first + amount; ++i) {
            String slotText = i == 0 ? (!this.closed ? "-" : class_1074.method_4662((String)this.realOptions[this.selected], (Object[])new Object[0]).replace("\u00a7\u00a7", ":")) : class_1074.method_4662((String)this.options[i], (Object[])new Object[0]).replace("\u00a7\u00a7", ":");
            this.drawSlot(matrixStack, slotText, i, i - first + (scrolling ? 1 : 0), mouseX, mouseY, scaledHeight);
        }
        this.method_25301(matrixStack, this.getXWithOffset(), this.getYWithOffset(), this.getYWithOffset() + totalH, -6250336);
        this.method_25301(matrixStack, this.getXWithOffset() + this.w, this.getYWithOffset(), this.getYWithOffset() + totalH, -6250336);
        this.method_25292(matrixStack, this.getXWithOffset(), this.getXWithOffset() + this.w, this.getYWithOffset(), -6250336);
        this.method_25292(matrixStack, this.getXWithOffset(), this.getXWithOffset() + this.w, this.getYWithOffset() + totalH, -6250336);
    }

    private boolean scrolling(int scaledHeight) {
        return this.options.length > this.optionLimit(scaledHeight) && !this.closed;
    }

    public void mouseClicked(int mouseX, int mouseY, int mouseButton, int scaledHeight) {
        if (!this.closed) {
            int clickedId = this.getClickedId(mouseX, mouseY, scaledHeight);
            if (clickedId >= 0) {
                this.selectId(clickedId - 1, true);
            } else {
                this.autoScrolling = clickedId == -1 ? 1 : -1;
                this.scrollTime = System.currentTimeMillis();
                this.mouseScrolled(this.autoScrolling, mouseX, mouseY, scaledHeight);
            }
        } else if (this.options.length > 1) {
            this.closed = false;
            this.scroll = 0;
        }
    }

    public void mouseReleased(int mouseX, int mouseY, int mouseButton, int scaledHeight) {
        this.autoScrolling = 0;
    }

    private int getClickedId(int mouseX, int mouseY, int scaledHeight) {
        int yOnMenu = mouseY - this.getYWithOffset();
        int visibleSlotIndex = yOnMenu / 11;
        boolean upArrow = this.scrolling(scaledHeight);
        if (upArrow && visibleSlotIndex == 0) {
            return -1;
        }
        if (visibleSlotIndex >= this.optionLimit(scaledHeight) + (upArrow ? 1 : 0)) {
            return -2;
        }
        int slot = this.scroll + visibleSlotIndex - (upArrow ? 1 : 0);
        if (slot >= this.options.length) {
            slot = this.options.length - 1;
        }
        return slot;
    }

    public boolean onDropDown(int mouseX, int mouseY, int scaledHeight) {
        int xOnMenu = mouseX - this.getXWithOffset();
        int yOnMenu = mouseY - this.getYWithOffset();
        return xOnMenu >= 0 && yOnMenu >= 0 && xOnMenu <= this.w && yOnMenu < (this.closed ? 11 : (Math.min(this.options.length, this.optionLimit(scaledHeight)) + (this.scrolling(scaledHeight) ? 2 : 0)) * 11);
    }

    private boolean onDropDownSlot(int mouseX, int mouseY, int id) {
        int xOnMenu = mouseX - this.getXWithOffset();
        int yOnMenu = mouseY - this.getYWithOffset();
        return xOnMenu >= 0 && yOnMenu >= id * 11 && xOnMenu <= this.w && yOnMenu < id * 11 + 11;
    }

    public void selectId(int id, boolean callCallback) {
        boolean newId;
        if (id == -1) {
            this.closed = true;
            return;
        }
        boolean bl = newId = id != this.selected;
        if (newId && (!callCallback || this.callback.onSelected(this, id))) {
            this.selected = id;
        }
        this.closed = true;
    }

    public void drawButton(class_4587 matrixStack, int mouseX, int mouseY, int scaledHeight) {
        if (this.autoScrolling != 0 && System.currentTimeMillis() - this.scrollTime > 100L) {
            this.scrollTime = System.currentTimeMillis();
            this.mouseScrolled(this.autoScrolling, mouseX, mouseY, scaledHeight);
        }
        this.drawMenu(matrixStack, this.closed ? 1 : Math.min(this.optionLimit(scaledHeight), this.options.length), mouseX, mouseY, scaledHeight);
    }

    public boolean isClosed() {
        return this.closed;
    }

    public void setClosed(boolean closed) {
        this.closed = closed;
    }

    public void mouseScrolled(int wheel, int mouseXScaled, int mouseYScaled, int scaledHeight) {
        int newScroll = this.scroll - wheel;
        int optionLimit = this.optionLimit(scaledHeight);
        if (newScroll + optionLimit > this.options.length) {
            newScroll = this.options.length - optionLimit;
        }
        if (newScroll < 0) {
            newScroll = 0;
        }
        this.scroll = newScroll;
    }

    private int optionLimit(int scaledHeight) {
        return Math.max(1, scaledHeight / 11 - 2);
    }

    public int getSelected() {
        return this.selected;
    }
}

