/*
 * Decompiled with CFR 0.152.
 */
package xaero.common.minimap;

import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_638;
import net.minecraft.class_746;
import org.lwjgl.opengl.GL;
import xaero.common.AXaeroMinimap;
import xaero.common.XaeroMinimapSession;
import xaero.common.anim.OldAnimation;
import xaero.common.minimap.MinimapInterface;
import xaero.common.minimap.MinimapRadar;
import xaero.common.minimap.write.MinimapWriter;
import xaero.common.settings.ModSettings;

public class MinimapProcessor {
    public static final boolean DEBUG = false;
    public static final int FRAME = 9;
    private static final double log128 = Math.log(128.0);
    private AXaeroMinimap modMain;
    private XaeroMinimapSession minimapSession;
    private MinimapWriter minimapWriter;
    private MinimapRadar entityRadar;
    private MinimapInterface minimapInterface;
    private double minimapZoom;
    private boolean toResetImage;
    private boolean enlargedMap = false;
    public final Object mainStuffSync;
    public class_1937 mainWorld;
    public double mainPlayerX;
    public double mainPlayerY;
    public double mainPlayerZ;

    public MinimapProcessor(AXaeroMinimap modMain, XaeroMinimapSession minimapSession, MinimapWriter minimapWriter, MinimapRadar entityRadar) {
        this.modMain = modMain;
        this.minimapSession = minimapSession;
        this.minimapWriter = minimapWriter;
        this.entityRadar = entityRadar;
        this.minimapZoom = 1.0;
        this.toResetImage = true;
        this.mainStuffSync = new Object();
        this.minimapInterface = modMain.getInterfaces().getMinimapInterface();
    }

    public int getMinimapSize() {
        return this.enlargedMap ? 500 : this.modMain.getSettings().getMinimapSize() * 2;
    }

    public int getMinimapBufferSize(int minimapSize) {
        double diagonal = Math.sqrt(2.0) * (double)minimapSize;
        int bufferSize = (int)Math.pow(128.0, Math.ceil(Math.log(diagonal) / log128));
        if (bufferSize > 512) {
            return 512;
        }
        return bufferSize;
    }

    public boolean isEnlargedMap() {
        return this.enlargedMap;
    }

    public void setEnlargedMap(boolean enlargedMap) {
        this.enlargedMap = enlargedMap;
    }

    public double getMinimapZoom() {
        return this.minimapZoom;
    }

    private double getTargetZoom() {
        float target;
        float settingsZoom = this.modMain.getSettings().zooms[this.modMain.getSettings().zoom];
        if (this.enlargedMap && this.modMain.getSettings().zoomedOutEnlarged) {
            settingsZoom = 1.0f;
        }
        if ((target = settingsZoom * (this.modMain.getSettings().caveZoom > 0 && this.minimapWriter.getLoadedCaving() != -1 ? (float)(1 + this.modMain.getSettings().caveZoom) : 1.0f)) > this.modMain.getSettings().zooms[this.modMain.getSettings().zooms.length - 1]) {
            target = this.modMain.getSettings().zooms[this.modMain.getSettings().zooms.length - 1];
        }
        return target;
    }

    public void instantZoom() {
        this.minimapZoom = this.getTargetZoom();
    }

    public void updateZoom() {
        double target = this.getTargetZoom();
        double off = target - this.minimapZoom;
        off = off > 0.01 || off < -0.01 ? (double)((float)OldAnimation.animate(off, 0.8)) : 0.0;
        this.minimapZoom = target - off;
    }

    public MinimapWriter getMinimapWriter() {
        return this.minimapWriter;
    }

    public boolean canUseFrameBuffer() {
        return !(!GL.getCapabilities().OpenGL14 || !GL.getCapabilities().GL_ARB_framebuffer_object && !GL.getCapabilities().GL_EXT_framebuffer_object && !GL.getCapabilities().OpenGL30 || !GL.getCapabilities().OpenGL15 && !GL.getCapabilities().GL_ARB_vertex_buffer_object || !GL.getCapabilities().OpenGL21 && !GL.getCapabilities().GL_EXT_pixel_buffer_object && !GL.getCapabilities().GL_ARB_pixel_buffer_object);
    }

    public int getFBOBufferSize() {
        return 512;
    }

    public void onClientTick() {
        class_1937 world = null;
        class_746 player = class_310.method_1551().field_1724;
        if (player != null) {
            world = player.field_6002;
        }
        if (world != null && player != null && this.modMain.getSettings().getMinimap()) {
            this.entityRadar.updateRadar((class_638)world, (class_1657)player, class_310.method_1551().method_1560());
        }
    }

    public void onPlayerTick() {
        if (this.minimapSession.getWaypointsManager().getCurrentContainerID() != null && this.minimapSession.getWaypointsManager().getCurrentWorldID() != null) {
            this.minimapWriter.setSeedForLoading(this.modMain.getSettings().getSlimeChunksSeed(this.minimapSession.getWaypointsManager().getCurrentContainerAndWorldID()));
        }
    }

    public void onRender(class_4587 matrixStack, int x, int y, int width, int height, double scale, int size, int boxSize, float partial) {
        try {
            if (this.minimapInterface.getMinimapFBORenderer().isLoadedFBO() && !this.canUseFrameBuffer()) {
                this.minimapInterface.getMinimapFBORenderer().setLoadedFBO(false);
                this.minimapInterface.getMinimapFBORenderer().deleteFramebuffers();
                this.toResetImage = true;
            }
            if (!(this.minimapInterface.getMinimapFBORenderer().isLoadedFBO() || this.modMain.getSettings().mapSafeMode || this.minimapInterface.getMinimapFBORenderer().isTriedFBO())) {
                this.minimapInterface.getMinimapFBORenderer().loadFrameBuffer(this);
            }
            if (this.enlargedMap && this.modMain.getSettings().centeredEnlarged) {
                x = (width - boxSize) / 2;
                y = (height - boxSize) / 2;
            }
            if (this.minimapInterface.usingFBO()) {
                this.minimapInterface.getMinimapFBORenderer().renderMinimap(this.minimapSession, matrixStack, this, x, y, width, height, scale, size, partial);
            } else {
                this.minimapInterface.getMinimapSafeModeRenderer().renderMinimap(this.minimapSession, matrixStack, this, x, y, width, height, scale, size, partial);
            }
        }
        catch (Throwable e) {
            this.minimapInterface.setCrashedWith(e);
            this.minimapInterface.checkCrashes();
        }
    }

    public static boolean hasMinimapItem(class_1657 player) {
        for (int i = 0; i < 9; ++i) {
            if (player.field_7514.field_7547.get(i) == null || ((class_1799)player.field_7514.field_7547.get(i)).method_7909() != ModSettings.minimapItem) continue;
            return true;
        }
        return false;
    }

    public boolean isToResetImage() {
        return this.toResetImage;
    }

    public void setToResetImage(boolean toResetImage) {
        this.toResetImage = toResetImage;
    }

    public MinimapRadar getEntityRadar() {
        return this.entityRadar;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMainValues() {
        Object object = this.mainStuffSync;
        synchronized (object) {
            class_1297 player = class_310.method_1551().method_1560();
            if (player != null) {
                this.mainWorld = player.field_6002;
                this.mainPlayerX = player.method_23317();
                this.mainPlayerY = player.method_23318();
                this.mainPlayerZ = player.method_23321();
            } else {
                this.mainWorld = null;
            }
        }
    }

    public void cleanup() {
        this.minimapWriter.cleanup();
    }
}

