/*
 * Decompiled with CFR 0.152.
 */
package xaero.common.minimap.render;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Iterator;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1664;
import net.minecraft.class_308;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_4493;
import net.minecraft.class_4587;
import net.minecraft.class_742;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL14;
import xaero.common.AXaeroMinimap;
import xaero.common.XaeroMinimapSession;
import xaero.common.graphics.ImprovedFramebuffer;
import xaero.common.interfaces.render.InterfaceRenderer;
import xaero.common.minimap.MinimapInterface;
import xaero.common.minimap.MinimapProcessor;
import xaero.common.minimap.MinimapRadar;
import xaero.common.minimap.region.MinimapChunk;
import xaero.common.minimap.render.MinimapRenderer;
import xaero.common.minimap.render.radar.EntityIconManager;
import xaero.common.minimap.render.radar.EntityIconPrerenderer;
import xaero.common.minimap.waypoints.render.WaypointsGuiRenderer;
import xaero.common.minimap.write.MinimapWriter;
import xaero.common.misc.Misc;
import xaero.common.misc.OptimizedMath;
import xaero.common.settings.ModSettings;

public class MinimapFBORenderer
extends MinimapRenderer {
    private ImprovedFramebuffer scalingFramebuffer;
    private ImprovedFramebuffer rotationFramebuffer;
    private EntityIconManager entityIconManager;
    private boolean triedFBO;
    private boolean loadedFBO;

    public MinimapFBORenderer(AXaeroMinimap modMain, class_310 mc, WaypointsGuiRenderer waypointsGuiRenderer, MinimapInterface minimapInterface) {
        super(modMain, mc, waypointsGuiRenderer, minimapInterface);
    }

    public void loadFrameBuffer(MinimapProcessor minimapProcessor) {
        if (!minimapProcessor.canUseFrameBuffer()) {
            System.out.println("FBO mode not supported! Using minimap safe mode.");
        } else {
            this.scalingFramebuffer = new ImprovedFramebuffer(512, 512, false);
            this.rotationFramebuffer = new ImprovedFramebuffer(512, 512, false);
            this.rotationFramebuffer.method_1232(9729);
            this.loadedFBO = this.scalingFramebuffer.field_1476 != -1 && this.rotationFramebuffer.field_1476 != -1;
            this.entityIconManager = new EntityIconManager(new EntityIconPrerenderer());
        }
        this.triedFBO = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void renderChunks(XaeroMinimapSession minimapSession, class_4587 matrixStack, MinimapProcessor minimap, int mapSize, int bufferSize, float sizeFix, float partial, int lightLevel, boolean useWorldMap, boolean lockedNorth) {
        MinimapWriter minimapWriter = minimap.getMinimapWriter();
        synchronized (minimapWriter) {
            this.renderChunksToFBO(minimapSession, matrixStack, minimap, (class_1657)this.mc.field_1724, this.mc.method_1560(), bufferSize, mapSize, sizeFix, partial, lightLevel, true, useWorldMap, lockedNorth);
        }
        class_310.method_1551().method_1522().method_1235(false);
        class_4493.method_22025((int)0, (int)0, (int)class_310.method_1551().method_1522().field_1480, (int)class_310.method_1551().method_1522().field_1477);
        this.rotationFramebuffer.method_1241();
    }

    public void renderChunksToFBO(XaeroMinimapSession minimapSession, class_4587 matrixStack, MinimapProcessor minimap, class_1657 player, class_1297 renderEntity, int bufferSize, int viewW, float sizeFix, float partial, int level, boolean retryIfError, boolean useWorldMap, boolean lockedNorth) {
        double zInsidePixel;
        double maxVisibleLength = lockedNorth ? (double)viewW : (double)viewW * Math.sqrt(2.0);
        int radius = (int)Math.ceil(maxVisibleLength / 2.0 / this.zoom / 64.0);
        double playerX = minimap.getEntityRadar().getEntityX(renderEntity, partial);
        double playerZ = minimap.getEntityRadar().getEntityZ(renderEntity, partial);
        int xFloored = OptimizedMath.myFloor(playerX);
        int zFloored = OptimizedMath.myFloor(playerZ);
        int playerChunkX = xFloored >> 6;
        int playerChunkZ = zFloored >> 6;
        int offsetX = xFloored & 0x3F;
        int offsetZ = zFloored & 0x3F;
        boolean zooming = (double)((int)this.zoom) != this.zoom;
        this.scalingFramebuffer.method_1235(true);
        GL11.glClear((int)16640);
        class_4493.method_21910();
        class_308.method_1450();
        long before = System.currentTimeMillis();
        class_4493.method_21965((int)256, (boolean)class_310.field_1703);
        RenderSystem.matrixMode((int)5889);
        RenderSystem.pushMatrix();
        RenderSystem.loadIdentity();
        RenderSystem.ortho((double)0.0, (double)512.0, (double)512.0, (double)0.0, (double)1000.0, (double)3000.0);
        RenderSystem.matrixMode((int)5888);
        RenderSystem.pushMatrix();
        RenderSystem.loadIdentity();
        before = System.currentTimeMillis();
        double xInsidePixel = minimap.getEntityRadar().getEntityX(renderEntity, partial) - (double)xFloored;
        if (xInsidePixel < 0.0) {
            xInsidePixel += 1.0;
        }
        if ((zInsidePixel = minimap.getEntityRadar().getEntityZ(renderEntity, partial) - (double)zFloored) < 0.0) {
            zInsidePixel += 1.0;
        }
        float halfWView = (float)viewW / 2.0f;
        float angle = (float)(90.0 - this.getRenderAngle(renderEntity, lockedNorth, partial));
        RenderSystem.enableBlend();
        RenderSystem.translatef((float)256.0f, (float)256.0f, (float)-2000.0f);
        RenderSystem.scaled((double)this.zoom, (double)this.zoom, (double)1.0);
        class_332.method_25294((class_4587)matrixStack, (int)-256, (int)-256, (int)256, (int)256, (int)-16777216);
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (useWorldMap) {
            this.modMain.getSupportMods().worldmapSupport.drawMinimap(minimapSession, matrixStack, this.helper, xFloored, zFloored, radius, zooming, this.zoom);
        } else if (minimap.getMinimapWriter().getLoadedBlocks() != null && level >= 0) {
            int minX = playerChunkX - radius;
            int minZ = playerChunkZ - radius;
            int maxX = playerChunkX + radius + 1;
            int maxZ = playerChunkZ + radius + 1;
            for (int X = minX; X <= maxX; ++X) {
                int canvasX = X - minimap.getMinimapWriter().getLoadedMapChunkX();
                if (canvasX < 0 || canvasX >= minimap.getMinimapWriter().getLoadedBlocks().length) continue;
                for (int Z = minZ; Z <= maxZ; ++Z) {
                    MinimapChunk mchunk;
                    int canvasZ = Z - minimap.getMinimapWriter().getLoadedMapChunkZ();
                    if (canvasZ < 0 || canvasZ >= minimap.getMinimapWriter().getLoadedBlocks().length || (mchunk = minimap.getMinimapWriter().getLoadedBlocks()[canvasX][canvasZ]) == null) continue;
                    mchunk.bindTexture(level);
                    if (!mchunk.isHasSomething() || level >= mchunk.getLevelsBuffered() || mchunk.getGlTexture(level) == 0) continue;
                    if (!zooming) {
                        GL11.glTexParameteri((int)3553, (int)10240, (int)9728);
                    } else {
                        GL11.glTexParameteri((int)3553, (int)10240, (int)9729);
                    }
                    int drawX = (mchunk.getX() - playerChunkX) * 64 - offsetX;
                    int drawZ = (mchunk.getZ() - playerChunkZ) * 64 - offsetZ;
                    RenderSystem.enableBlend();
                    GL14.glBlendFuncSeparate((int)770, (int)771, (int)1, (int)771);
                    this.helper.drawMyTexturedModalRect(drawX, drawZ, 0, 64, 64.0f, 64.0f, -64.0f, 64.0f);
                    GL11.glTexParameteri((int)3553, (int)10240, (int)9728);
                    int r = 0;
                    int g = 0;
                    int b = 0;
                    if (this.modMain.getSettings().chunkGrid > -1) {
                        int grid = ModSettings.COLORS[this.modMain.getSettings().chunkGrid];
                        r = grid >> 16 & 0xFF;
                        g = grid >> 8 & 0xFF;
                        b = grid & 0xFF;
                    }
                    for (int t = 0; t < 16; ++t) {
                        if (mchunk.getTile(t % 4, t / 4) == null || !this.modMain.getSettings().getSlimeChunks(minimapSession.getWaypointsManager()) || !mchunk.getTile(t % 4, t / 4).isSlimeChunk()) continue;
                        int slimeDrawX = drawX + 16 * (t % 4);
                        int slimeDrawZ = drawZ + 16 * (t / 4);
                        class_332.method_25294((class_4587)matrixStack, (int)slimeDrawX, (int)slimeDrawZ, (int)(slimeDrawX + 16), (int)(slimeDrawZ + 16), (int)-2142047936);
                    }
                    if (this.modMain.getSettings().chunkGrid > -1) {
                        float top;
                        RenderSystem.disableTexture();
                        RenderSystem.enableBlend();
                        RenderSystem.pushMatrix();
                        RenderSystem.translatef((float)(drawX + 64), (float)(drawZ + 64), (float)0.0f);
                        RenderSystem.scaled((double)(1.0 / this.zoom), (double)(1.0 / this.zoom), (double)1.0);
                        RenderSystem.color4f((float)((float)r / 255.0f), (float)((float)g / 255.0f), (float)((float)b / 255.0f), (float)0.5f);
                        float left = top = (float)(-64.0 * this.zoom);
                        this.helper.drawMyColoredRect(left, -1.0f, 0.0f, 0.0f);
                        this.helper.drawMyColoredRect(left, (float)(-16.0 * this.zoom) - 1.0f, 0.0f, (float)(-16.0 * this.zoom));
                        this.helper.drawMyColoredRect(left, (float)(-32.0 * this.zoom) - 1.0f, 0.0f, (float)(-32.0 * this.zoom));
                        this.helper.drawMyColoredRect(left, (float)(-48.0 * this.zoom) - 1.0f, 0.0f, (float)(-48.0 * this.zoom));
                        this.helper.drawMyColoredRect(-1.0f, top, 0.0f, 0.0f);
                        this.helper.drawMyColoredRect((float)(-16.0 * this.zoom) - 1.0f, top, (float)(-16.0 * this.zoom), 0.0f);
                        this.helper.drawMyColoredRect((float)(-32.0 * this.zoom) - 1.0f, top, (float)(-32.0 * this.zoom), 0.0f);
                        this.helper.drawMyColoredRect((float)(-48.0 * this.zoom) - 1.0f, top, (float)(-48.0 * this.zoom), 0.0f);
                        RenderSystem.popMatrix();
                        RenderSystem.disableBlend();
                        RenderSystem.enableTexture();
                    }
                    RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                }
            }
            GL14.glBlendFuncSeparate((int)770, (int)771, (int)1, (int)0);
        }
        this.scalingFramebuffer.method_1240();
        this.rotationFramebuffer.method_1235(false);
        GL11.glClear((int)16640);
        this.scalingFramebuffer.method_1241();
        RenderSystem.loadIdentity();
        if (this.modMain.getSettings().getAntiAliasing()) {
            GL11.glTexParameteri((int)3553, (int)10240, (int)9729);
            GL11.glTexParameteri((int)3553, (int)10241, (int)9729);
        } else {
            GL11.glTexParameteri((int)3553, (int)10240, (int)9728);
            GL11.glTexParameteri((int)3553, (int)10241, (int)9728);
        }
        RenderSystem.translatef((float)halfWView, (float)halfWView, (float)-2000.0f);
        if (!lockedNorth) {
            GL11.glRotatef((float)(-angle), (float)0.0f, (float)0.0f, (float)1.0f);
        }
        GL11.glPushMatrix();
        RenderSystem.translated((double)(-xInsidePixel * this.zoom), (double)(-zInsidePixel * this.zoom), (double)0.0);
        RenderSystem.disableBlend();
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)((float)(this.modMain.getSettings().minimapOpacity / 100.0)));
        this.helper.drawMyTexturedModalRect(-256.0f, -256.0f, 0, 0, 512.0f, 512.0f, 512.0f);
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glPopMatrix();
        before = System.currentTimeMillis();
        class_4493.method_22012();
        class_4493.method_21945((int)516, (float)1.0f);
        RenderSystem.disableBlend();
        RenderSystem.blendFuncSeparate((int)770, (int)771, (int)1, (int)1);
        class_4493.method_22001((int)519);
        class_4493.method_22001((int)515);
        class_4493.method_21974((boolean)false);
        class_4493.method_21974((boolean)true);
        class_4493.method_22081((int)1);
        class_4493.method_22081((int)0);
        this.mc.method_1531().method_22813(InterfaceRenderer.guiTextures);
        if (this.modMain.getSettings().getSmoothDots()) {
            GL11.glTexParameteri((int)3553, (int)10240, (int)9729);
            GL11.glTexParameteri((int)3553, (int)10241, (int)9729);
        } else {
            GL11.glTexParameteri((int)3553, (int)10240, (int)9728);
            GL11.glTexParameteri((int)3553, (int)10241, (int)9728);
        }
        class_4493.method_22021();
        class_4493.method_21945((int)516, (float)0.0f);
        RenderSystem.enableBlend();
        RenderSystem.blendFuncSeparate((int)770, (int)771, (int)1, (int)771);
        class_1657 p = player;
        ModSettings settings = this.modMain.getSettings();
        MinimapRadar minimapRadar = minimap.getEntityRadar();
        this.renderEntityListToFBO(matrixStack, minimap, p, renderEntity, minimapRadar.getEntitiesIterator(), angle, playerX, playerZ, partial, settings.otherNames, 0, minimapRadar, settings, lockedNorth);
        this.renderEntityListToFBO(matrixStack, minimap, p, renderEntity, minimapRadar.getItemsIterator(), angle, playerX, playerZ, partial, settings.itemNames, 0, minimapRadar, settings, lockedNorth);
        this.renderEntityListToFBO(matrixStack, minimap, p, renderEntity, minimapRadar.getLivingIterator(), angle, playerX, playerZ, partial, settings.friendlyMobNames, settings.mobIcons, minimapRadar, settings, lockedNorth);
        this.renderEntityListToFBO(matrixStack, minimap, p, renderEntity, minimapRadar.getHostileIterator(), angle, playerX, playerZ, partial, settings.hostileMobNames, settings.hostileIcons, minimapRadar, settings, lockedNorth);
        this.renderEntityListToFBO(matrixStack, minimap, p, renderEntity, minimapRadar.getLivingTamedIterator(), angle, playerX, playerZ, partial, settings.tamedMobNames, settings.tamedIcons, minimapRadar, settings, lockedNorth);
        this.renderEntityListToFBO(matrixStack, minimap, p, renderEntity, minimapRadar.getPlayersIterator(), angle, playerX, playerZ, partial, settings.playerNames, settings.playerIcons, minimapRadar, settings, lockedNorth);
        this.renderEntityListToFBO(matrixStack, minimap, p, renderEntity, minimapRadar.getPlayersOtherTeamsIterator(), angle, playerX, playerZ, partial, settings.otherTeamsNames == 3 ? settings.playerNames : settings.otherTeamsNames, settings.playerIcons, minimapRadar, settings, lockedNorth);
        this.mc.method_1531().method_22813(InterfaceRenderer.guiTextures);
        if (this.modMain.getSettings().mainEntityAs == 1) {
            this.renderEntityDotToFBO(matrixStack, minimap, p, renderEntity, renderEntity, angle, playerX, playerZ, partial, false, false, minimapRadar, lockedNorth);
        }
        GL11.glTexParameteri((int)3553, (int)10240, (int)9728);
        GL11.glTexParameteri((int)3553, (int)10241, (int)9728);
        class_4493.method_22012();
        RenderSystem.defaultAlphaFunc();
        this.rotationFramebuffer.method_1240();
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.disableBlend();
        RenderSystem.matrixMode((int)5889);
        GL11.glPopMatrix();
        RenderSystem.matrixMode((int)5888);
        GL11.glPopMatrix();
    }

    public void renderEntityListToFBO(class_4587 matrixStack, MinimapProcessor minimap, class_1657 p, class_1297 renderEntity, Iterator<class_1297> iter, float angle, double playerX, double playerZ, float partial, int names, int icons, MinimapRadar minimapRadar, ModSettings settings, boolean lockedNorth) {
        boolean iconsForList;
        boolean alwaysNameTags = this.modMain.getSettings().alwaysEntityNametags;
        boolean playerListPressed = this.mc.field_1690.field_1907.method_1434();
        boolean namesForList = names == 1 && playerListPressed || names == 2;
        boolean bl = iconsForList = icons == 1 && playerListPressed || icons == 2;
        while (iter.hasNext()) {
            int entityType;
            class_1297 e = iter.next();
            if (renderEntity == e) continue;
            boolean name = namesForList;
            boolean icon = iconsForList;
            if (names == 3) {
                entityType = minimapRadar.getType(e, p, true);
                int fallbackNames = 0;
                if (entityType == 2) {
                    fallbackNames = settings.hostileMobNames;
                } else if (entityType == 3) {
                    fallbackNames = settings.friendlyMobNames;
                }
                boolean bl2 = name = fallbackNames == 1 && playerListPressed || fallbackNames == 2;
            }
            if (icons == 3) {
                entityType = minimapRadar.getType(e, p, true);
                int fallbackIcons = 0;
                if (entityType == 2) {
                    fallbackIcons = settings.hostileIcons;
                } else if (entityType == 3) {
                    fallbackIcons = settings.mobIcons;
                }
                boolean bl3 = icon = fallbackIcons == 1 && playerListPressed || fallbackIcons == 2;
            }
            if (!(e instanceof class_1657)) {
                boolean bl4 = name = name || alwaysNameTags && e.method_16914();
            }
            if (icon && e instanceof class_742) {
                this.renderPlayerHeadToFBO(matrixStack, minimap, p, renderEntity, (class_742)e, angle, playerX, playerZ, partial, name, minimapRadar, lockedNorth);
                continue;
            }
            this.renderEntityDotToFBO(matrixStack, minimap, p, renderEntity, e, angle, playerX, playerZ, partial, name, icon, minimapRadar, lockedNorth);
        }
    }

    public void renderPlayerHeadToFBO(class_4587 matrixStack, MinimapProcessor minimap, class_1657 p, class_1297 renderEntity, class_742 e, float angle, double playerX, double playerZ, float partial, boolean name, MinimapRadar minimapRadar, boolean lockedNorth) {
        if (!minimapRadar.shouldRenderEntity((class_1297)e)) {
            return;
        }
        double offx = minimap.getEntityRadar().getEntityX((class_1297)e, partial) - playerX;
        double offz = minimap.getEntityRadar().getEntityZ((class_1297)e, partial) - playerZ;
        float offh = (float)(renderEntity.method_23318() - e.method_23318());
        RenderSystem.pushMatrix();
        RenderSystem.translated((double)(offx * this.zoom), (double)(offz * this.zoom), (double)0.0);
        if (!lockedNorth) {
            GL11.glRotatef((float)angle, (float)0.0f, (float)0.0f, (float)1.0f);
        }
        RenderSystem.scaled((double)2.0, (double)2.0, (double)1.0);
        float brightness = minimap.getEntityRadar().getEntityBrightness(offh);
        GL11.glColor3d((double)brightness, (double)brightness, (double)brightness);
        boolean flag1 = e != null && e.method_7348(class_1664.field_7559) && (e.method_7334().getName().equals("Dinnerbone") || e.method_7334().getName().equals("Grumm"));
        class_310.method_1551().method_1531().method_22813(e.method_3117());
        int l2 = 8 + (flag1 ? 8 : 0);
        int i3 = 8 * (flag1 ? -1 : 1);
        double headsScale = this.modMain.getSettings().headsScale;
        GL11.glScaled((double)headsScale, (double)headsScale, (double)1.0);
        class_332.method_25293((class_4587)matrixStack, (int)-4, (int)-4, (int)8, (int)8, (float)8.0f, (float)l2, (int)8, (int)i3, (int)64, (int)64);
        if (name) {
            RenderSystem.pushMatrix();
            RenderSystem.scaled((double)0.5, (double)0.5, (double)1.0);
            int color = minimap.getEntityRadar().getEntityColour(p, (class_1297)e, 0.0f);
            RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            String entityName = e.method_5476().getString();
            int nameW = this.mc.field_1772.method_1727(entityName);
            double dotNameScale = this.modMain.getSettings().dotNameScale;
            class_4493.method_21999((float)0.0f, (float)11.0f, (float)0.0f);
            GL11.glScaled((double)(dotNameScale / headsScale), (double)(dotNameScale / headsScale), (double)1.0);
            Misc.drawPiercingText(matrixStack, entityName.replaceAll("(\u00a7[0-9a-f])+", ""), (float)(-nameW / 2 + 1), 1.0f, -12566464, false);
            Misc.drawPiercingText(matrixStack, entityName, (float)(-nameW / 2), 0.0f, color, false);
            RenderSystem.enableBlend();
            RenderSystem.blendFuncSeparate((int)770, (int)771, (int)1, (int)771);
            RenderSystem.popMatrix();
        }
        if (e != null && e.method_7348(class_1664.field_7563)) {
            class_310.method_1551().method_1531().method_22813(e.method_3117());
            int j3 = 8 + (flag1 ? 8 : 0);
            int k3 = 8 * (flag1 ? -1 : 1);
            class_332.method_25293((class_4587)matrixStack, (int)-4, (int)-4, (int)8, (int)8, (float)40.0f, (float)j3, (int)8, (int)k3, (int)64, (int)64);
        }
        GL11.glPopMatrix();
    }

    public void renderEntityDotToFBO(class_4587 matrixStack, MinimapProcessor minimap, class_1657 p, class_1297 renderEntity, class_1297 e, float angle, double playerX, double playerZ, float partial, boolean name, boolean icon, MinimapRadar minimapRadar, boolean lockedNorth) {
        double dotsScale;
        int entityHeadTexture;
        if (!minimapRadar.shouldRenderEntity(e)) {
            return;
        }
        double offx = minimapRadar.getEntityX(e, partial) - playerX;
        double offz = minimapRadar.getEntityZ(e, partial) - playerZ;
        float offh = (float)(renderEntity.method_23318() - e.method_23318());
        GL11.glPushMatrix();
        RenderSystem.translated((double)(offx * this.zoom), (double)(offz * this.zoom), (double)0.0);
        if (!lockedNorth) {
            GL11.glRotatef((float)angle, (float)0.0f, (float)0.0f, (float)1.0f);
        }
        int n = entityHeadTexture = icon ? this.entityIconManager.getEntityHeadTexture(e, this.rotationFramebuffer, this.helper) : -1;
        if (entityHeadTexture != -1) {
            dotsScale = this.modMain.getSettings().headsScale;
            GL11.glScaled((double)dotsScale, (double)dotsScale, (double)1.0);
            float brightness = minimapRadar.getEntityBrightness(offh);
            class_4493.method_21950((int)1, (int)771, (int)1, (int)771);
            class_4493.method_22081((int)entityHeadTexture);
            class_4493.method_22000((float)brightness, (float)brightness, (float)brightness, (float)1.0f);
            this.helper.drawMyTexturedModalRect(-32.0f, -32.0f, 0, 64, 64.0f, 64.0f, -64.0f, 64.0f);
            this.mc.method_1531().method_22813(InterfaceRenderer.guiTextures);
            RenderSystem.blendFuncSeparate((int)770, (int)771, (int)1, (int)771);
        } else {
            dotsScale = this.modMain.getSettings().dotsScale;
            GL11.glScaled((double)dotsScale, (double)dotsScale, (double)1.0);
            int color = minimapRadar.getEntityColour(p, e, offh);
            float f = (float)(color >> 16 & 0xFF) / 255.0f;
            float f1 = (float)(color >> 8 & 0xFF) / 255.0f;
            float f2 = (float)(color & 0xFF) / 255.0f;
            RenderSystem.color4f((float)f, (float)f1, (float)f2, (float)1.0f);
            this.mc.method_1531().method_22813(InterfaceRenderer.guiTextures);
            RenderSystem.blendFuncSeparate((int)770, (int)771, (int)1, (int)771);
            if (this.modMain.getSettings().getSmoothDots()) {
                this.helper.drawMyTexturedModalRect(-3.5f, -3.5f, 1, 88, 8.0f, 8.0f, 256.0f);
            } else {
                this.helper.drawMyTexturedModalRect(-3.5f, -3.5f, 9, 77, 8.0f, 8.0f, 256.0f);
            }
        }
        if (name) {
            RenderSystem.pushMatrix();
            RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            String entityName = e.method_5476().getString();
            int nameW = this.mc.field_1772.method_1727(entityName);
            int offsetY = icon ? 11 : 5;
            double dotNameScale = this.modMain.getSettings().dotNameScale;
            class_4493.method_21999((float)0.0f, (float)offsetY, (float)0.0f);
            GL11.glScaled((double)(dotNameScale / dotsScale), (double)(dotNameScale / dotsScale), (double)1.0);
            Misc.drawPiercingText(matrixStack, entityName.replaceAll("(\u00a7[0-9a-f])+", ""), (float)(-nameW / 2 + 1), 1.0f, -12566464, false);
            Misc.drawPiercingText(matrixStack, entityName, (float)(-nameW / 2), 0.0f, -1, false);
            RenderSystem.enableBlend();
            RenderSystem.blendFuncSeparate((int)770, (int)771, (int)1, (int)771);
            class_4493.method_22021();
            class_4493.method_21945((int)516, (float)0.0f);
            RenderSystem.popMatrix();
            this.mc.method_1531().method_22813(InterfaceRenderer.guiTextures);
        }
        GL11.glPopMatrix();
    }

    public void deleteFramebuffers() {
        this.scalingFramebuffer.method_1238();
        this.rotationFramebuffer.method_1238();
        if (this.entityIconManager != null) {
            this.entityIconManager.reset();
        }
    }

    public boolean isLoadedFBO() {
        return this.loadedFBO;
    }

    public void setLoadedFBO(boolean loadedFBO) {
        this.loadedFBO = loadedFBO;
    }

    public boolean isTriedFBO() {
        return this.triedFBO;
    }

    public void resetEntityIcons() {
        if (this.entityIconManager != null) {
            this.entityIconManager.reset();
        }
    }
}

