/*
 * Decompiled with CFR 0.152.
 */
package xaero.common.minimap.render.radar;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_276;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_4493;
import net.minecraft.class_897;
import net.minecraft.class_898;
import xaero.common.minimap.render.MinimapRendererHelper;
import xaero.common.minimap.render.radar.EntityIconDefinitions;
import xaero.common.minimap.render.radar.EntityIconPrerenderer;

public class EntityIconManager {
    private EntityIconPrerenderer prerenderer;
    private Map<String, Integer> cachedTextures;

    public EntityIconManager(EntityIconPrerenderer prerenderer) {
        this.prerenderer = prerenderer;
        this.cachedTextures = new HashMap<String, Integer>();
    }

    protected String getSavedEntityId(class_1297 e) {
        class_1299 entityType = e.method_5864();
        class_2960 identifier = class_1299.method_5890((class_1299)entityType);
        return entityType.method_5893() && identifier != null ? identifier.toString() : null;
    }

    public <T extends class_1297> int getEntityHeadTexture(T entity, class_276 defaultFramebuffer, MinimapRendererHelper helper) {
        class_898 renderManager = class_310.method_1551().method_1561();
        class_897 entityRenderer = renderManager.method_3953(entity);
        String entityString = this.getSavedEntityId(entity) + "%" + EntityIconDefinitions.getVariantString(entityRenderer, entity);
        Integer cachedValue = this.cachedTextures.get(entityString);
        if (cachedValue == null) {
            cachedValue = this.prerenderer.prerender(entityRenderer, entity, defaultFramebuffer, helper);
            this.cachedTextures.put(entityString, cachedValue);
        }
        return cachedValue;
    }

    public void reset() {
        for (Integer value : this.cachedTextures.values()) {
            if (value == null || value <= 0) continue;
            class_4493.method_22079((int)value);
        }
        this.cachedTextures.clear();
        System.out.println("Entity icon manager reset!");
    }
}

