/*
 * Decompiled with CFR 0.152.
 */
package xaero.common.minimap.waypoints.render;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Collection;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import net.minecraft.class_1041;
import net.minecraft.class_1074;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_4587;
import org.lwjgl.opengl.GL11;
import xaero.common.AXaeroMinimap;
import xaero.common.XaeroMinimapSession;
import xaero.common.interfaces.render.InterfaceRenderer;
import xaero.common.minimap.waypoints.Waypoint;
import xaero.common.minimap.waypoints.WaypointSet;
import xaero.common.minimap.waypoints.WaypointsManager;
import xaero.common.misc.Misc;
import xaero.common.settings.ModSettings;

public class WaypointsGuiRenderer {
    private AXaeroMinimap modMain;
    private class_310 mc;

    public WaypointsGuiRenderer(AXaeroMinimap modMain, class_310 mc) {
        this.modMain = modMain;
        this.mc = mc;
    }

    public void render(XaeroMinimapSession minimapSession, class_4587 matrixStack, double playerX, double playerZ, int specW, int specH, double ps, double pc, float partial, double zoom, boolean circle) {
        WaypointsManager waypointsManager = minimapSession.getWaypointsManager();
        double dimDiv = waypointsManager.getDimensionDivision(waypointsManager.getCurrentContainerID());
        RenderSystem.disableDepthTest();
        if (this.modMain.getSettings().compassOverWaypoints) {
            this.drawWaypoints(waypointsManager, matrixStack, playerX, playerZ, specW, specH, ps, pc, partial, dimDiv, zoom, circle);
            this.drawCompass(matrixStack, specW, specH, ps, pc, zoom, circle);
        } else {
            this.drawCompass(matrixStack, specW, specH, ps, pc, zoom, circle);
            this.drawWaypoints(waypointsManager, matrixStack, playerX, playerZ, specW, specH, ps, pc, partial, dimDiv, zoom, circle);
        }
    }

    private void drawWaypoints(WaypointsManager waypointsManager, class_4587 matrixStack, double playerX, double playerZ, int specW, int specH, double ps, double pc, float partial, double dimDiv, double zoom, boolean circle) {
        if (this.modMain.getSettings().getShowWaypoints() && waypointsManager.getWaypoints() != null) {
            if (this.modMain.getSettings().renderAllSets) {
                HashMap<String, WaypointSet> sets = waypointsManager.getCurrentWorld().getSets();
                for (Map.Entry<String, WaypointSet> setEntry : sets.entrySet()) {
                    this.renderWaypointsList(matrixStack, setEntry.getValue().getList(), playerX, playerZ, specW, specH, ps, pc, dimDiv, zoom, circle);
                }
            } else {
                this.renderWaypointsList(matrixStack, waypointsManager.getWaypoints().getList(), playerX, playerZ, specW, specH, ps, pc, dimDiv, zoom, circle);
            }
        }
        Hashtable<String, Hashtable<Integer, Waypoint>> customWaypoints = WaypointsManager.customWaypoints;
        if (this.modMain.getSettings().getShowWaypoints() && !customWaypoints.isEmpty()) {
            for (Hashtable<Integer, Waypoint> modCustomWaypoints : customWaypoints.values()) {
                this.renderWaypointsList(matrixStack, modCustomWaypoints.values(), playerX, playerZ, specW, specH, ps, pc, dimDiv, zoom, circle);
            }
        }
    }

    private void renderWaypointsList(class_4587 matrixStack, Collection<Waypoint> list, double playerX, double playerZ, int specW, int specH, double ps, double pc, double dimDiv, double zoom, boolean circle) {
        for (Waypoint w : list) {
            if (w == null || w.isDisabled() || w.getType() == 1 && !this.modMain.getSettings().getDeathpoints()) continue;
            double offx = (double)w.getX(dimDiv) + 0.5 - playerX;
            double offz = (double)w.getZ(dimDiv) + 0.5 - playerZ;
            double distance = Math.sqrt(offx * offx + offz * offz);
            if (w.getType() == 0 && !w.isGlobal() && this.modMain.getSettings().waypointsDistance != 0.0 && distance > this.modMain.getSettings().waypointsDistance) continue;
            this.translatePosition(specW, specH, ps, pc, offx, offz, zoom, circle);
            RenderSystem.scalef((float)2.0f, (float)2.0f, (float)1.0f);
            this.drawIconOnGUI(matrixStack, w, this.modMain.getSettings(), 0, 0);
            GL11.glPopMatrix();
        }
    }

    private void drawCompass(class_4587 matrixStack, int specW, int specH, double ps, double pc, double zoom, boolean circle) {
        if (!this.modMain.getSettings().compass) {
            return;
        }
        String[] nesw = new String[]{"N", "E", "S", "W"};
        for (int i = 0; i < 4; ++i) {
            double offx;
            double d = i == 0 || i == 2 ? 0.0 : (offx = (double)(i == 1 ? 10000 : -10000));
            double offy = i == 1 || i == 3 ? 0.0 : (double)(i == 2 ? 10000 : -10000);
            this.translatePosition(specW, specH, ps, pc, offx, offy, zoom, circle);
            RenderSystem.scalef((float)2.0f, (float)2.0f, (float)1.0f);
            Misc.drawPiercingText(matrixStack, nesw[i], (float)(1 - this.mc.field_1772.method_1727(nesw[i]) / 2), -3.0f, -1, true);
            GL11.glPopMatrix();
        }
    }

    public void translatePosition(int specW, int specH, double ps, double pc, double offx, double offy, double zoom, boolean circle) {
        double X;
        double Y = (pc * offx + ps * offy) * zoom;
        double borderedX = X = (ps * offx - pc * offy) * zoom;
        double borderedY = Y;
        if (!circle) {
            if (borderedX > (double)specW) {
                borderedX = specW;
                borderedY = Y * (double)specW / X;
            } else if (borderedX < (double)(-specW)) {
                borderedX = -specW;
                borderedY = -Y * (double)specW / X;
            }
            if (borderedY > (double)specH) {
                borderedY = specH;
                borderedX = X * (double)specH / Y;
            } else if (borderedY < (double)(-specH)) {
                borderedY = -specH;
                borderedX = -X * (double)specH / Y;
            }
        } else {
            double distSquared = borderedX * borderedX + borderedY * borderedY;
            double maxDistSquared = specW * specW;
            if (distSquared > maxDistSquared) {
                double scaleDown = Math.sqrt(maxDistSquared / distSquared);
                borderedX *= scaleDown;
                borderedY *= scaleDown;
            }
        }
        GL11.glPushMatrix();
        RenderSystem.translated((double)(borderedX - 1.0), (double)(borderedY - 1.0), (double)0.0);
    }

    public void drawIconOnGUI(class_4587 matrixStack, Waypoint w, ModSettings settings, int drawX, int drawY) {
        if (w.getType() == 0) {
            int j = class_310.method_1551().field_1772.method_1727(w.getSymbol()) / 2;
            int addedFrame = j > 4 ? j - 4 : 0;
            int rectX1 = drawX - 4 - addedFrame;
            int rectY1 = drawY - 4 - addedFrame;
            int rectX2 = drawX + 5 + addedFrame;
            int rectY2 = drawY + 5 + addedFrame;
            int c = ModSettings.COLORS[w.getColor()];
            int r = c >> 16 & 0xFF;
            int g = c >> 8 & 0xFF;
            int b = c & 0xFF;
            int a = (int)(255.0f * ((float)settings.waypointOpacityMap / 100.0f));
            c = a << 24 | r << 16 | g << 8 | b;
            class_332.method_25294((class_4587)matrixStack, (int)rectX1, (int)rectY1, (int)rectX2, (int)rectY2, (int)c);
            Misc.drawPiercingText(matrixStack, w.getSymbol(), (float)(drawX + 1 - j), (float)(drawY - 3), -1, true);
        } else if (w.getType() == 1) {
            RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            class_310.method_1551().method_1531().method_22813(InterfaceRenderer.guiTextures);
            class_310.method_1551().field_1705.method_25302(matrixStack, drawX - 4, drawY - 4, 0, 78, 9, 9);
        }
    }

    public void drawSetChange(WaypointsManager waypointsManager, class_4587 matrixStack, class_1041 res) {
        if (waypointsManager.getWaypoints() != null && waypointsManager.setChanged != 0L) {
            int passed = (int)(System.currentTimeMillis() - waypointsManager.setChanged);
            if (passed < 1500) {
                int fadeTime = 300;
                boolean fading = passed > 1500 - fadeTime;
                int alpha = 3 + (int)(252.0f * (fading ? (float)(1500 - passed) / (float)fadeTime : 1.0f));
                int c = 0xFFFFFF | alpha << 24;
                Misc.drawCenteredPiercingText(matrixStack, class_1074.method_4662((String)waypointsManager.getWaypoints().getName(), (Object[])new Object[0]), (float)(res.method_4486() / 2), (float)(res.method_4502() / 2 + 50), c, true);
                RenderSystem.enableAlphaTest();
                RenderSystem.enableBlend();
                RenderSystem.blendFunc((int)770, (int)771);
            } else {
                waypointsManager.setChanged = 0L;
            }
        }
    }
}

